/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import glitchcore.event.village.VillagerTradesEvent;
import glitchcore.event.village.WandererTradesEvent;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3781;
import net.minecraft.class_3785;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_4158;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5497;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7477;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import toughasnails.api.block.TANBlocks;
import toughasnails.api.item.TANItems;
import toughasnails.api.village.TANPoiTypes;
import toughasnails.api.village.TANVillagerProfessions;

public class ModVillages {
    private static final class_3853.class_1652[] CLIMATOLOGIST_LEVEL_1_TRADES = new class_3853.class_1652[]{new ItemsForEmeralds(new class_1799((class_1935)TANItems.ICE_CREAM), 1, 2, 12, 1, 0.2f), new ItemsForEmeralds(new class_1799((class_1935)TANItems.CHARC_0S), 1, 2, 12, 1, 0.2f)};
    private static final class_3853.class_1652[] CLIMATOLOGIST_LEVEL_2_TRADES = new class_3853.class_1652[]{new ItemsForEmeralds(new class_1799((class_1935)class_2246.field_10225), 4, 8, 16, 1, 0.2f), new ItemsForEmeralds(new class_1799((class_1935)class_2246.field_10092), 4, 8, 16, 1, 0.2f), new EmeraldForItems((class_1935)class_2246.field_10225, 16, 10, 2), new EmeraldForItems((class_1935)class_2246.field_10092, 16, 10, 2)};
    private static final class_3853.class_1652[] CLIMATOLOGIST_LEVEL_3_TRADES = new class_3853.class_1652[]{new ItemsForEmeralds(new class_1799((class_1935)TANItems.WOOL_HELMET), 5, 1, 12, 3, 0.2f), new ItemsForEmeralds(new class_1799((class_1935)TANItems.WOOL_BOOTS), 4, 1, 12, 3, 0.2f), new ItemsForEmeralds(new class_1799((class_1935)TANItems.LEAF_HELMET), 5, 1, 12, 3, 0.2f), new ItemsForEmeralds(new class_1799((class_1935)TANItems.LEAF_BOOTS), 4, 1, 12, 3, 0.2f)};
    private static final class_3853.class_1652[] CLIMATOLOGIST_LEVEL_4_TRADES = new class_3853.class_1652[]{new ItemsForEmeralds(new class_1799((class_1935)TANItems.WOOL_CHESTPLATE), 7, 1, 12, 3, 0.2f), new ItemsForEmeralds(new class_1799((class_1935)TANItems.WOOL_LEGGINGS), 3, 1, 12, 3, 0.2f), new ItemsForEmeralds(new class_1799((class_1935)TANItems.LEAF_CHESTPLATE), 7, 1, 12, 3, 0.2f), new ItemsForEmeralds(new class_1799((class_1935)TANItems.LEAF_LEGGINGS), 3, 1, 12, 3, 0.2f)};
    private static final class_3853.class_1652[] CLIMATOLOGIST_LEVEL_5_TRADES = new class_3853.class_1652[]{new ItemsForEmeralds(new class_1799((class_1935)class_1802.field_27876), 4, 1, 10, 2, 0.2f), new ItemsForEmeralds(new class_1799((class_1935)class_1802.field_8187), 4, 1, 10, 2, 0.2f), new EmeraldForItems((class_1935)class_1802.field_8543, 16, 5, 1), new EmeraldForItems((class_1935)class_1802.field_8665, 16, 5, 1)};
    private static final Int2ObjectMap<class_3853.class_1652[]> CLIMATOLOGIST_TRADES = ModVillages.toIntMap((ImmutableMap<Integer, class_3853.class_1652[]>)ImmutableMap.of((Object)1, (Object)CLIMATOLOGIST_LEVEL_1_TRADES, (Object)2, (Object)CLIMATOLOGIST_LEVEL_2_TRADES, (Object)3, (Object)CLIMATOLOGIST_LEVEL_3_TRADES, (Object)4, (Object)CLIMATOLOGIST_LEVEL_4_TRADES, (Object)5, (Object)CLIMATOLOGIST_LEVEL_5_TRADES));
    private static final class_3853.class_1652[] WANDERING_TRADER_GENERIC = new class_3853.class_1652[]{new ItemsForEmeralds(TANItems.ICE_CREAM, 2, 1, 4, 1), new ItemsForEmeralds(TANItems.CHARC_0S, 2, 1, 4, 1), new ItemsForEmeralds(TANItems.GLOW_BERRY_JUICE, 2, 1, 4, 1), new ItemsForEmeralds(TANItems.SWEET_BERRY_JUICE, 2, 1, 4, 1), new ItemsForEmeralds(TANItems.PUMPKIN_JUICE, 2, 1, 3, 1), new ItemsForEmeralds(TANItems.MELON_JUICE, 3, 1, 3, 1), new ItemsForEmeralds(TANItems.APPLE_JUICE, 4, 1, 2, 1), new ItemsForEmeralds(TANItems.CACTUS_JUICE, 4, 1, 2, 1)};
    private static final class_3853.class_1652[] WANDERING_TRADER_RARE = new class_3853.class_1652[]{new ItemsForEmeralds(TANItems.CHORUS_FRUIT_JUICE, 5, 1, 1, 1), new ItemsForEmeralds(TANItems.PURIFIED_WATER_BOTTLE, 4, 1, 2, 1)};

    public static void addVillagerTrades(VillagerTradesEvent event) {
        if (event.getProfession() == TANVillagerProfessions.CLIMATOLOGIST) {
            for (int level = 1; level <= 5; ++level) {
                for (class_3853.class_1652 trade : (class_3853.class_1652[])CLIMATOLOGIST_TRADES.get(level)) {
                    if (event.getLevel() != level) continue;
                    event.getTrades().add(trade);
                }
            }
        }
    }

    public static void addWanderingVillagerTrades(WandererTradesEvent event) {
        event.addGenericTrades(Arrays.stream(WANDERING_TRADER_GENERIC).toList());
        event.addRareTrades(Arrays.stream(WANDERING_TRADER_RARE).toList());
    }

    public static void addBuildings(class_5455 registryAccess) {
        class_2378 templatePools = (class_2378)registryAccess.method_33310(class_7924.field_41249).get();
        class_2378 processorLists = (class_2378)registryAccess.method_33310(class_7924.field_41247).get();
        ModVillages.addBuildingToPool((class_2378<class_3785>)templatePools, (class_2378<class_5497>)processorLists, new class_2960("minecraft:village/desert/houses"), "toughasnails:village/desert/houses/desert_climatologist_1", 1);
        ModVillages.addBuildingToPool((class_2378<class_3785>)templatePools, (class_2378<class_5497>)processorLists, new class_2960("minecraft:village/savanna/houses"), "toughasnails:village/savanna/houses/savanna_climatologist_1", 2);
        ModVillages.addBuildingToPool((class_2378<class_3785>)templatePools, (class_2378<class_5497>)processorLists, new class_2960("minecraft:village/plains/houses"), "toughasnails:village/plains/houses/plains_climatologist_1", 2);
        ModVillages.addBuildingToPool((class_2378<class_3785>)templatePools, (class_2378<class_5497>)processorLists, new class_2960("minecraft:village/taiga/houses"), "toughasnails:village/taiga/houses/taiga_climatologist_1", 3);
        ModVillages.addBuildingToPool((class_2378<class_3785>)templatePools, (class_2378<class_5497>)processorLists, new class_2960("minecraft:village/snowy/houses"), "toughasnails:village/snowy/houses/snowy_climatologist_1", 2);
    }

    public static void registerPointsOfInterest(BiConsumer<class_2960, class_4158> func) {
        ModVillages.register(func, TANPoiTypes.CLIMATOLOGIST, ModVillages.getBlockStates(TANBlocks.THERMOREGULATOR), 1, 1);
    }

    public static void registerProfessions(BiConsumer<class_2960, class_3852> func) {
        TANVillagerProfessions.CLIMATOLOGIST = ModVillages.register(func, "climatologist", TANPoiTypes.CLIMATOLOGIST, class_3417.field_20669);
    }

    private static Int2ObjectMap<class_3853.class_1652[]> toIntMap(ImmutableMap<Integer, class_3853.class_1652[]> p_221238_0_) {
        return new Int2ObjectOpenHashMap(p_221238_0_);
    }

    public static void addBuildingToPool(class_2378<class_3785> templatePoolRegistry, class_2378<class_5497> processorListRegistry, class_2960 poolRL, String nbtPieceRL, int weight) {
        class_3785 pool = (class_3785)templatePoolRegistry.method_10223(poolRL);
        if (pool == null) {
            return;
        }
        class_2960 emptyProcessor = new class_2960("minecraft", "empty");
        class_6880.class_6883 processorHolder = processorListRegistry.method_40290(class_5321.method_29179((class_5321)class_7924.field_41247, (class_2960)emptyProcessor));
        class_3781 piece = (class_3781)class_3781.method_30435((String)nbtPieceRL, (class_6880)processorHolder).apply(class_3785.class_3786.field_16687);
        for (int i = 0; i < weight; ++i) {
            pool.field_16680.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.field_16864);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.field_16864 = listOfPieceEntries;
    }

    private static class_4158 register(BiConsumer<class_2960, class_4158> func, class_5321<class_4158> key, Set<class_2680> states, int maxTickets, int validRange) {
        class_4158 type = new class_4158(states, maxTickets, validRange);
        func.accept(key.method_29177(), type);
        ModVillages.registerBlockStates(key, states);
        return type;
    }

    private static class_3852 register(BiConsumer<class_2960, class_3852> func, String name, class_5321<class_4158> poi, @Nullable class_3414 workSound) {
        return ModVillages.register(func, name, (class_6880<class_4158> h) -> h.method_40225(poi), h -> h.method_40225(poi), workSound);
    }

    private static class_3852 register(BiConsumer<class_2960, class_3852> func, String name, Predicate<class_6880<class_4158>> heldJobSite, Predicate<class_6880<class_4158>> acquirableJobSite, @Nullable class_3414 workSound) {
        return ModVillages.register(func, name, heldJobSite, acquirableJobSite, (ImmutableSet<class_1792>)ImmutableSet.of(), (ImmutableSet<class_2248>)ImmutableSet.of(), workSound);
    }

    private static class_3852 register(BiConsumer<class_2960, class_3852> func, String name, class_5321<class_4158> poi, ImmutableSet<class_1792> requestedItems, ImmutableSet<class_2248> secondaryPoi, @Nullable class_3414 workSound) {
        return ModVillages.register(func, name, $$1x -> $$1x.method_40225(poi), $$1x -> $$1x.method_40225(poi), requestedItems, secondaryPoi, workSound);
    }

    private static class_3852 register(BiConsumer<class_2960, class_3852> func, String name, Predicate<class_6880<class_4158>> heldJobSite, Predicate<class_6880<class_4158>> acquirableJobSite, ImmutableSet<class_1792> requestedItems, ImmutableSet<class_2248> secondaryPoi, @Nullable class_3414 workSound) {
        return ModVillages.register(func, name, new class_3852("toughasnails:" + name, heldJobSite, acquirableJobSite, requestedItems, secondaryPoi, workSound));
    }

    private static class_3852 register(BiConsumer<class_2960, class_3852> func, String name, class_3852 profession) {
        func.accept(new class_2960("toughasnails", name), profession);
        return profession;
    }

    private static Set<class_2680> getBlockStates(class_2248 block) {
        return ImmutableSet.copyOf((Collection)block.method_9595().method_11662());
    }

    private static void registerBlockStates(class_5321<class_4158> key, Set<class_2680> states) {
        class_6880.class_6883 holder = class_7923.field_41128.method_40290(key);
        states.forEach(state -> {
            if (!class_7477.method_46397((class_2680)state)) {
                class_7477.method_43990((class_6880)holder, Set.of(state));
            }
        });
    }

    static class ItemsForEmeralds
    implements class_3853.class_1652 {
        private final class_1799 itemStack;
        private final int emeraldCost;
        private final int numberOfItems;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public ItemsForEmeralds(class_1792 p_35746_, int p_35747_, int p_35748_, int p_35749_, int p_35750_) {
            this(new class_1799((class_1935)p_35746_), p_35747_, p_35748_, p_35749_, p_35750_);
        }

        public ItemsForEmeralds(class_1799 p_35752_, int p_35753_, int p_35754_, int p_35755_, int p_35756_) {
            this(p_35752_, p_35753_, p_35754_, p_35755_, p_35756_, 0.05f);
        }

        public ItemsForEmeralds(class_1799 p_35758_, int p_35759_, int p_35760_, int p_35761_, int p_35762_, float p_35763_) {
            this.itemStack = p_35758_;
            this.emeraldCost = p_35759_;
            this.numberOfItems = p_35760_;
            this.maxUses = p_35761_;
            this.villagerXp = p_35762_;
            this.priceMultiplier = p_35763_;
        }

        public class_1914 method_7246(class_1297 p_219699_, class_5819 p_219700_) {
            return new class_1914(new class_1799((class_1935)class_1802.field_8687, this.emeraldCost), new class_1799((class_1935)this.itemStack.method_7909(), this.numberOfItems), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    static class EmeraldForItems
    implements class_3853.class_1652 {
        private final class_1792 item;
        private final int cost;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public EmeraldForItems(class_1935 p_35657_, int p_35658_, int p_35659_, int p_35660_) {
            this.item = p_35657_.method_8389();
            this.cost = p_35658_;
            this.maxUses = p_35659_;
            this.villagerXp = p_35660_;
            this.priceMultiplier = 0.05f;
        }

        public class_1914 method_7246(class_1297 p_219682_, class_5819 p_219683_) {
            class_1799 itemstack = new class_1799((class_1935)this.item, this.cost);
            return new class_1914(itemstack, new class_1799((class_1935)class_1802.field_8687), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }
}

