/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_3545;
import toughasnails.api.temperature.IPlayerTemperatureModifier;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.init.ModConfig;
import toughasnails.temperature.TemperatureHelperImpl;

public enum BuiltInTemperatureModifier {
    PLAYER_MODIFIERS((player, currentTarget, currentChangeDelay) -> {
        TemperatureLevel newTarget = currentTarget;
        int newChangeDelay = currentChangeDelay;
        for (IPlayerTemperatureModifier modifier : TemperatureHelperImpl.playerModifiers) {
            newTarget = modifier.modify(player, newTarget);
        }
        if (newTarget != currentTarget) {
            newChangeDelay = Math.min(currentChangeDelay, ModConfig.temperature.playerTemperatureChangeDelay);
        }
        return new class_3545((Object)newTarget, (Object)newChangeDelay);
    }),
    ITEM_MODIFIER((player, currentTarget, currentChangeDelay) -> {
        int newChangeDelay = currentChangeDelay;
        TemperatureLevel newTarget = TemperatureHelperImpl.handheldModifier(player, currentTarget);
        if (newTarget != currentTarget) {
            newChangeDelay = Math.min(currentChangeDelay, ModConfig.temperature.handheldTemperatureChangeDelay);
        }
        return new class_3545((Object)newTarget, (Object)newChangeDelay);
    }),
    ARMOR_MODIFIER((player, currentTarget, currentChangeDelay) -> {
        int newChangeDelay = currentChangeDelay;
        TemperatureLevel newTarget = TemperatureHelperImpl.armorModifier(player, currentTarget);
        if (newTarget != currentTarget) {
            newChangeDelay = Math.min(currentChangeDelay, ModConfig.temperature.armorTemperatureChangeDelay);
        }
        return new class_3545((Object)newTarget, (Object)newChangeDelay);
    }),
    INTERNAL_MODIFIER((player, currentTarget, currentChangeDelay) -> {
        int newChangeDelay = currentChangeDelay;
        TemperatureLevel newTarget = TemperatureHelperImpl.internalModifier(player, currentTarget);
        if (newTarget != currentTarget) {
            newChangeDelay = Math.min(currentChangeDelay, ModConfig.temperature.internalTemperatureChangeDelay);
        }
        return new class_3545((Object)newTarget, (Object)newChangeDelay);
    });

    private final Modifier modifier;
    private static List<BuiltInTemperatureModifier> temperatureModifierOrderCache;

    private BuiltInTemperatureModifier(Modifier modifier) {
        this.modifier = modifier;
    }

    public class_3545<TemperatureLevel, Integer> apply(class_1657 player, TemperatureLevel currentTarget, int currentChangeDelay) {
        return this.modifier.apply(player, currentTarget, currentChangeDelay);
    }

    public static List<BuiltInTemperatureModifier> getTemperatureModifierOrder() {
        if (temperatureModifierOrderCache == null) {
            temperatureModifierOrderCache = ModConfig.temperature.temperatureModifierOrder.stream().map(s -> BuiltInTemperatureModifier.valueOf(s.toUpperCase())).toList();
        }
        return temperatureModifierOrderCache;
    }

    private static interface Modifier {
        public class_3545<TemperatureLevel, Integer> apply(class_1657 var1, TemperatureLevel var2, int var3);
    }
}

