/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.init.ModConfig;

public class TemperatureData
implements ITemperature {
    public static final TemperatureLevel DEFAULT_LEVEL = TemperatureLevel.NEUTRAL;
    private TemperatureLevel level = DEFAULT_LEVEL;
    private TemperatureLevel targetLevel = DEFAULT_LEVEL;
    private int positionalChangeDelayTicks;
    private int ticksHyperthermic;
    private int ticksDry;
    private int extremityDelayTicks;
    private Set<class_2338> nearbyThermoregulators = new HashSet<class_2338>();
    private TemperatureLevel lastTemperature = DEFAULT_LEVEL;
    private int lastHyperthermiaTicks;
    private Set<class_2338> lastNearbyThermoregulators = new HashSet<class_2338>();

    public void addAdditionalSaveData(class_2487 nbt) {
        if (ModConfig.temperature.enableTemperature) {
            nbt.method_10569("temperatureLevel", this.getLevel().ordinal());
            nbt.method_10569("targetTemperatureLevel", this.getTargetLevel().ordinal());
            nbt.method_10569("changeDelayTicks", this.getChangeDelayTicks());
            nbt.method_10569("hyperthermiaTicks", this.getHyperthermiaTicks());
            nbt.method_10569("extremityDelayTicks", this.getExtremityDelayTicks());
            nbt.method_10569("dryTicks", this.getDryTicks());
        } else {
            nbt.method_10569("temperatureLevel", DEFAULT_LEVEL.ordinal());
            nbt.method_10569("targetTemperatureLevel", DEFAULT_LEVEL.ordinal());
            nbt.method_10569("changeDelayTicks", 0);
            nbt.method_10569("hyperthermiaTicks", 0);
            nbt.method_10569("extremityDelayTicks", 0);
            nbt.method_10569("dryTicks", 0);
        }
    }

    public void readAdditionalSaveData(class_2487 nbt) {
        if (nbt.method_10573("temperatureLevel", 99)) {
            if (ModConfig.temperature.enableTemperature) {
                this.setLevel(TemperatureLevel.values()[nbt.method_10550("temperatureLevel")]);
                this.setTargetLevel(TemperatureLevel.values()[nbt.method_10550("targetTemperatureLevel")]);
                this.setChangeDelayTicks(nbt.method_10550("changeDelayTicks"));
                this.setHyperthermiaTicks(nbt.method_10550("hyperthermiaTicks"));
                this.setExtremityDelayTicks(nbt.method_10550("extremityDelayTicks"));
            } else {
                this.setLevel(DEFAULT_LEVEL);
                this.setTargetLevel(DEFAULT_LEVEL);
                this.setChangeDelayTicks(0);
                this.setHyperthermiaTicks(0);
                this.setExtremityDelayTicks(0);
                this.setDryTicks(0);
            }
        }
    }

    @Override
    public TemperatureLevel getLevel() {
        return this.level;
    }

    @Override
    public int getHyperthermiaTicks() {
        return this.ticksHyperthermic;
    }

    @Override
    public int getExtremityDelayTicks() {
        return this.extremityDelayTicks;
    }

    @Override
    public int getDryTicks() {
        return this.ticksDry;
    }

    @Override
    public TemperatureLevel getLastLevel() {
        return this.lastTemperature;
    }

    @Override
    public TemperatureLevel getTargetLevel() {
        return this.targetLevel;
    }

    @Override
    public int getChangeDelayTicks() {
        return this.positionalChangeDelayTicks;
    }

    @Override
    public int getLastHyperthermiaTicks() {
        return this.lastHyperthermiaTicks;
    }

    @Override
    public Set<class_2338> getLastNearbyThermoregulators() {
        return this.lastNearbyThermoregulators;
    }

    @Override
    public Set<class_2338> getNearbyThermoregulators() {
        return this.nearbyThermoregulators;
    }

    @Override
    public void setLevel(TemperatureLevel level) {
        this.level = level;
    }

    @Override
    public void setHyperthermiaTicks(int ticks) {
        this.ticksHyperthermic = ticks;
    }

    @Override
    public void setExtremityDelayTicks(int ticks) {
        this.extremityDelayTicks = ticks;
    }

    @Override
    public void setDryTicks(int ticks) {
        this.ticksDry = ticks;
    }

    @Override
    public void setLastLevel(TemperatureLevel level) {
        this.lastTemperature = level;
    }

    @Override
    public void setTargetLevel(TemperatureLevel level) {
        this.targetLevel = level;
    }

    @Override
    public void setChangeDelayTicks(int ticks) {
        this.positionalChangeDelayTicks = ticks;
    }

    @Override
    public void setLastHyperthermiaTicks(int ticks) {
        this.lastHyperthermiaTicks = ticks;
    }

    @Override
    public void setLastNearbyThermoregulators(Set<class_2338> values) {
        this.lastNearbyThermoregulators = values;
    }

    @Override
    public void setNearbyThermoregulators(Set<class_2338> values) {
        this.nearbyThermoregulators = values;
    }
}

