/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import glitchcore.event.entity.LivingEntityUseItemEvent;
import glitchcore.event.player.PlayerEvent;
import glitchcore.network.CustomPacket;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_5134;
import toughasnails.api.damagesource.TANDamageTypes;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.init.ModConfig;
import toughasnails.init.ModPackets;
import toughasnails.init.ModTags;
import toughasnails.network.UpdateTemperaturePacket;
import toughasnails.temperature.BuiltInTemperatureModifier;
import toughasnails.temperature.TemperatureData;

public class TemperatureHandler {
    private static final UUID SPEED_MODIFIER_HYPERTHERMIA_UUID = UUID.fromString("30b6ca4e-c6df-4532-80db-1d024765b56b");

    public static void onPlayerTick(class_1657 player) {
        if (!ModConfig.temperature.enableTemperature || player.method_37908().method_8608()) {
            return;
        }
        class_1937 level = player.method_37908();
        ITemperature data = TemperatureHelper.getTemperatureData(player);
        data.getNearbyThermoregulators().removeIf(pos -> level.method_8321(pos) == null || player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) > 1024.0);
        data.setChangeDelayTicks(Math.max(0, data.getChangeDelayTicks() - 1));
        data.setDryTicks(data.getDryTicks() + 1);
        if (!player.method_6059(TANEffects.CLIMATE_CLEMENCY)) {
            int changeDelay = ModConfig.temperature.temperatureChangeDelay;
            TemperatureLevel currentTargetLevel = data.getTargetLevel();
            TemperatureLevel newTargetLevel = TemperatureHelper.getTemperatureAtPos(player.method_37908(), player.method_24515());
            for (BuiltInTemperatureModifier modifier : BuiltInTemperatureModifier.getTemperatureModifierOrder()) {
                class_3545<TemperatureLevel, Integer> output = modifier.apply(player, newTargetLevel, changeDelay);
                newTargetLevel = (TemperatureLevel)((Object)output.method_15442());
                changeDelay = (Integer)output.method_15441();
            }
            if (newTargetLevel != currentTargetLevel) {
                data.setTargetLevel(newTargetLevel);
                if ((data.getLevel() == TemperatureLevel.ICY || data.getLevel() == TemperatureLevel.HOT) && newTargetLevel != TemperatureLevel.ICY && newTargetLevel != TemperatureLevel.HOT) {
                    changeDelay = Math.min(changeDelay, ModConfig.temperature.extremityReboundTemperatureChangeDelay);
                }
                data.setChangeDelayTicks(changeDelay);
            }
            if (data.getChangeDelayTicks() == 0 && currentTargetLevel != data.getLevel()) {
                data.setLevel(data.getLevel().increment(class_3532.method_17822((double)(data.getTargetLevel().ordinal() - data.getLevel().ordinal()))));
                data.setChangeDelayTicks(changeDelay);
            }
        } else {
            data.setLevel(TemperatureLevel.NEUTRAL);
        }
        data.setExtremityDelayTicks(Math.max(0, data.getExtremityDelayTicks() - 1));
        if (data.getLastLevel() != data.getLevel() && (data.getLevel() == TemperatureLevel.ICY || data.getLevel() == TemperatureLevel.HOT)) {
            data.setExtremityDelayTicks(ModConfig.temperature.extremityDamageDelay);
        }
        int hyperthermicTicks = data.getHyperthermiaTicks();
        int ticksToHyperthermia = TemperatureHelper.getTicksRequiredForHyperthermia();
        if (!player.method_7337() && !player.method_7325()) {
            if (!player.method_6059(class_1294.field_5918) && data.getLevel() == TemperatureLevel.HOT && data.getExtremityDelayTicks() == 0) {
                data.setHyperthermiaTicks(Math.min(ticksToHyperthermia, hyperthermicTicks + 1));
            } else {
                data.setHyperthermiaTicks(Math.max(0, hyperthermicTicks - 2));
            }
        } else if (data.getHyperthermiaTicks() > 0) {
            data.setHyperthermiaTicks(Math.max(0, hyperthermicTicks - 2));
        }
        TemperatureHandler.removeHeatExhaustion(player);
        TemperatureHandler.tryAddHeatExhaustion(player);
        if (player.field_6012 % 40 == 0 && TemperatureHelper.isFullyHyperthermic(player)) {
            player.method_5643(player.method_48923().method_48795(TANDamageTypes.HYPERTHERMIA), 1.0f);
        }
    }

    public static void onChangeDimension(PlayerEvent.ChangeDimension event) {
        ITemperature temperature = TemperatureHelper.getTemperatureData(event.getPlayer());
        temperature.setLastLevel(TemperatureData.DEFAULT_LEVEL);
        temperature.setLastHyperthermiaTicks(0);
        temperature.setLastNearbyThermoregulators(new HashSet<class_2338>());
    }

    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (!ModConfig.temperature.enableTemperature || !(event.getEntity() instanceof class_1657) || event.getEntity().method_37908().method_8608()) {
            return;
        }
        class_1657 player = (class_1657)event.getEntity();
        class_1799 item = event.getItem();
        if (item.method_31573(ModTags.Items.COOLING_CONSUMED_ITEMS)) {
            player.method_6092(new class_1293(TANEffects.INTERNAL_CHILL, ModConfig.temperature.consumableEffectDuration, 0, false, false, true));
        }
        if (item.method_31573(ModTags.Items.HEATING_CONSUMED_ITEMS)) {
            player.method_6092(new class_1293(TANEffects.INTERNAL_WARMTH, ModConfig.temperature.consumableEffectDuration, 0, false, false, true));
        }
    }

    public static void syncTemperature(class_3222 player) {
        ITemperature temperature = TemperatureHelper.getTemperatureData((class_1657)player);
        ModPackets.HANDLER.sendToPlayer((CustomPacket)new UpdateTemperaturePacket(temperature.getLevel(), temperature.getHyperthermiaTicks(), temperature.getNearbyThermoregulators()), player);
        temperature.setLastLevel(temperature.getLevel());
        temperature.setLastHyperthermiaTicks(temperature.getHyperthermiaTicks());
        temperature.setNearbyThermoregulators(temperature.getNearbyThermoregulators());
    }

    private static void removeHeatExhaustion(class_1657 player) {
        class_1324 attribute = player.method_5996(class_5134.field_23719);
        if (attribute != null && attribute.method_6199(SPEED_MODIFIER_HYPERTHERMIA_UUID) != null) {
            attribute.method_6200(SPEED_MODIFIER_HYPERTHERMIA_UUID);
        }
    }

    protected static void tryAddHeatExhaustion(class_1657 player) {
        int ticks;
        if (!player.method_37908().method_8320(player.method_23312()).method_26215() && (ticks = TemperatureHelper.getTicksHyperthermic(player)) > 0) {
            class_1324 attributeinstance = player.method_5996(class_5134.field_23719);
            if (attributeinstance == null) {
                return;
            }
            float f = 0.015f * TemperatureHelper.getPercentHyperthermic(player);
            attributeinstance.method_26835(new class_1322(SPEED_MODIFIER_HYPERTHERMIA_UUID, "Hyperthermia slow", (double)f, class_1322.class_1323.field_6328));
        }
    }
}

