/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import glitchcore.event.TickEvent;
import glitchcore.event.client.RenderGuiEvent;
import glitchcore.util.GuiUtils;
import java.util.Random;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_746;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.init.ModConfig;

public class TemperatureOverlayRenderer {
    private static final Random RANDOM = new Random();
    public static final class_2960 OVERLAY = new class_2960("toughasnails:textures/gui/icons.png");
    private static final class_2960 HYPERTHERMIA_OUTLINE_LOCATION = new class_2960("toughasnails", "textures/misc/hyperthermia_outline.png");
    private static long updateCounter;
    private static long flashCounter;
    private static long arrowCounter;
    private static ArrowDirection arrowDirection;
    private static TemperatureLevel prevTemperatureLevel;

    public static void onBeginRenderFood(RenderGuiEvent.Pre event) {
        if (event.getType() != RenderGuiEvent.Type.FOOD) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        if (!minecraft.field_1690.field_1842 && GuiUtils.shouldDrawSurvivalElements()) {
            GuiUtils.setupOverlayRenderState((boolean)true, (boolean)false);
            TemperatureOverlayRenderer.renderTemperature(event.getGuiGraphics(), event.getPartialTicks(), event.getScreenWidth(), event.getScreenHeight());
        }
    }

    public static void onBeginRenderFrostbite(RenderGuiEvent.Pre event) {
        if (event.getType() != RenderGuiEvent.Type.FROSTBITE) {
            return;
        }
        GuiUtils.setupOverlayRenderState((boolean)true, (boolean)false);
        class_329 gui = event.getGui();
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        if (TemperatureHelper.getTicksHyperthermic((class_1657)player) > 0) {
            gui.method_31977(event.getGuiGraphics(), HYPERTHERMIA_OUTLINE_LOCATION, TemperatureHelper.getPercentHyperthermic((class_1657)player));
        }
    }

    public static void onClientTick(TickEvent.Client event) {
        class_310 minecraft = class_310.method_1551();
        if (event.getPhase() == TickEvent.Phase.END && !minecraft.method_1493()) {
            ++updateCounter;
        }
    }

    public static void renderTemperature(class_332 guiGraphics, float partialTicks, int width, int height) {
        class_310 minecraft = class_310.method_1551();
        if (!ModConfig.temperature.enableTemperature) {
            return;
        }
        class_746 player = minecraft.field_1724;
        TemperatureLevel temperature = TemperatureHelper.getTemperatureForPlayer((class_1657)player);
        RANDOM.setSeed(updateCounter * 312871L);
        if (minecraft.field_1761.method_2920().method_8388()) {
            TemperatureOverlayRenderer.drawTemperature(guiGraphics, width, height, temperature);
        }
    }

    private static void drawTemperature(class_332 gui, int width, int height, TemperatureLevel temperature) {
        int left = width / 2 - 8 + ModConfig.client.temperatureLeftOffset;
        int top = height - 52 + ModConfig.client.temperatureTopOffset;
        if (prevTemperatureLevel == null) {
            prevTemperatureLevel = temperature;
        }
        if (updateCounter > arrowCounter) {
            arrowDirection = null;
        }
        if (prevTemperatureLevel != temperature) {
            flashCounter = updateCounter + 3L;
            arrowCounter = updateCounter + 15L;
            if (temperature.compareTo(prevTemperatureLevel) > 0) {
                arrowDirection = ArrowDirection.UP;
            } else if (temperature.compareTo(prevTemperatureLevel) < 0) {
                arrowDirection = ArrowDirection.DOWN;
            }
        }
        prevTemperatureLevel = temperature;
        if ((temperature == TemperatureLevel.ICY || temperature == TemperatureLevel.HOT) && updateCounter % 1L == 0L) {
            top += (int)((double)(RANDOM.nextInt(3) - 1) * Math.min(3.0, 1.0));
            left += (int)((double)(RANDOM.nextInt(3) - 1) * Math.min(1.5, 1.0));
        }
        int iconIndex = temperature.ordinal() * 16;
        int v = 0;
        if (flashCounter > updateCounter) {
            v += 16;
        }
        gui.method_25302(OVERLAY, left, top, iconIndex, v, 16, 16);
        if (arrowDirection != null) {
            gui.method_25302(OVERLAY, left, top, arrowDirection.getU(15 - (int)(arrowCounter - updateCounter)), arrowDirection.getV(), 16, 16);
        }
    }

    private static enum ArrowDirection {
        UP(224),
        DOWN(240);

        private final int v;

        private ArrowDirection(int v) {
            this.v = v;
        }

        public int getU(int frame) {
            return frame * 16;
        }

        public int getV() {
            return this.v;
        }
    }
}

