/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.thirst;

import glitchcore.event.TickEvent;
import glitchcore.event.entity.LivingEntityUseItemEvent;
import glitchcore.event.player.PlayerEvent;
import glitchcore.event.player.PlayerInteractEvent;
import glitchcore.network.CustomPacket;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5328;
import net.minecraft.class_6880;
import toughasnails.api.damagesource.TANDamageTypes;
import toughasnails.api.item.TANItems;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.init.ModConfig;
import toughasnails.init.ModPackets;
import toughasnails.init.ModTags;
import toughasnails.network.DrinkInWorldPacket;
import toughasnails.network.UpdateThirstPacket;
import toughasnails.temperature.TemperatureData;

public class ThirstHandler {
    private static final int IN_WORLD_DRINK_COOLDOWN = 60;
    private static int inWorldDrinkTimer = 0;

    public static void onPlayerTick(class_1657 player) {
        if (!ModConfig.thirst.enableThirst || player.method_37908().method_8608()) {
            return;
        }
        IThirst thirst = ThirstHelper.getThirst(player);
        class_1267 difficulty = player.method_37908().method_8407();
        double exhaustionThreshold = ModConfig.thirst.thirstExhaustionThreshold;
        if ((double)thirst.getExhaustion() > exhaustionThreshold) {
            thirst.addExhaustion((float)(-exhaustionThreshold));
            if (thirst.getHydration() > 0.0f) {
                thirst.setHydration(Math.max(thirst.getHydration() - 1.0f, 0.0f));
            } else if (difficulty != class_1267.field_5801) {
                thirst.setThirst(Math.max(thirst.getThirst() - 1, 0));
            }
        }
        if (thirst.getThirst() <= 0) {
            thirst.addTicks(1);
            if (thirst.getTickTimer() >= 80) {
                if (player.method_6032() > 10.0f || difficulty == class_1267.field_5807 || player.method_6032() > 1.0f && difficulty == class_1267.field_5802) {
                    player.method_5643(player.method_48923().method_48795(TANDamageTypes.THIRST), 1.0f);
                }
                thirst.setTickTimer(0);
            }
        } else {
            thirst.setTickTimer(0);
        }
        if (difficulty == class_1267.field_5801 && player.method_37908().method_8450().method_8355(class_1928.field_19395) && thirst.isThirsty() && player.field_6012 % 10 == 0) {
            thirst.setThirst(thirst.getThirst() + 1);
        }
    }

    public static void onChangeDimension(PlayerEvent.ChangeDimension event) {
        ITemperature temperature = TemperatureHelper.getTemperatureData(event.getPlayer());
        temperature.setLastLevel(TemperatureData.DEFAULT_LEVEL);
        temperature.setLastHyperthermiaTicks(0);
    }

    public static void syncThirst(class_3222 player) {
        IThirst thirst = ThirstHelper.getThirst((class_1657)player);
        ModPackets.HANDLER.sendToPlayer((CustomPacket)new UpdateThirstPacket(thirst.getThirst(), thirst.getHydration()), player);
        thirst.setLastThirst(thirst.getThirst());
        thirst.setLastHydrationZero(thirst.getHydration() == 0.0f);
    }

    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (!ModConfig.thirst.enableThirst || !(event.getEntity() instanceof class_1657) || event.getEntity().method_37908().method_8608()) {
            return;
        }
        class_1657 player = (class_1657)event.getEntity();
        class_1799 drink = event.getItem();
        IThirst thirst = ThirstHelper.getThirst(player);
        if (drink.method_31573(ModTags.Items.DRINKS)) {
            int drink_thirst = ModTags.Items.getThirstRestored(drink);
            float drink_hydration = 0.0f;
            float drink_poison_chance = 0.0f;
            if (drink.method_31573(ModTags.Items.TEN_HYDRATION_DRINKS)) {
                drink_hydration = 0.1f;
            }
            if (drink.method_31573(ModTags.Items.TWENTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.2f;
            }
            if (drink.method_31573(ModTags.Items.THIRTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.3f;
            }
            if (drink.method_31573(ModTags.Items.FOURTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.4f;
            }
            if (drink.method_31573(ModTags.Items.FIFTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.5f;
            }
            if (drink.method_31573(ModTags.Items.SIXTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.6f;
            }
            if (drink.method_31573(ModTags.Items.SEVENTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.7f;
            }
            if (drink.method_31573(ModTags.Items.EIGHTY_HYDRATION_DRINKS)) {
                drink_hydration = 0.8f;
            }
            if (drink.method_31573(ModTags.Items.NINETY_HYDRATION_DRINKS)) {
                drink_hydration = 0.9f;
            }
            if (drink.method_31573(ModTags.Items.ONE_HUNDRED_HYDRATION_DRINKS)) {
                drink_hydration = 1.0f;
            }
            if (drink.method_31573(ModTags.Items.TWENTY_FIVE_POISON_CHANCE_DRINKS)) {
                drink_poison_chance = 0.25f;
            }
            if (drink.method_31573(ModTags.Items.FIFTY_POISON_CHANCE_DRINKS)) {
                drink_poison_chance = 0.5f;
            }
            if (drink.method_31573(ModTags.Items.SEVENTY_FIVE_POISON_CHANCE_DRINKS)) {
                drink_poison_chance = 0.75f;
            }
            if (drink.method_31573(ModTags.Items.ONE_HUNDRED_POISON_CHANCE_DRINKS)) {
                drink_poison_chance = 1.0f;
            }
            thirst.drink(drink_thirst, drink_hydration);
            if (player.method_37908().field_9229.method_43057() < drink_poison_chance) {
                player.method_6092(new class_1293(TANEffects.THIRST, 600));
            }
        }
    }

    public static void onPlayerUseItem(PlayerInteractEvent.UseItem event) {
        class_1657 player = event.getPlayer();
        class_1937 level = player.method_37908();
        class_1268 hand = event.getHand();
        class_1799 stack = player.method_5998(hand);
        class_1792 item = stack.method_7909();
        if (item != class_1802.field_8469) {
            return;
        }
        class_3965 rayTraceResult = class_1792.method_7872((class_1937)level, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1345);
        if (rayTraceResult.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        class_2338 pos = rayTraceResult.method_17777();
        if (!level.method_8505(player, pos) || !level.method_8316(pos).method_15767(class_3486.field_15517)) {
            return;
        }
        level.method_43128(player, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14779, class_3419.field_15254, 1.0f, 1.0f);
        class_6880 biome = level.method_23753(pos);
        class_1799 filledStack = biome.method_40220(ModTags.Biomes.DIRTY_WATER_BIOMES) ? new class_1799((class_1935)TANItems.DIRTY_WATER_BOTTLE) : (biome.method_40220(ModTags.Biomes.PURIFIED_WATER_BIOMES) ? new class_1799((class_1935)TANItems.PURIFIED_WATER_BOTTLE) : class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)class_1847.field_8991));
        player.method_7259(class_3468.field_15372.method_14956((Object)item));
        class_1799 replacementStack = class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)filledStack);
        event.setCancelResult(class_1271.method_29237((Object)replacementStack, (boolean)level.method_8608()));
        event.setCancelled(true);
    }

    public static void onUseBlock(PlayerInteractEvent.UseBlock event) {
        if (ThirstHandler.canHandDrink() && ThirstHandler.canHandDrinkInWorld(event.getPlayer(), event.getHand())) {
            ThirstHandler.tryDrinkWaterInWorld(event.getPlayer());
        }
    }

    public static void onUseEmpty(PlayerInteractEvent.UseEmpty event) {
        if (ThirstHandler.canHandDrink() && ThirstHandler.canHandDrinkInWorld(event.getPlayer(), event.getHand())) {
            ThirstHandler.tryDrinkWaterInWorld(event.getPlayer());
        }
    }

    public static void onClientTick(TickEvent.Client event) {
        if (inWorldDrinkTimer > 0) {
            --inWorldDrinkTimer;
        }
    }

    private static boolean canHandDrink() {
        return ModConfig.thirst.enableThirst && ModConfig.thirst.enableHandDrinking;
    }

    private static boolean canHandDrinkInWorld(class_1657 player, class_1268 hand) {
        return class_1268.field_5808 == hand && player.method_6047().method_7960() && player.method_18276() && ThirstHelper.getThirst(player).getThirst() < 20 && player.method_37908().method_8608() && inWorldDrinkTimer <= 0;
    }

    private static void tryDrinkWaterInWorld(class_1657 player) {
        class_1937 world = player.method_37908();
        class_3965 rayTraceResult = class_1792.method_7872((class_1937)player.method_37908(), (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1345);
        if (rayTraceResult.method_17783() == class_239.class_240.field_1332) {
            class_2338 pos = rayTraceResult.method_17777();
            if (ThirstHelper.canDrink(player, false) && world.method_8505(player, pos) && world.method_8316(pos).method_15767(class_3486.field_15517)) {
                inWorldDrinkTimer = 60;
                ModPackets.HANDLER.sendToServer((CustomPacket)new DrinkInWorldPacket(pos));
                player.method_5783(class_3417.field_20613, 0.5f, 1.0f);
                player.method_6104(class_1268.field_5808);
            }
        }
    }
}

