/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.world.level.block.entity;

import fuzs.visualworkbench.VisualWorkbench;
import fuzs.visualworkbench.config.ClientConfig;
import fuzs.visualworkbench.init.ModRegistry;
import fuzs.visualworkbench.util.MathHelper;
import fuzs.visualworkbench.world.inventory.ModCraftingMenu;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3914;
import org.jetbrains.annotations.Nullable;

public class CraftingTableBlockEntity
extends class_2624 {
    private static final String TAG_LAST_RECIPE = "LastRecipe";
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    private class_1799 lastResult = class_1799.field_8037;
    public int ticks;
    public float currentAngle;
    public float nextAngle;
    private int sector;
    private boolean animating;
    private float animationAngleStart;
    private float animationAngleEnd;
    private double startTicks;
    private double playerAngle;

    public CraftingTableBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModRegistry.CRAFTING_TABLE_BLOCK_ENTITY.get(), pos, state);
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.crafting");
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.inventory.clear();
        class_1262.method_5429((class_2487)tag, this.inventory);
        this.lastResult = tag.method_10545(TAG_LAST_RECIPE) ? class_1799.method_7915((class_2487)tag.method_10562(TAG_LAST_RECIPE)) : class_1799.field_8037;
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_1262.method_5427((class_2487)tag, this.inventory, (boolean)true);
        if (!this.lastResult.method_7960()) {
            class_2487 compoundTag = new class_2487();
            this.lastResult.method_7953(compoundTag);
            tag.method_10566(TAG_LAST_RECIPE, (class_2520)compoundTag);
        }
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public boolean method_5437(int slot, class_1799 stack) {
        class_1799 itemStackInSlot = (class_1799)this.inventory.get(slot);
        if (itemStackInSlot.method_7960()) {
            return !this.smallerStackExist(stack.method_7914(), stack, -1);
        }
        return !this.smallerStackExist(itemStackInSlot.method_7947(), itemStackInSlot, slot);
    }

    private boolean smallerStackExist(int currentSize, class_1799 itemStackInSlot, int slot) {
        for (int i = slot + 1; i < this.method_5439(); ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (itemStack.method_7960() || itemStack.method_7947() >= currentSize || !class_1799.method_31577((class_1799)itemStack, (class_1799)itemStackInSlot)) continue;
            return true;
        }
        return false;
    }

    public boolean method_49104(class_1263 target, int slot, class_1799 stack) {
        return false;
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.inventory) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int index) {
        return index >= 0 && index < this.inventory.size() ? (class_1799)this.inventory.get(index) : class_1799.field_8037;
    }

    public class_1799 method_5434(int index, int count) {
        class_1799 itemStack = class_1262.method_5430(this.inventory, (int)index, (int)count);
        if (!itemStack.method_7960()) {
            this.method_5431();
        }
        return itemStack;
    }

    public class_1799 method_5441(int index) {
        class_1799 itemStack = class_1262.method_5428(this.inventory, (int)index);
        if (!itemStack.method_7960()) {
            this.method_5431();
        }
        return itemStack;
    }

    public void method_5447(int index, class_1799 stack) {
        if (index >= 0 && index < this.inventory.size()) {
            this.inventory.set(index, (Object)stack);
            this.method_5431();
        }
    }

    public boolean method_5443(class_1657 player) {
        if (this.method_10997().method_8321(this.field_11867) != this) {
            return false;
        }
        return !(player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) > 64.0);
    }

    protected class_1703 method_5465(int id, class_1661 playerInventory) {
        return new ModCraftingMenu(id, playerInventory, (class_1263)this, class_3914.method_17392((class_1937)this.method_10997(), (class_2338)this.method_11016()), this::setLastResult);
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public class_1799 getLastResult() {
        return this.lastResult;
    }

    private void setLastResult(class_1799 lastResult) {
        this.lastResult = lastResult;
        this.method_5431();
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, CraftingTableBlockEntity blockEntity) {
        int sector;
        ++blockEntity.ticks;
        if (blockEntity.method_5442() || !((ClientConfig)VisualWorkbench.CONFIG.get(ClientConfig.class)).rotateIngredients) {
            return;
        }
        class_1657 player = level.method_18459((double)blockEntity.field_11867.method_10263() + 0.5, (double)blockEntity.field_11867.method_10264() + 0.5, (double)blockEntity.field_11867.method_10260() + 0.5, 3.0, false);
        if (player != null) {
            double d0 = player.method_23317() - ((double)blockEntity.field_11867.method_10263() + 0.5);
            double d1 = player.method_23321() - ((double)blockEntity.field_11867.method_10260() + 0.5);
            blockEntity.playerAngle = (Math.atan2(-d0, -d1) + 3.9269908169872414) % (Math.PI * 2);
        }
        if (blockEntity.sector != (sector = (int)(blockEntity.playerAngle * 2.0 / Math.PI))) {
            blockEntity.animating = true;
            blockEntity.animationAngleStart = blockEntity.currentAngle;
            float delta1 = (float)sector * 90.0f - blockEntity.currentAngle;
            float abs1 = Math.abs(delta1);
            float delta2 = delta1 + 360.0f;
            float shift = Math.abs(delta2);
            float delta3 = delta1 - 360.0f;
            float abs3 = Math.abs(delta3);
            blockEntity.animationAngleEnd = abs3 < abs1 && abs3 < shift ? delta3 + blockEntity.currentAngle : (shift < abs1 && shift < abs3 ? delta2 + blockEntity.currentAngle : delta1 + blockEntity.currentAngle);
            blockEntity.startTicks = blockEntity.ticks;
            blockEntity.sector = sector;
        }
        if (blockEntity.animating) {
            if ((double)blockEntity.ticks >= blockEntity.startTicks + 20.0) {
                blockEntity.animating = false;
                blockEntity.currentAngle = blockEntity.nextAngle = (blockEntity.animationAngleEnd + 360.0f) % 360.0f;
            } else {
                blockEntity.currentAngle = (MathHelper.easeOutQuad((double)blockEntity.ticks - blockEntity.startTicks, blockEntity.animationAngleStart, blockEntity.animationAngleEnd - blockEntity.animationAngleStart, 20.0) + 360.0f) % 360.0f;
                blockEntity.nextAngle = (MathHelper.easeOutQuad(Math.min((double)(blockEntity.ticks + 1) - blockEntity.startTicks, 20.0), blockEntity.animationAngleStart, blockEntity.animationAngleEnd - blockEntity.animationAngleStart, 20.0) + 360.0f) % 360.0f;
                if (blockEntity.currentAngle != 0.0f || blockEntity.nextAngle != 0.0f) {
                    if (blockEntity.currentAngle == 0.0f && blockEntity.nextAngle >= 180.0f) {
                        blockEntity.currentAngle = 360.0f;
                    }
                    if (blockEntity.nextAngle == 0.0f && blockEntity.currentAngle >= 180.0f) {
                        blockEntity.nextAngle = 360.0f;
                    }
                }
            }
        }
    }
}

