/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.scene.export;

import appeng.client.guidebook.scene.export.RenderTypeIntrospection;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.renderer.v1.model.SpriteFinder;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_310;
import org.joml.Vector2f;
import org.joml.Vector4i;

record Mesh(class_287.class_4574 drawState, ByteBuffer vertexBuffer, ByteBuffer indexBuffer, class_1921 renderType) {
    public Stream<class_1058> getSprites() {
        class_1060 textureManager = class_310.method_1551().method_1531();
        if (this.drawState.comp_752() != class_293.class_5596.field_27382) {
            return Stream.of(new class_1058[0]);
        }
        List<RenderTypeIntrospection.Sampler> samplers = RenderTypeIntrospection.getSamplers(this.renderType);
        if (samplers.isEmpty()) {
            return Stream.of(new class_1058[0]);
        }
        class_1044 texture = textureManager.method_4619(samplers.get(0).texture());
        if (!(texture instanceof class_1059)) {
            return Stream.of(new class_1058[0]);
        }
        class_1059 textureAtlas = (class_1059)texture;
        int offset = 0;
        class_296 uvElement = null;
        for (class_296 element : this.renderType.method_23031().method_1357()) {
            if (element.method_1382() == class_296.class_298.field_1636 && element.method_1385() == 0 && element.method_34451() == 2) {
                uvElement = element;
                break;
            }
            offset += element.method_1387();
        }
        if (uvElement == null) {
            return Stream.of(new class_1058[0]);
        }
        IntFunction<Vector2f> uvSupplier = this.getUvSupplier(offset, uvElement);
        SpriteFinder spriteFinder = SpriteFinder.get((class_1059)textureAtlas);
        return this.streamQuadMidpoints(uvSupplier).map(uvPos -> spriteFinder.find(uvPos.x, uvPos.y)).filter(Objects::nonNull);
    }

    private Stream<Vector2f> streamQuadMidpoints(IntFunction<Vector2f> uvSupplier) {
        return this.streamIndices().map(indices -> this.getQuadMidpoint(indices.x, indices.y, indices.z, indices.w, uvSupplier));
    }

    private Stream<Vector4i> streamIndices() {
        if (this.drawState.comp_755()) {
            int quadCount = this.drawState.comp_750() / 4;
            return IntStream.range(0, quadCount).mapToObj(quadIdx -> new Vector4i(quadIdx * 4, quadIdx * 4 + 1, quadIdx * 4 + 2, quadIdx * 4 + 3));
        }
        if (this.drawState.comp_753() == class_293.class_5595.field_27373) {
            int quadCount = this.drawState.comp_751() / 4;
            return IntStream.range(0, quadCount).mapToObj(quadIdx -> new Vector4i(this.indexBuffer.getInt(quadIdx * 4 * 4), this.indexBuffer.getInt(quadIdx * 4 * 4 + 4), this.indexBuffer.getInt(quadIdx * 4 * 4 + 8), this.indexBuffer.getInt(quadIdx * 4 * 4 + 12)));
        }
        if (this.drawState.comp_753() == class_293.class_5595.field_27372) {
            int quadCount = this.drawState.comp_751() / 4;
            return IntStream.range(0, quadCount).mapToObj(quadIdx -> new Vector4i((int)this.indexBuffer.getShort(quadIdx * 4 * 2), (int)this.indexBuffer.getShort(quadIdx * 4 * 2 + 2), (int)this.indexBuffer.getShort(quadIdx * 4 * 2 + 4), (int)this.indexBuffer.getShort(quadIdx * 4 * 2 + 6)));
        }
        throw new IllegalArgumentException("Unsupported index type: " + this.drawState.comp_753());
    }

    private IntFunction<Vector2f> getUvSupplier(int offset, class_296 uvElement) {
        return idx -> this.getUV(idx, offset, uvElement);
    }

    private Vector2f getQuadMidpoint(int i1, int i2, int i3, int i4, IntFunction<Vector2f> uvSupplier) {
        Vector2f uv1 = uvSupplier.apply(i1);
        Vector2f uv2 = uvSupplier.apply(i2);
        Vector2f uv3 = uvSupplier.apply(i3);
        Vector2f uv4 = uvSupplier.apply(i4);
        float avgX = (uv1.x + uv2.x + uv3.x + uv4.x) / 4.0f;
        float avgY = (uv1.y + uv2.y + uv3.y + uv4.y) / 4.0f;
        return new Vector2f(avgX, avgY);
    }

    private Vector2f getUV(int index, int offset, class_296 uvElement) {
        int stride = this.drawState.comp_749().method_1362();
        int dataStart = index * stride + offset;
        return new Vector2f(this.readFloat(uvElement.method_1386(), dataStart), this.readFloat(uvElement.method_1386(), dataStart + uvElement.method_1386().method_1391()));
    }

    private float readFloat(class_296.class_297 type, int offset) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case class_296.class_297.field_1623 -> this.vertexBuffer.getFloat(offset);
            case class_296.class_297.field_1624 -> this.vertexBuffer.get(offset) & 0xFF;
            case class_296.class_297.field_1621 -> this.vertexBuffer.get(offset);
            case class_296.class_297.field_1622 -> this.vertexBuffer.getShort(offset) & 0xFFFF;
            case class_296.class_297.field_1625 -> this.vertexBuffer.getShort(offset);
            case class_296.class_297.field_1619, class_296.class_297.field_1617 -> this.vertexBuffer.getInt(offset);
        };
    }
}

