/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.api.orientation.BlockOrientation;
import java.util.EnumMap;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_2350;
import net.minecraft.class_290;
import net.minecraft.class_793;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class QuadRotator
implements RenderContext.QuadTransform {
    public static final RenderContext.QuadTransform NULL_TRANSFORM = quad -> true;
    private static final EnumMap<BlockOrientation, RenderContext.QuadTransform> TRANSFORMS = new EnumMap(BlockOrientation.class);
    private final BlockOrientation rotation;
    private final Quaternionf quaternion;

    private QuadRotator(BlockOrientation rotation) {
        this.rotation = rotation;
        this.quaternion = rotation.getQuaternion();
    }

    public static RenderContext.QuadTransform get(class_2350 facing, int spin) {
        return QuadRotator.get(BlockOrientation.get(facing, spin));
    }

    public static RenderContext.QuadTransform get(BlockOrientation rotation) {
        if (rotation.isRedundant()) {
            return NULL_TRANSFORM;
        }
        return TRANSFORMS.get((Object)rotation);
    }

    public boolean transform(MutableQuadView quad) {
        Vector3f tmp = new Vector3f();
        for (int i = 0; i < 4; ++i) {
            quad.copyPos(i, tmp);
            tmp.add(-0.5f, -0.5f, -0.5f);
            tmp.rotate((Quaternionfc)this.quaternion);
            tmp.add(0.5f, 0.5f, 0.5f);
            quad.pos(i, tmp);
            if (!quad.hasNormal(i)) continue;
            quad.copyNormal(i, tmp);
            tmp.rotate((Quaternionfc)this.quaternion);
            quad.normal(i, tmp);
        }
        class_2350 nominalFace = quad.nominalFace();
        class_2350 cullFace = quad.cullFace();
        if (cullFace != null) {
            quad.cullFace(this.rotation.rotate(cullFace));
        }
        class_2350 rotatedNominalFace = this.rotation.rotate(nominalFace);
        quad.nominalFace(rotatedNominalFace);
        int[] data = new int[class_290.field_1590.method_1359() * 4];
        quad.toVanilla(data, 0);
        class_793.field_4249.method_3462(data, rotatedNominalFace);
        quad.fromVanilla(data, 0);
        return true;
    }

    static {
        for (BlockOrientation rotation : BlockOrientation.values()) {
            if (rotation.isRedundant()) {
                TRANSFORMS.put(rotation, NULL_TRANSFORM);
                continue;
            }
            TRANSFORMS.put(rotation, new QuadRotator(rotation));
        }
    }
}

