/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.config.FuzzyMode;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.core.AELog;
import appeng.core.sync.BasePacket;
import appeng.helpers.IMenuCraftingPacket;
import appeng.items.storage.ViewCellItem;
import appeng.util.CraftingRecipeUtil;
import appeng.util.prioritylist.IPartitionList;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class FillCraftingGridFromRecipePacket
extends BasePacket {
    private class_2960 recipeId;
    private class_2371<class_1799> ingredientTemplates;
    private boolean craftMissing;

    public FillCraftingGridFromRecipePacket(class_2540 stream) {
        this.recipeId = stream.readBoolean() ? stream.method_10810() : null;
        this.ingredientTemplates = class_2371.method_10213((int)stream.readInt(), (Object)class_1799.field_8037);
        for (int i = 0; i < this.ingredientTemplates.size(); ++i) {
            this.ingredientTemplates.set(i, (Object)stream.method_10819());
        }
        this.craftMissing = stream.readBoolean();
    }

    public FillCraftingGridFromRecipePacket(@Nullable class_2960 recipeId, class_2371<class_1799> ingredientTemplates, boolean craftMissing) {
        class_2540 data = new class_2540(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        if (recipeId != null) {
            data.writeBoolean(true);
            data.method_10812(recipeId);
        } else {
            data.writeBoolean(false);
        }
        data.writeInt(ingredientTemplates.size());
        for (class_1799 stack : ingredientTemplates) {
            data.method_10793(stack);
        }
        data.writeBoolean(craftMissing);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(class_3222 player) {
        class_1703 menu = player.field_7512;
        if (!(menu instanceof IMenuCraftingPacket)) {
            return;
        }
        IMenuCraftingPacket cct = (IMenuCraftingPacket)menu;
        if (!cct.useRealItems()) {
            AELog.warn("Trying to use real items for crafting in a pattern encoding terminal", new Object[0]);
            return;
        }
        IGridNode node = cct.getNetworkNode();
        if (node == null) {
            return;
        }
        IGrid grid = node.getGrid();
        IStorageService storageService = grid.getStorageService();
        IEnergyService energy = grid.getEnergyService();
        InternalInventory craftMatrix = cct.getCraftingMatrix();
        MEStorage storage = storageService.getInventory();
        KeyCounter cachedStorage = storageService.getCachedInventory();
        IPartitionList filter = ViewCellItem.createItemFilter(cct.getViewCells());
        class_2371<class_1856> ingredients = this.getDesiredIngredients((class_1657)player);
        ICraftingService craftingService = grid.getCraftingService();
        LinkedHashMap toAutoCraft = new LinkedHashMap();
        boolean touchedGridStorage = false;
        for (int x = 0; x < craftMatrix.size(); ++x) {
            class_1799 currentItem = craftMatrix.getStackInSlot(x);
            class_1856 ingredient = (class_1856)ingredients.get(x);
            if (!currentItem.method_7960()) {
                if (ingredient.method_8093(currentItem)) continue;
                AEItemKey in = AEItemKey.of(currentItem);
                long inserted = StorageHelper.poweredInsert(energy, storage, in, currentItem.method_7947(), cct.getActionSource());
                if (inserted > 0L) {
                    touchedGridStorage = true;
                }
                if (inserted < (long)currentItem.method_7947()) {
                    currentItem = currentItem.method_7972();
                    currentItem.method_7934((int)inserted);
                } else {
                    currentItem = class_1799.field_8037;
                }
                player.method_31548().method_7394(currentItem);
                craftMatrix.setItemDirect(x, currentItem.method_7960() ? class_1799.field_8037 : currentItem);
            }
            if (ingredient.method_8103()) continue;
            if (currentItem.method_7960()) {
                List<AEItemKey> request = this.findBestMatchingItemStack(ingredient, filter, cachedStorage);
                for (AEItemKey what : request) {
                    long extracted = StorageHelper.poweredExtraction(energy, storage, what, 1L, cct.getActionSource());
                    if (extracted <= 0L) continue;
                    touchedGridStorage = true;
                    currentItem = what.toStack(Ints.saturatedCast((long)extracted));
                    break;
                }
            }
            if (currentItem.method_7960()) {
                currentItem = this.takeIngredientFromPlayer(cct, player, ingredient);
            }
            craftMatrix.setItemDirect(x, currentItem);
            if (!currentItem.method_7960() || !this.craftMissing) continue;
            int slot = x;
            this.findCraftableKey(ingredient, craftingService).ifPresent(key -> toAutoCraft.computeIfAbsent(key, k -> new IntArrayList()).add(slot));
        }
        menu.method_7609(craftMatrix.toContainer());
        if (!toAutoCraft.isEmpty()) {
            if (touchedGridStorage) {
                storageService.invalidateCache();
            }
            List<IMenuCraftingPacket.AutoCraftEntry> stacks = toAutoCraft.entrySet().stream().map(e -> new IMenuCraftingPacket.AutoCraftEntry((AEItemKey)e.getKey(), (List)e.getValue())).toList();
            cct.startAutoCrafting(stacks);
        }
    }

    private class_1799 takeIngredientFromPlayer(IMenuCraftingPacket cct, class_3222 player, class_1856 ingredient) {
        class_1661 playerInv = player.method_31548();
        for (int i = 0; i < playerInv.field_7547.size(); ++i) {
            class_1799 result;
            class_1799 item;
            if (cct.isPlayerInventorySlotLocked(i) || !ingredient.method_8093(item = playerInv.method_5438(i)) || (result = item.method_7971(1)).method_7960()) continue;
            return result;
        }
        return class_1799.field_8037;
    }

    private class_2371<class_1856> getDesiredIngredients(class_1657 player) {
        class_1860 recipe;
        if (this.recipeId != null && (recipe = (class_1860)player.method_37908().method_8433().method_8130(this.recipeId).orElse(null)) != null) {
            return CraftingRecipeUtil.ensure3by3CraftingMatrix(recipe);
        }
        class_2371 ingredients = class_2371.method_10213((int)9, (Object)class_1856.field_9017);
        Preconditions.checkArgument((ingredients.size() == this.ingredientTemplates.size() ? 1 : 0) != 0, (String)"Got %d ingredient templates from client, expected %d", (int)this.ingredientTemplates.size(), (int)ingredients.size());
        for (int i = 0; i < ingredients.size(); ++i) {
            class_1799 template = (class_1799)this.ingredientTemplates.get(i);
            if (template.method_7960()) continue;
            ingredients.set(i, (Object)class_1856.method_8101((class_1799[])new class_1799[]{template}));
        }
        return ingredients;
    }

    private List<AEItemKey> findBestMatchingItemStack(class_1856 ingredient, IPartitionList filter, KeyCounter storage) {
        return Arrays.stream(ingredient.method_8105()).map(AEItemKey::of).filter(r -> r != null && (filter == null || filter.isListed((AEKey)r))).flatMap(s -> storage.findFuzzy((AEKey)s, FuzzyMode.IGNORE_ALL).stream()).filter(e -> ingredient.method_8093(((AEItemKey)e.getKey()).toStack())).sorted((a, b) -> Long.compare(b.getLongValue(), a.getLongValue())).map(e -> (AEItemKey)e.getKey()).toList();
    }

    private Optional<AEItemKey> findCraftableKey(class_1856 ingredient, ICraftingService craftingService) {
        return Arrays.stream(ingredient.method_8105()).map(AEItemKey::of).map(s -> (AEItemKey)craftingService.getFuzzyCraftable((AEKey)s, key -> ingredient.method_8093(((AEItemKey)key).toStack()))).filter(Objects::nonNull).findAny();
    }
}

