/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.emi;

import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.localization.ItemModText;
import appeng.integration.modules.emi.AppEngEmiPlugin;
import appeng.integration.modules.emi.AppEngRecipeCategory;
import appeng.integration.modules.emi.EmiEntropySlot;
import appeng.integration.modules.emi.EmiText;
import appeng.recipes.entropy.EntropyMode;
import appeng.recipes.entropy.EntropyRecipe;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5250;

public class EmiEntropyRecipe
extends BasicEmiRecipe {
    public static final EmiRecipeCategory CATEGORY = new AppEngRecipeCategory("entropy", EmiEntropyRecipe.createIcon(), EmiText.CATEGORY_ENTROPY_MANIPULATOR);
    private static final int BODY_TEXT_COLOR = 0x7E7E7E;
    private final EntropyRecipe recipe;
    private final EmiStack inputBlockIngredient;
    private final boolean inputFluidFlowing;
    private final EmiStack outputBlockIngredient;
    private final boolean outputFluidFlowing;
    private final List<EmiStack> additionalDrops;
    private final boolean inputConsumed;

    public EmiEntropyRecipe(EntropyRecipe recipe) {
        super(CATEGORY, recipe.method_8114(), 130, 50);
        this.recipe = recipe;
        class_2248 inputBlock = recipe.getInputBlock();
        class_3611 inputFluid = recipe.getInputFluid();
        this.inputBlockIngredient = EmiEntropyRecipe.createIngredient(inputBlock, inputFluid);
        this.inputFluidFlowing = inputFluid != null && this.isFlowing(inputFluid);
        this.inputs.add(this.inputBlockIngredient);
        class_2248 outputBlock = recipe.getOutputBlock();
        class_3611 outputFluid = recipe.getOutputFluid();
        this.outputBlockIngredient = EmiEntropyRecipe.createIngredient(outputBlock, outputFluid);
        boolean bl = this.outputFluidFlowing = outputFluid != null && this.isFlowing(outputFluid);
        if (!this.outputBlockIngredient.isEmpty()) {
            this.outputs.add(this.outputBlockIngredient);
        }
        boolean bl2 = this.inputConsumed = outputBlock != null && outputBlock.method_9564().method_26215() && outputFluid == class_3612.field_15906;
        if (!this.inputConsumed) {
            this.inputBlockIngredient.setRemainder(this.inputBlockIngredient);
        }
        this.additionalDrops = recipe.getDrops().stream().map(EmiStack::of).toList();
        this.outputs.addAll(this.additionalDrops);
    }

    private boolean isFlowing(class_3611 fluid) {
        return fluid != class_3612.field_15906 && !fluid.method_15793(fluid.method_15785());
    }

    public void addWidgets(WidgetHolder widgets) {
        int centerX = this.width / 2;
        class_5250 labelText = switch (this.recipe.getMode()) {
            default -> throw new IncompatibleClassChangeError();
            case EntropyMode.HEAT -> ItemModText.ENTROPY_MANIPULATOR_HEAT.text(1600);
            case EntropyMode.COOL -> ItemModText.ENTROPY_MANIPULATOR_COOL.text(1600);
        };
        class_5250 interaction = switch (this.recipe.getMode()) {
            default -> throw new IncompatibleClassChangeError();
            case EntropyMode.HEAT -> ItemModText.RIGHT_CLICK.text();
            case EntropyMode.COOL -> ItemModText.SHIFT_RIGHT_CLICK.text();
        };
        TextWidget modeLabel = widgets.addText((class_2561)labelText, centerX + 4, 2, 0x7E7E7E, false).horizontalAlign(TextWidget.Alignment.CENTER);
        int modeLabelX = modeLabel.getBounds().x();
        switch (this.recipe.getMode()) {
            case HEAT: {
                widgets.addTexture(AppEngEmiPlugin.TEXTURE, modeLabelX - 9, 3, 6, 6, 0, 68);
                break;
            }
            case COOL: {
                widgets.addTexture(AppEngEmiPlugin.TEXTURE, modeLabelX - 9, 3, 6, 6, 6, 68);
            }
        }
        widgets.addTexture(EmiTexture.EMPTY_ARROW, centerX - 12, 14);
        widgets.addText((class_2561)interaction, centerX, 38, 0x7E7E7E, false).horizontalAlign(TextWidget.Alignment.CENTER);
        widgets.add((Widget)new EmiEntropySlot(this.inputBlockIngredient, false, this.inputFluidFlowing, this.width / 2 - 35, 14));
        int x = centerX + 20;
        if (this.inputConsumed) {
            widgets.add((Widget)new EmiEntropySlot(this.inputBlockIngredient, true, this.outputFluidFlowing, x - 1, 14));
            x += 18;
        } else if (!this.outputBlockIngredient.isEmpty()) {
            widgets.add((Widget)new EmiEntropySlot(this.outputBlockIngredient, false, this.outputFluidFlowing, x - 1, 14).recipeContext((EmiRecipe)this));
            x += 18;
        }
        for (EmiStack drop : this.additionalDrops) {
            widgets.addSlot((EmiIngredient)drop, x - 1, 14).recipeContext((EmiRecipe)this);
            x += 18;
        }
    }

    private static EmiRenderable createIcon() {
        return new EmiTexture(AppEng.makeId("textures/item/entropy_manipulator.png"), 0, 0, 16, 16, 16, 16, 16, 16);
    }

    private static EmiStack createIngredient(class_2248 block, class_3611 fluid) {
        if (fluid != null) {
            if (!fluid.method_15793(fluid.method_15785())) {
                if (fluid instanceof class_3609) {
                    class_3609 flowingFluid = (class_3609)fluid;
                    return EmiStack.of((class_3611)flowingFluid.method_15751());
                }
                AELog.warn("Don't know how to get the source fluid for %s", fluid);
                return EmiStack.of((class_3611)fluid);
            }
            return EmiStack.of((class_3611)fluid);
        }
        if (block != null) {
            return EmiStack.of((class_1799)block.method_8389().method_7854());
        }
        return EmiStack.EMPTY;
    }
}

