/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.locator;

import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.core.AELog;
import appeng.menu.locator.MenuLocator;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Nullable;

record MenuItemLocator(int itemIndex, @Nullable class_2338 blockPos) implements MenuLocator
{
    @Override
    @Nullable
    public <T> T locate(class_1657 player, Class<T> hostInterface) {
        class_1792 class_17922;
        class_1799 it = player.method_31548().method_5438(this.itemIndex);
        if (!it.method_7960() && (class_17922 = it.method_7909()) instanceof IMenuItem) {
            IMenuItem guiItem = (IMenuItem)class_17922;
            ItemMenuHost menuHost = guiItem.getMenuHost(player, this.itemIndex, it, this.blockPos);
            if (hostInterface.isInstance(menuHost)) {
                return hostInterface.cast(menuHost);
            }
            if (menuHost != null) {
                AELog.warn("Item in slot %d of %s did not create a compatible menu of type %s: %s", this.itemIndex, player, hostInterface, menuHost);
            }
        } else {
            AELog.warn("Item in slot %d of %s is not an IMenuItem: %s", this.itemIndex, player, it);
        }
        return null;
    }

    public void writeToPacket(class_2540 buf) {
        buf.writeInt(this.itemIndex);
        buf.writeBoolean(this.blockPos != null);
        if (this.blockPos != null) {
            buf.method_10807(this.blockPos);
        }
    }

    public static MenuItemLocator readFromPacket(class_2540 buf) {
        int itemIndex = buf.readInt();
        class_2338 blockPos = null;
        if (buf.readBoolean()) {
            blockPos = buf.method_10811();
        }
        return new MenuItemLocator(itemIndex, blockPos);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("MenuItem");
        result.append('{');
        result.append("slot=").append(this.itemIndex);
        if (this.blockPos != null) {
            result.append(',').append("pos=").append(this.blockPos);
        }
        result.append('}');
        return result.toString();
    }
}

