/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2454;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7800;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.recipes.AbstractUnlockableRecipeBuilder;

public class CookingRecipeBuilder
extends AbstractUnlockableRecipeBuilder<CookingRecipeBuilder> {
    protected float xp = 0.0f;
    protected int cookingTime = 200;
    boolean blasting;
    boolean campfire;
    boolean smoker;
    boolean smelting = true;

    static CookingRecipeBuilder make(class_2960 id, class_1935 output) {
        return new CookingRecipeBuilder(id, output);
    }

    protected CookingRecipeBuilder(class_2960 id, class_1935 output) {
        super(id, output);
    }

    @Deprecated(forRemoval=true)
    public CookingRecipeBuilder setInput(class_1935 in) {
        return (CookingRecipeBuilder)this.setPrimaryInputAndUnlock(in);
    }

    @Deprecated(forRemoval=true)
    public CookingRecipeBuilder setInput(class_6862<class_1792> in) {
        return (CookingRecipeBuilder)this.setPrimaryInputAndUnlock(in);
    }

    public CookingRecipeBuilder setExperience(float xp) {
        this.xp = xp;
        return this;
    }

    public CookingRecipeBuilder setCookingTime(int time) {
        this.cookingTime = time;
        return this;
    }

    @Override
    protected boolean checkRecipe() {
        if (!(this.smelting || this.blasting || this.campfire || this.smoker)) {
            BCLib.LOGGER.warning("No target (smelting, blasting, campfire or somer) for cooking recipe was selected. Recipe {} will be ignored!", this.id);
            return false;
        }
        if (this.cookingTime < 0) {
            BCLib.LOGGER.warning("cooking time must be positive. Recipe {} will be ignored!", this.id);
            return false;
        }
        return super.checkRecipe();
    }

    public CookingRecipeBuilder enableSmelter() {
        this.smelting = true;
        return this;
    }

    public CookingRecipeBuilder disableSmelter() {
        this.smelting = false;
        return this;
    }

    public CookingRecipeBuilder enableBlastFurnace() {
        this.blasting = true;
        return this;
    }

    public CookingRecipeBuilder disableBlastFurnace() {
        this.blasting = false;
        return this;
    }

    public CookingRecipeBuilder enableCampfire() {
        this.campfire = true;
        return this;
    }

    public CookingRecipeBuilder disableCampfire() {
        this.campfire = false;
        return this;
    }

    public CookingRecipeBuilder enableSmoker() {
        this.smoker = true;
        return this;
    }

    public CookingRecipeBuilder disableSmoker() {
        this.smoker = false;
        return this;
    }

    public void build(boolean blasting, boolean campfire, boolean smoker) {
        this.enableSmelter();
        this.blasting = blasting;
        this.campfire = campfire;
        this.smoker = smoker;
        this.build();
    }

    public void buildWithBlasting() {
        this.build(true, false, false);
    }

    public void buildFoodlike() {
        this.build(false, true, true);
    }

    private void buildRecipe(Consumer<class_2444> cc, class_2454 builder, String postfix) {
        class_2960 loc = new class_2960(this.id.method_12836(), this.id.method_12832() + "_" + postfix);
        for (Map.Entry item : this.unlocks.entrySet()) {
            builder.method_10469((String)item.getKey(), (class_184)item.getValue());
        }
        builder.method_17972(cc, loc);
    }

    @Override
    protected void buildRecipe(Consumer<class_2444> cc) {
        if (this.smelting) {
            this.buildRecipe(cc, class_2454.method_17802((class_1856)this.primaryInput, (class_7800)this.category, (class_1935)this.output.method_7909(), (float)this.xp, (int)this.cookingTime), "smelting");
        }
        if (this.blasting) {
            this.buildRecipe(cc, class_2454.method_10473((class_1856)this.primaryInput, (class_7800)this.category, (class_1935)this.output.method_7909(), (float)this.xp, (int)(this.cookingTime / 2)), "blasting");
        }
        if (this.campfire) {
            this.buildRecipe(cc, class_2454.method_35916((class_1856)this.primaryInput, (class_7800)this.category, (class_1935)this.output.method_7909(), (float)this.xp, (int)(this.cookingTime * 3)), "campfire");
        }
        if (this.smoker) {
            this.buildRecipe(cc, class_2454.method_35916((class_1856)this.primaryInput, (class_7800)this.category, (class_1935)this.output.method_7909(), (float)this.xp, (int)(this.cookingTime / 2)), "smoker");
        }
    }
}

