/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.platform;

import com.github.eterdelta.crittersandcompanions.CrittersAndCompanions;
import com.github.eterdelta.crittersandcompanions.platform.RegistryEntry;
import com.github.eterdelta.crittersandcompanions.platform.RegistryHelper;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class FabricRegistryHelper<T>
implements RegistryHelper<T> {
    private final String modid;
    private final class_5321<class_2378<T>> registryKey;
    private final class_2378<T> registry;

    private static <T> class_2378<T> getRegistryOrThrow(class_5321<class_2378<T>> registryKey) {
        class_2378 registry = (class_2378)class_7923.field_41167.method_10223(registryKey.method_29177());
        if (registry == null) {
            throw new IllegalArgumentException("Could not locate registry for %s".formatted(registryKey.method_29177()));
        }
        return registry;
    }

    public FabricRegistryHelper(class_5321<class_2378<T>> registryKey, String modid) {
        this.modid = modid;
        this.registryKey = registryKey;
        this.registry = FabricRegistryHelper.getRegistryOrThrow(registryKey);
    }

    @Override
    public <R extends T> RegistryEntry<R> register(String id, Supplier<? extends R> creator) {
        final class_5321 key = class_5321.method_29179(this.registryKey, (class_2960)new class_2960(this.modid, id));
        final Object registered = class_2378.method_39197(this.registry, (class_5321)key, creator.get());
        return new RegistryEntry<R>(){

            @Override
            public R get() {
                return registered;
            }

            @Override
            public class_5321<R> getKey() {
                return key;
            }
        };
    }

    public static class ItemHelper
    extends FabricRegistryHelper<class_1792> {
        public ItemHelper(String modid) {
            super(class_7924.field_41197, modid);
        }

        @Override
        public <R extends class_1792> RegistryEntry<R> register(String id, Supplier<? extends R> creator) {
            RegistryEntry item = super.register(id, creator);
            ItemGroupEvents.modifyEntriesEvent(CrittersAndCompanions.CREATIVE_TAB.getKey()).register(entries -> entries.method_45420(new class_1799((class_1935)item.get())));
            return item;
        }
    }
}

