/*
 * Decompiled with CFR 0.152.
 */
package grondag.darkness;

import grondag.darkness.DarknessInit;
import grondag.darkness.compat.ApoliCompat;
import grondag.darkness.config.DarknessConfigModel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1294;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_765;

@Environment(value=EnvType.CLIENT)
public class Darkness {
    static double darkNetherFogEffective;
    static double darkEndFogEffective;
    private static final float[] BTW_MOON_BRIGHTNESS_BY_PHASE;
    public static boolean enabled;
    private static final float[][] LUMINANCE;

    private static void computeConfigValues() {
        darkNetherFogEffective = DarknessInit.CONFIG.darkNether() ? DarknessInit.CONFIG.darkNetherFog() : 1.0;
        darkEndFogEffective = DarknessInit.CONFIG.darkEnd() ? DarknessInit.CONFIG.darkEndFog() : 1.0;
    }

    public static double darkNetherFog() {
        Darkness.computeConfigValues();
        return darkNetherFogEffective;
    }

    public static double darkEndFog() {
        Darkness.computeConfigValues();
        return darkEndFogEffective;
    }

    private static boolean isDark(class_1937 world) {
        class_5321 dimType = world.method_27983();
        if (dimType == class_1937.field_25179) {
            return DarknessInit.CONFIG.darkOverworld();
        }
        if (dimType == class_1937.field_25180) {
            return DarknessInit.CONFIG.darkNether();
        }
        if (dimType == class_1937.field_25181) {
            return DarknessInit.CONFIG.darkEnd();
        }
        if (world.method_8597().comp_642()) {
            return DarknessInit.CONFIG.darkDefault();
        }
        return DarknessInit.CONFIG.darkSkyless();
    }

    private static float skyFactor(class_1937 world) {
        if (!DarknessInit.CONFIG.blockLightOnly() && Darkness.isDark(world)) {
            if (world.method_8597().comp_642()) {
                float angle = world.method_30274(0.0f);
                if (angle > 0.25f && angle < 0.75f) {
                    float oldWeight = Math.max(0.0f, Math.abs(angle - 0.5f) - 0.2f) * 20.0f;
                    float moon = DarknessInit.CONFIG.ignoreMoonPhase() ? 0.0f : world.method_30272();
                    float moonBrightness = switch (DarknessInit.CONFIG.moonPhaseStyle()) {
                        default -> throw new IncompatibleClassChangeError();
                        case DarknessConfigModel.MoonPhaseStyle.DEFAULT -> moon * moon;
                        case DarknessConfigModel.MoonPhaseStyle.GRADUAL -> moon;
                        case DarknessConfigModel.MoonPhaseStyle.BTW -> BTW_MOON_BRIGHTNESS_BY_PHASE[world.method_30273()];
                    };
                    return class_3532.method_16439((float)(oldWeight * oldWeight * oldWeight), (float)moonBrightness, (float)1.0f);
                }
                return 1.0f;
            }
            return 0.0f;
        }
        return 1.0f;
    }

    public static int darken(int c, int blockIndex, int skyIndex) {
        float lTarget = LUMINANCE[blockIndex][skyIndex];
        float r = (float)(c & 0xFF) / 255.0f;
        float g = (float)(c >> 8 & 0xFF) / 255.0f;
        float b = (float)(c >> 16 & 0xFF) / 255.0f;
        float l = Darkness.luminance(r, g, b);
        float f = l > 0.0f ? Math.min(1.0f, lTarget / l) : 0.0f;
        return f == 1.0f ? c : 0xFF000000 | Math.round(f * r * 255.0f) | Math.round(f * g * 255.0f) << 8 | Math.round(f * b * 255.0f) << 16;
    }

    public static float luminance(float r, float g, float b) {
        return r * 0.2126f + g * 0.7152f + b * 0.0722f;
    }

    public static void updateLuminance(float tickDelta, class_310 client, class_757 worldRenderer, float prevFlicker) {
        class_638 world = client.field_1687;
        ApoliCompat apoliCompat = new ApoliCompat();
        if (world != null) {
            if (!Darkness.isDark((class_1937)world) || client.field_1724.method_6059(class_1294.field_5925) || client.field_1724.method_6059(class_1294.field_5927) && client.field_1724.method_3140() > 0.0f || world.method_23789() > 0 || apoliCompat.isApoliNightVisionPower(client)) {
                enabled = false;
                return;
            }
            enabled = true;
            float dimSkyFactor = Darkness.skyFactor((class_1937)world);
            float ambient = world.method_23783(1.0f);
            class_2874 dim = world.method_8597();
            boolean blockAmbient = !Darkness.isDark((class_1937)world);
            for (int skyIndex = 0; skyIndex < 16; ++skyIndex) {
                float skyFactor = 1.0f - (float)skyIndex / 15.0f;
                skyFactor = 1.0f - skyFactor * skyFactor * skyFactor * skyFactor;
                float min = (skyFactor *= dimSkyFactor) * 0.05f;
                float rawAmbient = ambient * skyFactor;
                float minAmbient = rawAmbient * (1.0f - min) + min;
                float skyBase = class_765.method_23284((class_2874)dim, (int)skyIndex) * minAmbient;
                min = 0.35f * skyFactor;
                float skyRed = skyBase * (rawAmbient * (1.0f - min) + min);
                float skyGreen = skyBase * (rawAmbient * (1.0f - min) + min);
                float skyBlue = skyBase;
                if (worldRenderer.method_3195(tickDelta) > 0.0f) {
                    float skyDarkness = worldRenderer.method_3195(tickDelta);
                    skyRed = skyRed * (1.0f - skyDarkness) + skyRed * 0.7f * skyDarkness;
                    skyGreen = skyGreen * (1.0f - skyDarkness) + skyGreen * 0.6f * skyDarkness;
                    skyBlue = skyBlue * (1.0f - skyDarkness) + skyBlue * 0.6f * skyDarkness;
                }
                for (int blockIndex = 0; blockIndex < 16; ++blockIndex) {
                    float blockFactor = 1.0f;
                    if (!blockAmbient) {
                        blockFactor = 1.0f - (float)blockIndex / 15.0f;
                        blockFactor = 1.0f - blockFactor * blockFactor * blockFactor * blockFactor;
                    }
                    float blockBase = blockFactor * class_765.method_23284((class_2874)dim, (int)blockIndex) * (prevFlicker * 0.1f + 1.5f);
                    min = 0.4f * blockFactor;
                    float blockGreen = blockBase * ((blockBase * (1.0f - min) + min) * (1.0f - min) + min);
                    float blockBlue = blockBase * (blockBase * blockBase * (1.0f - min) + min);
                    float red = skyRed + blockBase;
                    float green = skyGreen + blockGreen;
                    float blue = skyBlue + blockBlue;
                    float f = Math.max(skyFactor, blockFactor);
                    min = 0.03f * f;
                    red = red * (0.99f - min) + min;
                    green = green * (0.99f - min) + min;
                    blue = blue * (0.99f - min) + min;
                    if (world.method_27983() == class_1937.field_25181) {
                        red = skyFactor * 0.22f + blockBase * 0.75f;
                        green = skyFactor * 0.28f + blockGreen * 0.75f;
                        blue = skyFactor * 0.25f + blockBlue * 0.75f;
                    }
                    if (red > 1.0f) {
                        red = 1.0f;
                    }
                    if (green > 1.0f) {
                        green = 1.0f;
                    }
                    if (blue > 1.0f) {
                        blue = 1.0f;
                    }
                    float gamma = ((Double)client.field_1690.method_42473().method_41753()).floatValue() * f;
                    float invRed = 1.0f - red;
                    float invGreen = 1.0f - green;
                    float invBlue = 1.0f - blue;
                    invRed = 1.0f - invRed * invRed * invRed * invRed;
                    invGreen = 1.0f - invGreen * invGreen * invGreen * invGreen;
                    invBlue = 1.0f - invBlue * invBlue * invBlue * invBlue;
                    red = red * (1.0f - gamma) + invRed * gamma;
                    green = green * (1.0f - gamma) + invGreen * gamma;
                    blue = blue * (1.0f - gamma) + invBlue * gamma;
                    min = 0.03f * f;
                    red = red * (0.99f - min) + min;
                    green = green * (0.99f - min) + min;
                    blue = blue * (0.99f - min) + min;
                    if (red > 1.0f) {
                        red = 1.0f;
                    }
                    if (green > 1.0f) {
                        green = 1.0f;
                    }
                    if (blue > 1.0f) {
                        blue = 1.0f;
                    }
                    if (red < 0.0f) {
                        red = 0.0f;
                    }
                    if (green < 0.0f) {
                        green = 0.0f;
                    }
                    if (blue < 0.0f) {
                        blue = 0.0f;
                    }
                    Darkness.LUMINANCE[blockIndex][skyIndex] = Darkness.luminance(red, green, blue);
                }
            }
        }
    }

    static {
        BTW_MOON_BRIGHTNESS_BY_PHASE = new float[]{1.25f, 0.875f, 0.75f, 0.5f, 0.0f, 0.5f, 0.75f, 1.25f};
        enabled = false;
        LUMINANCE = new float[16][16];
    }
}

