/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.load.registration;

import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.ingredients.subtypes.SubtypeInterpreters;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3611;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SubtypeRegistration
implements ISubtypeRegistration {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SubtypeInterpreters interpreters = new SubtypeInterpreters();

    @Override
    public void useNbtForSubtypes(class_1792 ... items) {
        for (class_1792 item : items) {
            this.registerSubtypeInterpreter(item, AllNbt.INSTANCE);
        }
    }

    @Override
    public void useNbtForSubtypes(class_3611 ... fluids) {
        IPlatformFluidHelperInternal<?> fluidHelper = Services.PLATFORM.getFluidHelper();
        this.useNbtForSubtypes(fluidHelper, fluids);
    }

    private <T> void useNbtForSubtypes(IPlatformFluidHelperInternal<T> fluidHelper, class_3611 ... fluids) {
        IIngredientTypeWithSubtypes type = fluidHelper.getFluidIngredientType();
        IIngredientSubtypeInterpreter<T> allNbt = fluidHelper.getAllNbtSubtypeInterpreter();
        for (class_3611 fluid : fluids) {
            this.registerSubtypeInterpreter(type, fluid, allNbt);
        }
    }

    @Override
    public <B, I> void registerSubtypeInterpreter(IIngredientTypeWithSubtypes<B, I> type, B base, IIngredientSubtypeInterpreter<I> interpreter) {
        ErrorUtil.checkNotNull(type, "type");
        ErrorUtil.checkNotNull(base, "base");
        ErrorUtil.checkNotNull(interpreter, "interpreter");
        Class<B> ingredientBaseClass = type.getIngredientBaseClass();
        if (!ingredientBaseClass.isInstance(base)) {
            throw new IllegalArgumentException(String.format("base (%s) must be an instance of %s", base.getClass(), ingredientBaseClass));
        }
        if (!this.interpreters.addInterpreter(type, base, interpreter)) {
            LOGGER.error("An interpreter is already registered for this: {}", base, (Object)new IllegalArgumentException());
        }
    }

    public SubtypeInterpreters getInterpreters() {
        return this.interpreters;
    }

    private static class AllNbt
    implements IIngredientSubtypeInterpreter<class_1799> {
        public static final AllNbt INSTANCE = new AllNbt();

        private AllNbt() {
        }

        @Override
        public String apply(class_1799 itemStack, UidContext context) {
            class_2487 nbtTagCompound = itemStack.method_7969();
            if (nbtTagCompound == null || nbtTagCompound.method_33133()) {
                return "";
            }
            return nbtTagCompound.toString();
        }
    }
}

