/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.mes.world.processors;

import com.finndog.mes.modinit.MESProcessors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

public class BrewingStandProcessor
extends class_3491 {
    public static final Codec<BrewingStandProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("brewing_stand_chance").orElse((Object)Float.valueOf(1.0f)).forGetter(processor -> Float.valueOf(processor.brewingStandChance)), (App)Codec.INT.fieldOf("min_potions").orElse((Object)1).forGetter(processor -> processor.minPotions), (App)Codec.INT.fieldOf("max_potions").orElse((Object)3).forGetter(processor -> processor.maxPotions)).apply((Applicative)instance, BrewingStandProcessor::new));
    private final float brewingStandChance;
    private final int minPotions;
    private final int maxPotions;

    public BrewingStandProcessor(float brewingStandChance, int minPotions, int maxPotions) {
        this.brewingStandChance = brewingStandChance;
        this.minPotions = minPotions;
        this.maxPotions = maxPotions;
    }

    public class_3499.class_3501 method_15110(class_4538 level, class_2338 pos, class_2338 pos2, class_3499.class_3501 blockInfo, class_3499.class_3501 relativeBlockInfo, class_3492 settings) {
        if (relativeBlockInfo.comp_1342().method_27852(class_2246.field_10333)) {
            return this.processBrewingStand(relativeBlockInfo, settings);
        }
        return relativeBlockInfo;
    }

    private class_3499.class_3501 processBrewingStand(class_3499.class_3501 blockInfo, class_3492 settings) {
        class_5819 random = settings.method_15115(blockInfo.comp_1341());
        float chance = random.method_43057();
        if (chance < this.brewingStandChance) {
            class_2487 nbt = blockInfo.comp_1343() != null ? blockInfo.comp_1343().method_10553() : new class_2487();
            class_2499 itemsList = new class_2499();
            int numPotions = random.method_43051(this.minPotions, this.maxPotions + 1);
            String[] potionTypes = new String[]{"minecraft:regeneration", "minecraft:swiftness", "minecraft:fire_resistance", "minecraft:healing", "minecraft:night_vision", "minecraft:strength"};
            for (int i = 0; i < numPotions; ++i) {
                class_2487 slot = new class_2487();
                slot.method_10567("Slot", (byte)i);
                slot.method_10582("id", "minecraft:potion");
                slot.method_10567("Count", (byte)1);
                class_2487 potionTag = new class_2487();
                potionTag.method_10582("Potion", potionTypes[random.method_43048(potionTypes.length)]);
                slot.method_10566("tag", (class_2520)potionTag);
                itemsList.add((Object)slot);
            }
            nbt.method_10566("Items", (class_2520)itemsList);
            return new class_3499.class_3501(blockInfo.comp_1341(), blockInfo.comp_1342(), nbt);
        }
        return blockInfo;
    }

    protected class_3828<?> method_16772() {
        return MESProcessors.BREWING_STAND_PROCESSOR.get();
    }
}

