/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.NaturalistAnimal;
import com.starfish_studios.naturalist.common.entity.core.NaturalistGeoEntity;
import com.starfish_studios.naturalist.common.entity.core.SleepingAnimal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.BabyHurtByTargetGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.BabyPanicGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.DistancedFollowParentGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.SearchForItemsGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.SleepGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.MMPathNavigatorGround;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.SmartBodyHelper;
import com.starfish_studios.naturalist.core.platform.CommonPlatformHelper;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistRegistry;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1264;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1330;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1367;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1391;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1425;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_3830;
import net.minecraft.class_3924;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4481;
import net.minecraft.class_4538;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5147;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_6019;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Bear
extends NaturalistAnimal
implements class_5354,
NaturalistGeoEntity,
SleepingAnimal,
class_5147 {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_1856 FOOD_ITEMS = class_1856.method_8106(NaturalistTags.ItemTags.BEAR_TEMPT_ITEMS);
    private static final class_2940<Boolean> SLEEPING = class_2945.method_12791(Bear.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SNIFFING = class_2945.method_12791(Bear.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SITTING = class_2945.method_12791(Bear.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SHEARED = class_2945.method_12791(Bear.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> EAT_COUNTER = class_2945.method_12791(Bear.class, (class_2941)class_2943.field_13327);
    private static final class_6019 PERSISTENT_ANGER_TIME = class_4802.method_24505((int)20, (int)39);
    private static final class_2940<Integer> REMAINING_ANGER_TIME = class_2945.method_12791(Bear.class, (class_2941)class_2943.field_13327);
    @Nullable
    private UUID persistentAngerTarget;
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.sf_nba.bear.idle");
    protected static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.sf_nba.bear.walk");
    protected static final RawAnimation RUN = RawAnimation.begin().thenLoop("animation.sf_nba.bear.run");
    protected static final RawAnimation SIT = RawAnimation.begin().thenLoop("animation.sf_nba.bear.sit");
    protected static final RawAnimation SLEEP = RawAnimation.begin().thenLoop("animation.sf_nba.bear.sleep");
    protected static final RawAnimation SNIFF = RawAnimation.begin().thenLoop("animation.sf_nba.bear.sniff");
    protected static final RawAnimation EAT = RawAnimation.begin().thenLoop("animation.sf_nba.bear.eat");
    protected static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("animation.sf_nba.bear.attack");

    public Bear(@NotNull class_1299<? extends NaturalistAnimal> entityType, class_1937 level) {
        super(entityType, level);
        this.method_49477(1.0f);
        this.method_5952(true);
    }

    @NotNull
    protected class_1330 method_5963() {
        return new SmartBodyHelper((class_1308)this);
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 level) {
        return new MMPathNavigatorGround((class_1308)this, level);
    }

    public void method_5958() {
        super.method_5958();
        if (this.method_5962().method_6241()) {
            this.method_5728(this.method_5962().method_6242() >= 1.25);
        } else {
            this.method_5728(false);
        }
    }

    @Nullable
    public class_1296 method_5613(@NotNull class_3218 level, @NotNull class_1296 mob) {
        return (class_1296)NaturalistEntityTypes.BEAR.get().method_5883((class_1937)level);
    }

    public boolean method_6481(@NotNull class_1799 pStack) {
        return FOOD_ITEMS.method_8093(pStack);
    }

    public class_1315 method_5943(@NotNull class_5425 pLevel, @NotNull class_1266 pDifficulty, @NotNull class_3730 pReason, @Nullable class_1315 pSpawnData, @Nullable class_2487 pDataTag) {
        if (pSpawnData == null) {
            pSpawnData = new class_1296.class_4697(1.0f);
        }
        return super.method_5943(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 30.0).method_26868(class_5134.field_23717, 20.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23718, 0.6);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new BearFloatGoal(this));
        this.field_6201.method_6277(1, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new BearMeleeAttackGoal((class_1314)this, 1.25, true));
        this.field_6201.method_6277(3, (class_1352)new BearSleepGoal(this));
        this.field_6201.method_6277(4, (class_1352)new BearTemptGoal(this, 1.0, FOOD_ITEMS, false));
        this.field_6201.method_6277(4, (class_1352)new BabyPanicGoal((class_1314)this, 2.0));
        this.field_6201.method_6277(5, (class_1352)new DistancedFollowParentGoal(this, 1.25, 48.0, 8.0, 12.0));
        this.field_6201.method_6277(5, (class_1352)new SearchForItemsGoal((class_1314)this, 1.2f, FOOD_ITEMS, 8.0, 2.0));
        this.field_6201.method_6277(6, (class_1352)new BearHarvestFoodGoal(this, 1.2f, 12, 3));
        this.field_6201.method_6277(7, (class_1352)new BearPickupFoodAndSitGoal(this));
        this.field_6201.method_6277(8, (class_1352)new class_1379((class_1314)this, 1.0));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new BabyHurtByTargetGoal((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new BearAttackPlayerNearBabiesGoal(this, class_1657.class, 20, false, true, null));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, arg_0 -> ((Bear)this).method_29515(arg_0)));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1314.class, 10, true, false, entity -> entity.method_5864().method_20210(NaturalistTags.EntityTypes.BEAR_HOSTILES) && !this.method_6113() && !this.method_6109()));
        this.field_6185.method_6277(5, (class_1352)new class_5398((class_1308)this, false));
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236) {
            this.method_29510((class_3218)this.method_37908(), true);
        }
        if (this.method_6113() || this.method_6062()) {
            this.field_6282 = false;
            this.field_6212 = 0.0f;
            this.field_6250 = 0.0f;
        }
        this.handleEating();
        if (!this.method_6047().method_7960()) {
            if (this.method_29511()) {
                this.method_29922();
            }
            this.setSniffing(false);
        }
        this.method_37908().method_16107().method_15396("looting");
        if (!this.method_37908().field_9236 && this.method_5936() && this.method_5805() && !this.field_6272 && this.method_37908().method_8450().method_8355(class_1928.field_19388)) {
            for (class_1542 itementity : this.method_37908().method_18467(class_1542.class, this.method_5829().method_1009(1.0, 0.0, 1.0))) {
                if (itementity.method_31481() || itementity.method_6983().method_7960() || !this.method_20820(itementity.method_6983())) continue;
                this.method_5949(itementity);
            }
        }
        this.method_37908().method_16107().method_15407();
    }

    public boolean method_5679(class_1282 pSource) {
        return pSource.equals(this.method_48923().method_48835()) || super.method_5679(pSource);
    }

    protected float method_18394(@NotNull class_4050 pPose, @NotNull class_4048 pSize) {
        return pSize.field_18068 * 0.75f;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SLEEPING, (Object)false);
        this.field_6011.method_12784(SNIFFING, (Object)false);
        this.field_6011.method_12784(SITTING, (Object)false);
        this.field_6011.method_12784(SHEARED, (Object)false);
        this.field_6011.method_12784(EAT_COUNTER, (Object)0);
        this.field_6011.method_12784(REMAINING_ANGER_TIME, (Object)0);
    }

    public void method_5749(@NotNull class_2487 pCompound) {
        super.method_5749(pCompound);
        this.method_29512(this.method_37908(), pCompound);
        if (pCompound.method_10545("Sheared")) {
            this.setSheared(pCompound.method_10577("Sheared"));
        }
    }

    public void method_5652(@NotNull class_2487 pCompound) {
        super.method_5652(pCompound);
        this.method_29517(pCompound);
        pCompound.method_10556("Sheared", this.isSheared());
    }

    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    @Override
    public boolean canSleep() {
        long dayTime = this.method_37908().method_8532();
        return (dayTime < 12000L || dayTime > 18000L) && dayTime < 23000L && dayTime > 6000L && !this.method_29511() && !this.method_37908().method_22351(this.method_24515());
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
    }

    public boolean isSniffing() {
        return (Boolean)this.field_6011.method_12789(SNIFFING);
    }

    public void setSniffing(boolean sniffing) {
        this.field_6011.method_12778(SNIFFING, (Object)sniffing);
    }

    public boolean isSitting() {
        return (Boolean)this.field_6011.method_12789(SITTING);
    }

    public void setSitting(boolean sitting) {
        this.field_6011.method_12778(SITTING, (Object)sitting);
    }

    public boolean isSheared() {
        return (Boolean)this.field_6011.method_12789(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.field_6011.method_12778(SHEARED, (Object)sheared);
    }

    public boolean isEating() {
        return (Integer)this.field_6011.method_12789(EAT_COUNTER) > 0;
    }

    public void eat(boolean eat) {
        this.field_6011.method_12778(EAT_COUNTER, (Object)(eat ? 1 : 0));
    }

    private int getEatCounter() {
        return (Integer)this.field_6011.method_12789(EAT_COUNTER);
    }

    private void setEatCounter(int amount) {
        this.field_6011.method_12778(EAT_COUNTER, (Object)amount);
    }

    public void method_29509() {
        this.method_29514(PERSISTENT_ANGER_TIME.method_35008(this.field_5974));
    }

    public void method_29514(int pTime) {
        this.field_6011.method_12778(REMAINING_ANGER_TIME, (Object)pTime);
    }

    public int method_29507() {
        return (Integer)this.field_6011.method_12789(REMAINING_ANGER_TIME);
    }

    public void method_29513(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    @Nullable
    public UUID method_29508() {
        return this.persistentAngerTarget;
    }

    private void handleEating() {
        if (!this.isEating() && this.isSitting() && !this.method_6113() && !this.method_6047().method_7960() && this.field_5974.method_43048(80) == 1) {
            this.eat(true);
        } else if (this.method_6047().method_7960() || !this.isSitting()) {
            this.eat(false);
        }
        if (this.isEating()) {
            this.addEatingParticles();
            if (!this.method_37908().field_9236 && this.getEatCounter() > 40) {
                if (this.method_6481(this.method_6118(class_1304.field_6173))) {
                    if (!this.method_37908().field_9236) {
                        this.method_5673(class_1304.field_6173, class_1799.field_8037);
                        this.method_32876(class_5712.field_28735);
                        this.setSheared(false);
                    }
                    this.setSitting(false);
                }
                this.eat(false);
                return;
            }
            this.setEatCounter(this.getEatCounter() + 1);
        }
    }

    private void addEatingParticles() {
        if (this.getEatCounter() % 5 == 0 || this.getEatCounter() == 0) {
            this.method_5783(NaturalistSoundEvents.BEAR_EAT.get(), 0.5f + 0.5f * (float)this.field_5974.method_43048(2), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
            for (int i = 0; i < 6; ++i) {
                class_243 speedVec = new class_243(((double)this.field_5974.method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.field_5974.method_43057() - 0.5) * 0.1);
                speedVec = speedVec.method_1037(-this.method_36455() * ((float)Math.PI / 180));
                speedVec = speedVec.method_1024(-this.method_36454() * ((float)Math.PI / 180));
                double y = (double)(-this.field_5974.method_43057()) * 0.6 - 0.3;
                class_243 posVec = new class_243(((double)this.field_5974.method_43057() - 0.5) * 0.8, y, 1.0 + ((double)this.field_5974.method_43057() - 0.5) * 0.4);
                posVec = posVec.method_1024(-this.field_6283 * ((float)Math.PI / 180));
                posVec = posVec.method_1031(this.method_23317(), this.method_23320() - 0.2, this.method_23321() - 0.1);
                this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, this.method_6118(class_1304.field_6173)), posVec.field_1352, posVec.field_1351, posVec.field_1350, speedVec.field_1352, speedVec.field_1351 + 0.05, speedVec.field_1350);
            }
        }
    }

    public boolean method_18397(@NotNull class_1799 pItemstack) {
        class_1304 slot = class_1308.method_32326((class_1799)pItemstack);
        if (!this.method_6118(slot).method_7960() || this.method_6109()) {
            return false;
        }
        return slot == class_1304.field_6173 && super.method_18397(pItemstack);
    }

    protected void method_5949(@NotNull class_1542 pItemEntity) {
        class_1799 stack = pItemEntity.method_6983();
        if (this.method_6047().method_7960() && FOOD_ITEMS.method_8093(stack) && !this.method_6109()) {
            this.method_29499(pItemEntity);
            this.method_5673(class_1304.field_6173, stack);
            this.field_6187[class_1304.field_6173.method_5927()] = 2.0f;
            this.method_6103((class_1297)pItemEntity, stack.method_7947());
            pItemEntity.method_31472();
        }
    }

    public boolean method_5643(@NotNull class_1282 pSource, float pAmount) {
        if (!this.method_6047().method_7960() && !this.method_37908().field_9236) {
            class_1542 itemEntity = new class_1542(this.method_37908(), this.method_23317() + this.method_5720().field_1352, this.method_23318() + 1.0, this.method_23321() + this.method_5720().field_1350, this.method_6047());
            itemEntity.method_6982(80);
            itemEntity.method_6981(this.method_5667());
            this.method_5783(NaturalistSoundEvents.BEAR_SPIT.get(), 1.0f, 1.0f);
            this.method_37908().method_8649((class_1297)itemEntity);
            this.method_5673(class_1304.field_6173, class_1799.field_8037);
        }
        return super.method_5643(pSource, pAmount);
    }

    @NotNull
    public class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        class_6862<class_1792> tag;
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31573(tag = CommonPlatformHelper.getShearsTag()) && this.method_27072()) {
            if (!this.method_6113()) {
                this.method_6015((class_1309)player);
            }
            this.method_6636(class_3419.field_15248);
            this.method_32875(class_5712.field_28730, (class_1297)player);
            if (!this.method_37908().field_9236) {
                itemStack.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    public void method_6636(@NotNull class_3419 source) {
        this.method_37908().method_43129(null, (class_1297)this, class_3417.field_14975, source, 1.0f, 1.0f);
        this.setSheared(true);
        int amount = 1 + this.field_5974.method_43048(2);
        for (int j = 0; j < amount; ++j) {
            class_1542 itemEntity = this.method_5870((class_1935)NaturalistRegistry.FUR.get(), 1);
            if (itemEntity == null) continue;
            itemEntity.method_18799(itemEntity.method_18798().method_1031((double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f), (double)(this.field_5974.method_43057() * 0.05f), (double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f)));
        }
    }

    public boolean method_27072() {
        return this.method_5805() && !this.isSheared() && !this.method_6109();
    }

    protected float method_6120() {
        return 0.98f;
    }

    void tryToSit() {
        if (!this.isTouchingWater()) {
            this.method_5930(0.0f);
            this.method_5942().method_6340();
            this.setSitting(true);
        }
    }

    boolean isTouchingWater() {
        return this.method_37908().method_22351(this.method_24515());
    }

    @Nullable
    protected class_3414 method_6011(class_1282 pDamageSource) {
        return this.method_6109() ? NaturalistSoundEvents.BEAR_HURT_BABY.get() : NaturalistSoundEvents.BEAR_HURT.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return NaturalistSoundEvents.BEAR_DEATH.get();
    }

    @Nullable
    protected class_3414 method_5994() {
        return this.method_6113() ? NaturalistSoundEvents.BEAR_SLEEP.get() : (this.method_6109() ? NaturalistSoundEvents.BEAR_AMBIENT_BABY.get() : NaturalistSoundEvents.BEAR_AMBIENT.get());
    }

    public float method_6017() {
        return this.method_6113() ? super.method_6017() * 0.3f : (this.method_6109() ? super.method_6017() * 0.4f : super.method_6017());
    }

    protected void method_5712(class_2338 pPos, class_2680 pBlock) {
        this.method_5783(class_3417.field_15036, 0.15f, 1.0f);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected <E extends Bear> PlayState predicate(AnimationState<E> event) {
        if (this.method_6113()) {
            event.getController().setAnimation(SLEEP);
            return PlayState.CONTINUE;
        }
        if (this.isSitting()) {
            event.getController().setAnimation(SIT);
            return PlayState.CONTINUE;
        }
        if (this.method_18798().method_37268() > 1.0E-6) {
            if (this.method_5624()) {
                event.getController().setAnimation(RUN);
                event.getController().setAnimationSpeed(2.0);
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(WALK);
            event.getController().setAnimationSpeed(1.4);
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(IDLE);
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    protected <E extends Bear> PlayState sniffPredicate(@NotNull AnimationState<E> event) {
        if (this.isSniffing()) {
            event.getController().setAnimation(SNIFF);
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    protected <E extends Bear> PlayState attackPredicate(AnimationState<E> event) {
        if (this.field_6252 && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.getController().setAnimationSpeed((double)1.3f);
            event.setAnimation(ATTACK);
            this.field_6252 = false;
        }
        return PlayState.CONTINUE;
    }

    @NotNull
    protected <E extends Bear> PlayState eatPredicate(AnimationState<E> event) {
        if (this.isEating()) {
            event.getController().setAnimation(EAT);
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "sniffController", 2, this::sniffPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "swingController", 2, this::attackPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "eatController", 5, this::eatPredicate)});
    }

    static class BearFloatGoal
    extends class_1347 {
        private final Bear bear;

        public BearFloatGoal(Bear pMob) {
            super((class_1308)pMob);
            this.bear = pMob;
        }

        public boolean method_6264() {
            if (!this.bear.method_6109()) {
                return (this.bear.method_37908().method_22351(this.bear.method_24515().method_10074()) || this.bear.method_37908().method_22351(this.bear.method_24515().method_10084())) && super.method_6264();
            }
            return super.method_6264();
        }
    }

    static class BearMeleeAttackGoal
    extends class_1366 {
        public BearMeleeAttackGoal(class_1314 pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        }

        public boolean method_6264() {
            return this.field_6503.method_6047().method_7960() && super.method_6264();
        }

        public boolean method_6266() {
            return this.field_6503.method_6047().method_7960() && super.method_6266();
        }

        protected double method_6289(class_1309 pAttackTarget) {
            return pAttackTarget instanceof class_1425 ? super.method_6289(pAttackTarget) : (double)(4.0f + pAttackTarget.method_17681());
        }
    }

    class BearSleepGoal
    extends SleepGoal<Bear> {
        public BearSleepGoal(Bear animal) {
            super(animal);
        }

        @Override
        public void method_6269() {
            Bear.this.setSniffing(false);
            super.method_6269();
        }
    }

    static class BearTemptGoal
    extends class_1391 {
        private final Bear bear;

        public BearTemptGoal(Bear pMob, double pSpeedModifier, class_1856 pItems, boolean pCanScare) {
            super((class_1314)pMob, pSpeedModifier, pItems, pCanScare);
            this.bear = pMob;
        }

        public boolean method_6264() {
            return this.bear.method_6047().method_7960() && super.method_6264();
        }

        public void method_6269() {
            super.method_6269();
            this.bear.setSniffing(true);
        }

        public void method_6268() {
            super.method_6268();
            if (this.bear.method_6051().method_43057() < 0.05f) {
                this.bear.method_5783(NaturalistSoundEvents.BEAR_SNIFF.get(), 1.0f, 1.0f);
            }
        }

        public void method_6270() {
            super.method_6270();
            this.bear.setSniffing(false);
        }
    }

    static class BearHarvestFoodGoal
    extends class_1367 {
        protected int ticksWaited;
        @NotNull
        private final Bear bear;

        public BearHarvestFoodGoal(Bear pMob, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
            super((class_1314)pMob, pSpeedModifier, pSearchRange, pVerticalSearchRange);
            this.bear = pMob;
        }

        public double method_6291() {
            return 3.0;
        }

        public boolean method_6294() {
            return this.field_6517 % 100 == 0;
        }

        protected boolean method_6296(class_4538 pLevel, class_2338 pPos) {
            class_2586 class_25862;
            class_2680 state = pLevel.method_8320(pPos);
            if (state.method_26204() instanceof class_4481) {
                return (Integer)state.method_11654((class_2769)class_4481.field_20420) >= 5;
            }
            if (state.method_27852(class_2246.field_16999)) {
                return (Integer)state.method_11654((class_2769)class_3830.field_17000) >= 2;
            }
            if (state.method_27852(class_2246.field_17350) && (class_25862 = pLevel.method_8321(pPos)) instanceof class_3924) {
                class_3924 campfire = (class_3924)class_25862;
                return this.campfireIsTempting(campfire);
            }
            return false;
        }

        public void method_6268() {
            if (this.method_6295()) {
                if (this.ticksWaited >= 40) {
                    this.onReachedTarget();
                } else {
                    ++this.ticksWaited;
                }
            } else if (!this.method_6295() && this.bear.method_6051().method_43057() < 0.05f) {
                this.bear.method_5783(NaturalistSoundEvents.BEAR_SNIFF.get(), 1.0f, 1.0f);
                this.bear.setSniffing(true);
            }
            this.bear.method_5988().method_6230((double)this.field_6512.method_10263() + 0.5, (double)this.field_6512.method_10264(), (double)this.field_6512.method_10260() + 0.5, 10.0f, (float)this.bear.method_5978());
            super.method_6268();
        }

        protected void onReachedTarget() {
            if (this.bear.method_37908().method_8450().method_8355(class_1928.field_19388)) {
                class_3924 campfire;
                class_2586 class_25862;
                class_2680 state = this.bear.method_37908().method_8320(this.field_6512);
                this.bear.setSniffing(false);
                if (state.method_26204() instanceof class_4481 && (Integer)state.method_11654((class_2769)class_4481.field_20420) >= 5) {
                    this.harvestHoney(state);
                } else if (state.method_27852(class_2246.field_16999) && (Integer)state.method_11654((class_2769)class_3830.field_17000) >= 2) {
                    this.pickSweetBerries(state);
                } else if (state.method_27852(class_2246.field_17350) && (class_25862 = this.bear.method_37908().method_8321(this.field_6512)) instanceof class_3924 && this.campfireIsTempting(campfire = (class_3924)class_25862)) {
                    this.stealCampfireFood(state, campfire);
                }
            }
        }

        private void stealCampfireFood(class_2680 state, @NotNull class_3924 campfire) {
            for (int i = 0; i < campfire.method_17505().size(); ++i) {
                if (!FOOD_ITEMS.method_8093((class_1799)campfire.method_17505().get(i))) continue;
                class_1264.method_5449((class_1937)this.bear.method_37908(), (double)this.field_6512.method_10263(), (double)this.field_6512.method_10264(), (double)this.field_6512.method_10260(), (class_1799)((class_1799)campfire.method_17505().get(i)));
                campfire.method_17505().set(i, (Object)class_1799.field_8037);
                this.bear.method_37908().method_8413(this.field_6512, state, state, 3);
                campfire.method_5431();
                break;
            }
        }

        private boolean campfireIsTempting(@NotNull class_3924 campfire) {
            for (int i = 0; i < campfire.method_17505().size(); ++i) {
                if (!FOOD_ITEMS.method_8093((class_1799)campfire.method_17505().get(i))) continue;
                return true;
            }
            return false;
        }

        private void harvestHoney(class_2680 state) {
            state.method_11657((class_2769)class_4481.field_20420, (Comparable)Integer.valueOf(0));
            class_4481.method_21842((class_1937)this.bear.method_37908(), (class_2338)this.field_6512);
            this.bear.method_5783(class_3417.field_20611, 1.0f, 1.0f);
            this.bear.method_37908().method_8652(this.field_6512, (class_2680)state.method_11657((class_2769)class_4481.field_20420, (Comparable)Integer.valueOf(0)), 2);
            this.bear.method_6104(class_1268.field_5808);
        }

        private void pickSweetBerries(@NotNull class_2680 state) {
            int age = (Integer)state.method_11654((class_2769)class_3830.field_17000);
            state.method_11657((class_2769)class_3830.field_17000, (Comparable)Integer.valueOf(1));
            int berryAmount = 1 + this.bear.method_37908().field_9229.method_43048(2) + (age == 3 ? 1 : 0);
            class_2248.method_9577((class_1937)this.bear.method_37908(), (class_2338)this.field_6512, (class_1799)new class_1799((class_1935)class_1802.field_16998, berryAmount));
            this.bear.method_5783(class_3417.field_17617, 1.0f, 1.0f);
            this.bear.method_37908().method_8652(this.field_6512, (class_2680)state.method_11657((class_2769)class_3830.field_17000, (Comparable)Integer.valueOf(1)), 2);
            this.bear.method_6104(class_1268.field_5808);
        }

        public boolean method_6264() {
            return !this.bear.method_6109() && this.bear.method_6047().method_7960() && super.method_6264();
        }

        public boolean method_6266() {
            return this.bear.method_6047().method_7960() && super.method_6266();
        }

        public void method_6269() {
            super.method_6269();
            this.ticksWaited = 0;
        }

        protected class_2338 method_30953() {
            class_2338.class_2339 mutable = new class_2338.class_2339().method_10101((class_2382)this.field_6512);
            while (this.bear.method_37908().method_8320(mutable.method_10074()).method_26215()) {
                mutable.method_10098(class_2350.field_11033);
            }
            return mutable;
        }
    }

    static class BearPickupFoodAndSitGoal
    extends class_1352 {
        private int cooldown;
        private final Bear bear;

        public BearPickupFoodAndSitGoal(Bear bear) {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
            this.bear = bear;
        }

        public boolean method_6264() {
            if (!(this.cooldown > this.bear.field_6012 || this.bear.method_6109() || this.bear.isTouchingWater() || this.bear.method_6113() || this.bear.isSitting())) {
                return !this.bear.method_6047().method_7960();
            }
            return false;
        }

        public boolean method_6266() {
            return !this.bear.isTouchingWater();
        }

        public void method_6268() {
            if (!this.bear.isSitting() && !this.bear.method_6047().method_7960()) {
                this.bear.tryToSit();
            }
        }

        public void method_6269() {
            if (!this.bear.method_6047().method_7960()) {
                this.bear.tryToSit();
            }
            this.cooldown = 0;
        }

        public void method_6270() {
            class_1799 stack = this.bear.method_6118(class_1304.field_6173);
            if (!stack.method_7960()) {
                this.bear.method_5775(stack);
                this.bear.method_5673(class_1304.field_6173, class_1799.field_8037);
                int cooldownSeconds = this.bear.field_5974.method_43048(150) + 10;
                this.cooldown = this.bear.field_6012 + cooldownSeconds * 20;
            }
            this.bear.setSitting(false);
        }
    }

    static class BearAttackPlayerNearBabiesGoal
    extends class_1400<class_1657> {
        private final Bear bear;

        public BearAttackPlayerNearBabiesGoal(Bear pMob, Class<class_1657> pTargetType, int pRandomInterval, boolean pMustSee, boolean pMustReach, @Nullable Predicate<class_1309> pTargetPredicate) {
            super((class_1308)pMob, pTargetType, pRandomInterval, pMustSee, pMustReach, pTargetPredicate);
            this.bear = pMob;
        }

        public boolean method_6264() {
            if (!this.bear.method_6109() && !this.bear.method_6113() && super.method_6264()) {
                for (Bear bear : this.bear.method_37908().method_18467(Bear.class, this.bear.method_5829().method_1009(8.0, 4.0, 8.0))) {
                    if (!bear.method_6109()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double method_6326() {
            return super.method_6326() * 0.5;
        }
    }
}

