/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.mojang.logging.LogUtils;
import com.starfish_studios.naturalist.common.entity.core.Catchable;
import com.starfish_studios.naturalist.common.entity.core.NaturalistAnimal;
import com.starfish_studios.naturalist.common.entity.core.NaturalistGeoEntity;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.FlyingWanderGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.SmartBodyHelper;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistRegistry;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1330;
import net.minecraft.class_1331;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1367;
import net.minecraft.class_1391;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4140;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Butterfly
extends NaturalistAnimal
implements NaturalistGeoEntity,
class_1432,
Catchable {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2940<Boolean> HAS_NECTAR = class_2945.method_12791(Butterfly.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DATA_VARIANT = class_2945.method_12791(Butterfly.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> FROM_HAND = class_2945.method_12791(Butterfly.class, (class_2941)class_2943.field_13323);
    private int numCropsGrownSincePollination;
    protected static final RawAnimation FLY = RawAnimation.begin().thenLoop("animation.sf_nba.butterfly.fly");

    @NotNull
    public class_1310 method_6046() {
        return class_1310.field_6293;
    }

    @NotNull
    protected class_1330 method_5963() {
        return new SmartBodyHelper((class_1308)this);
    }

    public Butterfly(@NotNull class_1299<? extends NaturalistAnimal> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
        this.method_5941(class_7.field_21516, -1.0f);
        this.method_5941(class_7.field_10, -1.0f);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new class_1391((class_1314)this, 1.25, class_1856.method_8106((class_6862)class_3489.field_20344), false));
        this.field_6201.method_6277(3, (class_1352)new class_1353((class_1429)this, 1.25));
        this.field_6201.method_6277(4, (class_1352)new ButterflyGrowCropGoal(this, 1.0, 16, 4));
        this.field_6201.method_6277(5, (class_1352)new ButterflyPollinateGoal(this, 1.0, 16, 4));
        this.field_6201.method_6277(6, (class_1352)new FlyingWanderGoal((class_1314)this));
        this.field_6201.method_6277(7, (class_1352)new class_1347((class_1308)this));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23720, (double)0.6f).method_26868(class_5134.field_23719, (double)0.3f);
    }

    protected class_1408 method_5965(final class_1937 pLevel) {
        class_1407 navigation = new class_1407((class_1308)this, pLevel){

            public boolean method_6333(@NotNull class_2338 pPos) {
                return !pLevel.method_8320(pPos.method_10074()).method_26215();
            }
        };
        navigation.method_6332(false);
        navigation.method_6354(false);
        navigation.method_6331(true);
        return navigation;
    }

    public float method_6144(class_2338 pPos, class_4538 pLevel) {
        return pLevel.method_8320(pPos).method_26215() ? 10.0f : 0.0f;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_VARIANT, (Object)1);
        this.field_6011.method_12784(FROM_HAND, (Object)false);
        this.field_6011.method_12784(HAS_NECTAR, (Object)false);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("Variant", this.getVariant().getId());
        compound.method_10556("FromHand", this.fromHand());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setVariant(Variant.BY_ID[compound.method_10550("Variant")]);
        this.setFromHand(compound.method_10577("FromHand"));
    }

    public Variant getVariant() {
        return Variant.BY_ID[(Integer)this.field_6011.method_12789(DATA_VARIANT)];
    }

    public void setVariant(@NotNull Variant variant) {
        this.field_6011.method_12778(DATA_VARIANT, (Object)variant.getId());
    }

    @Override
    public boolean fromHand() {
        return (Boolean)this.field_6011.method_12789(FROM_HAND);
    }

    @Override
    public void setFromHand(boolean fromHand) {
        this.field_6011.method_12778(FROM_HAND, (Object)fromHand);
    }

    public boolean hasNectar() {
        return (Boolean)this.field_6011.method_12789(HAS_NECTAR);
    }

    void setHasNectar(boolean hasNectar) {
        this.field_6011.method_12778(HAS_NECTAR, (Object)hasNectar);
    }

    int getCropsGrownSincePollination() {
        return this.numCropsGrownSincePollination;
    }

    private void resetNumCropsGrownSincePollination() {
        this.numCropsGrownSincePollination = 0;
    }

    void incrementNumCropsGrownSincePollination() {
        ++this.numCropsGrownSincePollination;
    }

    @Override
    public void saveToHandTag(@NotNull class_1799 stack) {
        Catchable.saveDefaultDataToHandTag((class_1308)this, stack);
        class_2487 compoundTag = stack.method_7948();
        compoundTag.method_10569("Variant", this.getVariant().getId());
        compoundTag.method_10569("Age", this.method_5618());
    }

    @Override
    public void loadFromHandTag(@NotNull class_2487 tag) {
        Catchable.loadDefaultDataFromHandTag((class_1308)this, tag);
        int i = tag.method_10550("Variant");
        if (i >= 0 && i < Variant.BY_ID.length) {
            this.setVariant(Variant.BY_ID[i]);
        } else {
            LOGGER.error("Invalid variant: {}", (Object)i);
        }
        if (tag.method_10545("Age")) {
            this.method_5614(tag.method_10550("Age"));
        }
        if (tag.method_10545("HuntingCooldown")) {
            this.method_18868().method_24525(class_4140.field_30246, (Object)true, tag.method_10537("HuntingCooldown"));
        }
    }

    public boolean method_5776() {
        return this.method_6581() && this.field_6012 % class_3532.method_15386((float)1.4959966f) == 0;
    }

    public boolean method_6581() {
        return !this.method_24828();
    }

    protected float method_18394(class_4050 pPose, class_4048 pSize) {
        return pSize.field_18068 * 0.5f;
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        if (reason == class_3730.field_16473) {
            return spawnData;
        }
        class_5819 randomSource = level.method_8409();
        spawnData = new ButterflyGroupData(Variant.getCommonSpawnVariant(randomSource), Variant.getCommonSpawnVariant(randomSource));
        this.setVariant(((ButterflyGroupData)((Object)spawnData)).getVariant(randomSource));
        return super.method_5943(level, difficulty, reason, spawnData, dataTag);
    }

    public static boolean checkButterflySpawnRules(class_1299<? extends Butterfly> pType, class_5425 pLevel, class_3730 pReason, @NotNull class_2338 pPos, class_5819 pRandom) {
        return pLevel.method_8320(pPos.method_10074()).method_26164(NaturalistTags.BlockTags.BUTTERFLIES_SPAWNABLE_ON);
    }

    public boolean method_6481(@NotNull class_1799 pStack) {
        return pStack.method_31573(class_3489.field_20344);
    }

    @NotNull
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        return Catchable.catchAnimal(player, hand, this, true).orElse(super.method_5992(player, hand));
    }

    public boolean method_17326() {
        return super.method_17326() || this.fromHand();
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    public class_1799 getCaughtItemStack() {
        return new class_1799((class_1935)NaturalistRegistry.BUTTERFLY.get());
    }

    @Override
    public class_3414 getPickupSound() {
        return null;
    }

    public void method_6007() {
        super.method_6007();
        if (this.getCropsGrownSincePollination() >= 10) {
            this.resetNumCropsGrownSincePollination();
            this.setHasNectar(false);
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.hasNectar() && this.getCropsGrownSincePollination() < 10 && this.field_5974.method_43057() < 0.05f) {
            for (int i = 0; i < this.field_5974.method_43048(2) + 1; ++i) {
                this.spawnFluidParticle(this.method_37908(), this.method_23317() - (double)0.3f, this.method_23317() + (double)0.3f, this.method_23321() - (double)0.3f, this.method_23321() + (double)0.3f, this.method_23323(0.5), (class_2394)class_2398.field_20537);
            }
        }
    }

    private void spawnFluidParticle(@NotNull class_1937 level, double x1, double x2, double z1, double z2, double y, @NotNull class_2394 particleOptions) {
        level.method_8406(particleOptions, class_3532.method_16436((double)level.field_9229.method_43058(), (double)x1, (double)x2), y, class_3532.method_16436((double)level.field_9229.method_43058(), (double)z1, (double)z2), 0.0, 0.0, 0.0);
    }

    @Nullable
    public class_1296 method_5613(class_3218 level, class_1296 mob) {
        return (class_1296)NaturalistEntityTypes.CATERPILLAR.get().method_5883((class_1937)level);
    }

    public boolean method_6109() {
        return false;
    }

    public boolean method_5747(float pFallDistance, float pMultiplier, class_1282 pSource) {
        return false;
    }

    protected void method_5623(double pY, boolean pOnGround, class_2680 pState, class_2338 pPos) {
    }

    protected void method_5712(class_2338 pPos, class_2680 pState) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected <E extends Butterfly> PlayState predicate(AnimationState<E> event) {
        event.getController().setAnimation(FLY);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    static class ButterflyGrowCropGoal
    extends class_1367 {
        private final Butterfly butterfly;

        public ButterflyGrowCropGoal(Butterfly pMob, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
            super((class_1314)pMob, pSpeedModifier, pSearchRange, pVerticalSearchRange);
            this.butterfly = pMob;
        }

        protected boolean method_6296(class_4538 pLevel, class_2338 pPos) {
            class_2302 cropBlock;
            class_2680 state = pLevel.method_8320(pPos);
            class_2248 class_22482 = state.method_26204();
            return class_22482 instanceof class_2302 && (cropBlock = (class_2302)class_22482).method_9829(state) < cropBlock.method_9827();
        }

        public void method_6268() {
            class_2338 blockpos = this.method_30953();
            if (!blockpos.method_19769((class_2374)this.field_6516.method_19538(), this.method_6291())) {
                ++this.field_6517;
                if (this.method_6294()) {
                    this.field_6516.method_5942().method_6337((double)blockpos.method_10263() + 0.5, (double)blockpos.method_10264(), (double)blockpos.method_10260() + 0.5, this.field_6514);
                }
            } else {
                this.onReachedTarget();
            }
        }

        protected void onReachedTarget() {
            class_2680 state = this.butterfly.method_37908().method_8320(this.field_6512);
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof class_2302) {
                class_2302 cropBlock = (class_2302)class_22482;
                cropBlock.method_9826(this.butterfly.method_37908(), this.field_6512, state);
                this.butterfly.incrementNumCropsGrownSincePollination();
                this.method_6270();
            }
        }

        public boolean method_6264() {
            return this.butterfly.hasNectar() && super.method_6264();
        }

        public boolean method_6266() {
            return this.butterfly.hasNectar() && super.method_6266();
        }
    }

    static class ButterflyPollinateGoal
    extends class_1367 {
        protected int ticksWaited;
        private final Butterfly butterfly;

        public ButterflyPollinateGoal(@NotNull Butterfly pMob, double pSpeedModifier, int pSearchRange, int pVerticalSearchRange) {
            super((class_1314)pMob, pSpeedModifier, pSearchRange, pVerticalSearchRange);
            this.butterfly = pMob;
        }

        protected boolean method_6296(class_4538 pLevel, class_2338 pPos) {
            return pLevel.method_8320(pPos).method_26164(class_3481.field_20339);
        }

        public void method_6268() {
            super.method_6268();
            if (this.method_6295()) {
                if (this.ticksWaited >= 40) {
                    this.onReachedTarget();
                } else {
                    ++this.ticksWaited;
                }
            }
        }

        protected void onReachedTarget() {
            class_2680 state = this.butterfly.method_37908().method_8320(this.field_6512);
            if (state.method_26164(class_3481.field_20339)) {
                this.butterfly.setHasNectar(true);
                this.method_6270();
            }
        }

        public boolean method_6264() {
            return !this.butterfly.hasNectar() && super.method_6264();
        }

        public boolean method_6266() {
            return !this.butterfly.hasNectar() && super.method_6266();
        }

        public void method_6269() {
            super.method_6269();
            this.ticksWaited = 0;
        }
    }

    public static enum Variant {
        CABBAGE_WHITE(0, "cabbage_white", true),
        MONARCH(1, "monarch", true),
        CLOUDED_YELLOW(2, "clouded_yellow", true),
        SWALLOWTAIL(3, "swallowtail", true),
        BLUE_MORPHO(4, "blue_morpho", true);

        public static final Variant[] BY_ID;
        private final int id;
        private final String name;
        private final boolean common;

        private Variant(int j, String string2, boolean bl) {
            this.id = j;
            this.name = string2;
            this.common = bl;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @NotNull
        public static Variant getTypeById(int id) {
            for (Variant type : Variant.values()) {
                if (type.id != id) continue;
                return type;
            }
            return MONARCH;
        }

        public static @NotNull Variant getCommonSpawnVariant(class_5819 random) {
            return Variant.getSpawnVariant(random, true);
        }

        private static @NotNull Variant getSpawnVariant(class_5819 random, boolean common) {
            Variant[] variants = (Variant[])Arrays.stream(BY_ID).filter(variant -> variant.common == common).toArray(Variant[]::new);
            return (Variant)((Object)class_156.method_27173((Object[])variants, (class_5819)random));
        }

        static {
            BY_ID = (Variant[])Arrays.stream(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }

    public static class ButterflyGroupData
    extends class_1296.class_4697 {
        public final Variant[] types;

        public ButterflyGroupData(Variant ... variants) {
            super(false);
            this.types = variants;
        }

        public Variant getVariant(class_5819 random) {
            return this.types[random.method_43048(this.types.length)];
        }
    }
}

