/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.common.entity;

import com.starfish_studios.naturalist.common.entity.core.NaturalistAnimal;
import com.starfish_studios.naturalist.common.entity.core.NaturalistGeoEntity;
import com.starfish_studios.naturalist.common.entity.core.ai.goal.BigPanicGoal;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.MMPathNavigatorGround;
import com.starfish_studios.naturalist.common.entity.core.ai.navigation.SmartBodyHelper;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.core.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.core.registry.NaturalistTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1330;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5275;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Giraffe
extends NaturalistAnimal
implements NaturalistGeoEntity {
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.sf_nba.giraffe.idle");
    protected static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.sf_nba.giraffe.walk");
    protected static final RawAnimation RUN = RawAnimation.begin().thenLoop("animation.sf_nba.giraffe.run");
    private static final class_1856 FOOD_ITEMS = class_1856.method_8106(NaturalistTags.ItemTags.GIRAFFE_FOOD_ITEMS);
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final class_2940<Integer> TAME_TICKS = class_2945.method_12791(Giraffe.class, (class_2941)class_2943.field_13327);

    public Giraffe(class_1299<? extends NaturalistAnimal> entityType, class_1937 level) {
        super(entityType, level);
        this.method_49477(1.0f);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 35.0).method_26868(class_5134.field_23719, 0.25);
    }

    public int method_5986() {
        return 45;
    }

    @NotNull
    protected class_1330 method_5963() {
        return new SmartBodyHelper((class_1308)this);
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 level) {
        return new MMPathNavigatorGround((class_1308)this, level);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new BigPanicGoal((class_1314)this, 1.4));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.0, FOOD_ITEMS, false));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 0.7));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
    }

    public boolean method_6481(class_1799 stack) {
        return FOOD_ITEMS.method_8093(stack);
    }

    public void method_5958() {
        super.method_5958();
        if (this.method_5962().method_6241()) {
            this.method_5728(this.method_5962().method_6242() >= 1.3);
        } else {
            this.method_5728(false);
        }
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverLevel, class_1296 ageableMob) {
        return (class_1296)NaturalistEntityTypes.GIRAFFE.get().method_5883((class_1937)serverLevel);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TAME_TICKS, (Object)0);
    }

    public void method_5652(class_2487 pCompound) {
        super.method_5652(pCompound);
        pCompound.method_10569("TameTicks", this.getTameTicks());
    }

    public void method_5749(class_2487 pCompound) {
        super.method_5749(pCompound);
        this.setTameTicks(pCompound.method_10550("TameTicks"));
    }

    public void setTameTicks(int ticks) {
        this.field_6011.method_12778(TAME_TICKS, (Object)ticks);
    }

    public int getTameTicks() {
        return (Integer)this.field_6011.method_12789(TAME_TICKS);
    }

    public boolean isTame() {
        return this.getTameTicks() > 0;
    }

    public boolean method_5810() {
        return !this.method_5782();
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().method_8608() && this.method_5642() != null) {
            this.setTameTicks(Math.max(0, this.getTameTicks() - 1));
            if (!this.isTame()) {
                this.method_5642().method_5848();
                this.method_5783(class_3417.field_14586, this.method_6107(), this.method_6017());
            }
        }
    }

    protected void doPlayerRide(@NotNull class_1657 player) {
        if (!this.method_37908().field_9236) {
            player.method_36456(this.method_36454());
            player.method_36457(this.method_36455());
            player.method_5804((class_1297)this);
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!this.method_6109() && this.method_5782()) {
            return super.method_5992(player, hand);
        }
        if (!stack.method_7960()) {
            if (this.method_6481(stack)) {
                if (this.handleEating(player, stack)) {
                    if (!player.method_31549().field_7477) {
                        stack.method_7934(1);
                    }
                } else {
                    this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14586, this.method_5634(), 1.0f, 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f);
                }
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (this.method_6109()) {
            return super.method_5992(player, hand);
        }
        if (this.isTame()) {
            this.doPlayerRide(player);
        }
        return class_1269.method_29236((boolean)this.method_37908().field_9236);
    }

    protected boolean handleEating(class_1657 player, @NotNull class_1799 stack) {
        boolean shouldEat = false;
        float foodHealAmount = 0.0f;
        int ageUpAmount = 0;
        if (stack.method_31574(class_1802.field_17528)) {
            foodHealAmount = 20.0f;
            ageUpAmount = 180;
            if (!this.method_37908().method_8608() && this.method_5618() == 0 && !this.method_6479()) {
                shouldEat = true;
                this.method_6480(player);
            }
        } else if (FOOD_ITEMS.method_8093(stack)) {
            foodHealAmount = 2.0f;
            ageUpAmount = 20;
            if (!this.method_37908().method_8608()) {
                if (this.getTameTicks() > 0) {
                    this.method_37908().method_8421((class_1297)this, (byte)6);
                } else {
                    shouldEat = true;
                    this.setTameTicks(600);
                    this.method_37908().method_8421((class_1297)this, (byte)7);
                }
            }
        }
        if (this.method_6032() < this.method_6063() && foodHealAmount > 0.0f) {
            this.method_6025(foodHealAmount);
            shouldEat = true;
        }
        if (this.method_6109() && ageUpAmount > 0) {
            this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 0.0, 0.0, 0.0);
            if (!this.method_37908().field_9236) {
                this.method_5615(ageUpAmount);
            }
            shouldEat = true;
        }
        if (shouldEat) {
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15099, this.method_5634(), 1.0f, 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f);
            this.method_6104(class_1268.field_5808);
            this.method_32876(class_5712.field_28735);
        }
        return shouldEat;
    }

    public void method_6091(class_243 travelVector) {
        if (!this.method_5805()) {
            return;
        }
        class_1309 livingEntity = this.method_5642();
        if (!this.method_5782() || livingEntity == null) {
            super.method_6091(travelVector);
            return;
        }
        this.method_36456(livingEntity.method_36454());
        this.field_5982 = this.method_36454();
        this.method_36457(livingEntity.method_36455() * 0.5f);
        this.method_5710(this.method_36454(), this.method_36455());
        this.field_6241 = this.field_6283 = this.method_36454();
        float f = livingEntity.field_6212 * 0.5f;
        float g = livingEntity.field_6250;
        if (this.method_5787()) {
            this.method_6125((float)this.method_26825(class_5134.field_23719));
            super.method_6091(new class_243((double)f, travelVector.field_1351, (double)g));
        } else if (livingEntity instanceof class_1657) {
            this.method_18799(class_243.field_1353);
        }
        this.method_29242(false);
        this.method_36974();
    }

    public boolean method_6474(class_1429 otherAnimal) {
        return !this.method_5782() && !this.method_5765() && !this.method_6109() && super.method_6474(otherAnimal);
    }

    protected boolean method_6062() {
        return super.method_6062() && this.method_5782();
    }

    protected void spawnTamingParticles(boolean tamed) {
        class_2400 particleOptions = tamed ? class_2398.field_11201 : class_2398.field_11251;
        for (int i = 0; i < 7; ++i) {
            double d = this.field_5974.method_43059() * 0.02;
            double e = this.field_5974.method_43059() * 0.02;
            double f = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406((class_2394)particleOptions, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
        }
    }

    public void method_5711(byte id) {
        if (id == 7) {
            this.spawnTamingParticles(true);
        } else if (id == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.method_5711(id);
        }
    }

    protected void method_5865(class_1297 passenger, class_1297.class_4738 callback) {
        super.method_5865(passenger, callback);
        if (passenger instanceof class_1308) {
            class_1308 mob = (class_1308)passenger;
            this.field_6283 = mob.field_6283;
        }
        callback.accept(passenger, this.method_23317(), this.method_23318() + this.method_5621() + passenger.method_5678(), this.method_23321());
        if (passenger instanceof class_1309) {
            class_1309 livingEntity = (class_1309)passenger;
            livingEntity.field_6283 = this.field_6283;
        }
    }

    public double method_5621() {
        return (double)this.method_17682() * 0.6;
    }

    public boolean method_6101() {
        return false;
    }

    @Nullable
    public class_1309 method_5642() {
        class_1297 entity = this.method_31483();
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            return livingEntity;
        }
        return null;
    }

    @Nullable
    private class_243 getDismountLocationInDirection(class_243 direction, class_1309 passenger) {
        double d = this.method_23317() + direction.field_1352;
        double e = this.method_5829().field_1322;
        double f = this.method_23321() + direction.field_1350;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        block0: for (class_4050 pose : passenger.method_24831()) {
            mutableBlockPos.method_10102(d, e, f);
            double g = this.method_5829().field_1325 + 0.75;
            do {
                double h = this.method_37908().method_30347((class_2338)mutableBlockPos);
                if ((double)mutableBlockPos.method_10264() + h > g) continue block0;
                if (class_5275.method_27932((double)h)) {
                    class_238 aABB = passenger.method_24833(pose);
                    class_243 vec3 = new class_243(d, (double)mutableBlockPos.method_10264() + h, f);
                    if (class_5275.method_27933((class_1941)this.method_37908(), (class_1309)passenger, (class_238)aABB.method_997(vec3))) {
                        passenger.method_18380(pose);
                        return vec3;
                    }
                }
                mutableBlockPos.method_10098(class_2350.field_11036);
            } while ((double)mutableBlockPos.method_10264() < g);
        }
        return null;
    }

    public class_243 method_24829(@NotNull class_1309 passenger) {
        class_243 vec3 = class_1496.method_24826((double)this.method_17681(), (double)passenger.method_17681(), (float)(this.method_36454() + (passenger.method_6068() == class_1306.field_6183 ? 90.0f : -90.0f)));
        class_243 vec32 = this.getDismountLocationInDirection(vec3, passenger);
        if (vec32 != null) {
            return vec32;
        }
        class_243 vec33 = class_1496.method_24826((double)this.method_17681(), (double)passenger.method_17681(), (float)(this.method_36454() + (passenger.method_6068() == class_1306.field_6182 ? 90.0f : -90.0f)));
        class_243 vec34 = this.getDismountLocationInDirection(vec33, passenger);
        if (vec34 != null) {
            return vec34;
        }
        return this.method_19538();
    }

    @Nullable
    protected class_3414 method_5994() {
        return NaturalistSoundEvents.GIRAFFE_AMBIENT.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    private <E extends Giraffe> PlayState predicate(AnimationState<E> event) {
        if (this.method_6109()) {
            event.setControllerSpeed(1.4f + event.getLimbSwingAmount());
        } else {
            event.setControllerSpeed(1.0f + event.getLimbSwingAmount());
        }
        if (this.method_18798().method_37268() > 1.0E-6) {
            if (this.method_5624() || !this.method_5685().isEmpty()) {
                event.getController().setAnimation(RUN);
                if (this.method_6109()) {
                    event.getController().setAnimationSpeed(1.4 + (double)event.getLimbSwingAmount());
                } else {
                    event.getController().setAnimationSpeed(1.2 + (double)event.getLimbSwingAmount());
                }
            } else {
                event.getController().setAnimation(WALK);
            }
        } else {
            event.getController().setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate)});
    }
}

