/*
 * Decompiled with CFR 0.152.
 */
package prim.upsidedown.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_11;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1359;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1686;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_4538;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import prim.upsidedown.blocks.FloorGateBlock;
import prim.upsidedown.blocks.FloorGateBlockEntity;
import prim.upsidedown.core.UDMBlocks;
import prim.upsidedown.core.UDMEffects;
import prim.upsidedown.core.UDMSounds;
import prim.upsidedown.dimension.UpsideDown;
import prim.upsidedown.entity.ai.goal.BleedingKidnapGoal;

public class DemogorgonEntity
extends class_1588
implements class_5354 {
    private static final class_2940<Boolean> ATTACKING = class_2945.method_12791(DemogorgonEntity.class, (class_2941)class_2943.field_13323);
    private static final UUID ATTACKING_SPEED_BOOST_ID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final class_1322 ATTACKING_SPEED_BOOST;
    private static final int field_30462 = 400;
    private static final int field_30461 = 600;
    private static final class_2940<Optional<class_2680>> CARRIED_BLOCK;
    private static final class_2940<Boolean> ANGRY;
    private static final class_2940<Boolean> PROVOKED;
    private int lastAngrySoundAge = Integer.MIN_VALUE;
    private int ageWhenTargetSet;
    private static final class_6019 ANGER_TIME_RANGE;
    private int angerTime;
    @Nullable
    private UUID angryAt;
    private int stuckTimer = 0;
    private int missedAttackCounter = 0;
    private static final int STUCK_THRESHOLD = 100;
    private static final int MISSED_ATTACK_THRESHOLD = 5;
    private int stuckAmbushTime = -1;
    public class_1657 playentity;
    public final class_7094 idleAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;
    public final class_7094 attackAnimationState = new class_7094();
    public final class_7094 portaloutAnimationState = new class_7094();
    public int portaloutAnimationTimeout = 0;
    public final class_7094 runAttackAnimationState = new class_7094();
    public final class_7094 portalinAnimationState = new class_7094();
    public int portalinAnimationTimeout = 0;
    public int attackAnimationTimeout = 0;
    public boolean skipDiscard = false;
    private int onFireTimer = -1;
    private boolean isPanicking = false;
    private static final Predicate<class_1309> ALL_MOBS_EXCEPT_DEMOGORGON;
    public String animationState = "idle";
    private int noTargetTicks = 0;
    public boolean isAttacking = false;
    public class_2338 teleportGateSpawn;
    public class_2248 GateSpawnBlock;
    public int crawlintimer = -1;
    private static final class_2940<Boolean> CRAWLING_IN;
    private static final class_2940<Boolean> CRAWLING_OUT;
    private static final class_2940<Boolean> AMBUSH_SEQUENCE;
    private static final class_2940<Integer> AMBUSH_COUNTER;
    private static final class_2940<Integer> ATTACK_SEQUENCE_TICKS;
    private static final class_2940<Boolean> RUN_ATTACK_ACTIVE;
    private static final class_2940<Integer> KIDNAP_COOLDOWN;

    public boolean isTargetWithinDistance(double distance) {
        class_1309 target = this.method_5968();
        if (target != null) {
            return (double)this.method_5739((class_1297)target) <= distance;
        }
        return false;
    }

    private void setupAnimationStates() {
        if (((Boolean)this.field_6011.method_12789(CRAWLING_OUT)).booleanValue()) {
            this.idleAnimationState.method_41325();
            this.attackAnimationState.method_41325();
            this.runAttackAnimationState.method_41325();
            if (this.portaloutAnimationTimeout <= 0) {
                this.portaloutAnimationState.method_41322(this.field_6012);
                this.method_5977(true);
                this.method_5942().method_6340();
                this.method_18799(class_243.field_1353);
            }
            if (this.portaloutAnimationTimeout >= 213) {
                this.portaloutAnimationState.method_41325();
                this.portaloutAnimationTimeout = 0;
                this.method_5977(false);
                this.setCrawlingOut(false);
            } else {
                this.method_5942().method_6340();
                this.method_18799(class_243.field_1353);
                this.method_5977(true);
                this.method_5980(null);
                ++this.portaloutAnimationTimeout;
                return;
            }
        }
        if (((Boolean)this.field_6011.method_12789(CRAWLING_IN)).booleanValue()) {
            this.idleAnimationState.method_41325();
            this.attackAnimationState.method_41325();
            this.runAttackAnimationState.method_41325();
            if (this.portalinAnimationTimeout <= 0) {
                this.portalinAnimationState.method_41322(this.field_6012);
            }
            if (this.portalinAnimationTimeout >= 101) {
                this.portalinAnimationState.method_41325();
                this.portalinAnimationTimeout = 0;
                this.method_5977(false);
                this.setCrawlingIn(false);
                if (!this.skipDiscard) {
                    this.method_31472();
                }
            } else {
                this.method_5942().method_6340();
                this.method_18799(class_243.field_1353);
                this.method_5977(true);
                ++this.portalinAnimationTimeout;
                return;
            }
        }
        if (this.getAttackSequenceTicks() > 0) {
            this.idleAnimationState.method_41325();
            if (this.isRunAttacking()) {
                this.attackAnimationState.method_41325();
                if (!this.runAttackAnimationState.method_41327()) {
                    this.runAttackAnimationState.method_41322(this.field_6012);
                }
            } else {
                this.runAttackAnimationState.method_41325();
                if (!this.attackAnimationState.method_41327()) {
                    this.attackAnimationState.method_41322(this.field_6012);
                }
            }
            return;
        }
        this.attackAnimationState.method_41325();
        this.runAttackAnimationState.method_41325();
        if (!this.idleAnimationState.method_41327()) {
            this.idleAnimationState.method_41322(this.field_6012);
        }
    }

    public void method_19540(boolean attacking) {
        this.field_6011.method_12778(ATTACKING, (Object)attacking);
    }

    public boolean method_6510() {
        return (Boolean)this.field_6011.method_12789(ATTACKING);
    }

    protected void method_48565(float posDelta) {
        float f = this.method_18376() == class_4050.field_18076 ? Math.min(posDelta * 6.0f, 1.0f) : 0.0f;
        this.field_42108.method_48568(f, 0.2f);
    }

    public static class_5132.class_5133 createDemogorgonAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 100.0).method_26868(class_5134.field_23719, 0.45).method_26868(class_5134.field_23721, 10.0).method_26868(class_5134.field_23717, 100.0);
    }

    public DemogorgonEntity(class_1299<? extends DemogorgonEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(1.0f);
        this.method_5941(class_7.field_9, -1.0f);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(5, (class_1352)new DemogorgonEscapeDangerGoal((class_1314)this, 1.5));
        this.field_6201.method_6277(1, (class_1352)new MeleeAttackGoal((class_1314)this, 1.0, true));
        this.field_6201.method_6277(3, (class_1352)new class_1359((class_1308)this, 0.4f));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1379((class_1314)this, 0.5));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new DemogorgonTeleportTowardsPlayerGoal(this, arg_0 -> ((DemogorgonEntity)this).method_29515(arg_0)));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1309.class, 10, true, false, ALL_MOBS_EXCEPT_DEMOGORGON));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
    }

    public static class_5132.class_5133 createEndermanAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 40.0).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23721, 7.0).method_26868(class_5134.field_23717, 64.0);
    }

    private void playCustomSound(class_1937 world, class_2338 pos, class_3414 soundEvent) {
        world.method_8396(null, pos, soundEvent, class_3419.field_15251, 1.5f, 1.0f);
    }

    public void teleportBehindPlayer(class_1657 player) {
        class_243 playerPos = player.method_19538();
        class_243 glorganPos = this.method_19538();
        class_243 playerLookVec = player.method_5828(1.0f).method_1029();
        class_243 behindPlayerPos = playerPos.method_1020(playerLookVec.method_1021(2.0));
        this.playCustomSound(this.method_37908(), player.method_24515(), UDMSounds.DEMOGORGON_PREPARE);
        class_2338 teleportPos = class_2338.method_49638((class_2374)behindPlayerPos);
        this.method_20620(teleportPos.method_10263(), teleportPos.method_10264(), teleportPos.method_10260());
    }

    private boolean isValidTeleportPosition(class_2338 pos) {
        class_1937 world = this.method_37908();
        return world.method_8320(pos).method_26215() && world.method_8320(pos.method_10084()).method_26215() && world.method_8320(pos.method_10074()).method_26212((class_1922)world, pos.method_10074());
    }

    public String getAnimationState() {
        return this.animationState;
    }

    public void setAnimationState(String animationState) {
        this.animationState = animationState;
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        this.portaloutAnimationTimeout = 0;
        this.setCrawlingOut(true);
    }

    public void method_5980(@Nullable class_1309 target) {
        super.method_5980(target);
        class_1324 entityAttributeInstance = this.method_5996(class_5134.field_23719);
        if (target == null) {
            this.ageWhenTargetSet = 0;
            this.field_6011.method_12778(ANGRY, (Object)false);
            this.field_6011.method_12778(PROVOKED, (Object)false);
            entityAttributeInstance.method_6202(ATTACKING_SPEED_BOOST);
        } else {
            this.ageWhenTargetSet = this.field_6012;
            this.field_6011.method_12778(ANGRY, (Object)true);
            if (!entityAttributeInstance.method_6196(ATTACKING_SPEED_BOOST)) {
                entityAttributeInstance.method_26835(ATTACKING_SPEED_BOOST);
            }
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ATTACKING, (Object)false);
        this.field_6011.method_12784(CARRIED_BLOCK, Optional.empty());
        this.field_6011.method_12784(ANGRY, (Object)false);
        this.field_6011.method_12784(PROVOKED, (Object)false);
        this.field_6011.method_12784(CRAWLING_IN, (Object)false);
        this.field_6011.method_12784(CRAWLING_OUT, (Object)false);
        this.field_6011.method_12784(AMBUSH_SEQUENCE, (Object)false);
        this.field_6011.method_12784(AMBUSH_COUNTER, (Object)0);
        this.field_6011.method_12784(KIDNAP_COOLDOWN, (Object)1000);
        this.field_6011.method_12784(ATTACK_SEQUENCE_TICKS, (Object)0);
        this.field_6011.method_12784(RUN_ATTACK_ACTIVE, (Object)false);
    }

    public void setCrawlingIn(boolean value) {
        this.field_6011.method_12778(CRAWLING_IN, (Object)value);
    }

    public void setCrawlingOut(boolean value) {
        this.field_6011.method_12778(CRAWLING_OUT, (Object)value);
    }

    public void setAmbushSequence(boolean value) {
        this.field_6011.method_12778(AMBUSH_SEQUENCE, (Object)value);
    }

    public boolean isRunAttacking() {
        return (Boolean)this.field_6011.method_12789(RUN_ATTACK_ACTIVE);
    }

    public void setRunAttacking(boolean active) {
        this.field_6011.method_12778(RUN_ATTACK_ACTIVE, (Object)active);
    }

    public int getAttackSequenceTicks() {
        return (Integer)this.field_6011.method_12789(ATTACK_SEQUENCE_TICKS);
    }

    public void setAttackSequenceTicks(int ticks) {
        this.field_6011.method_12778(ATTACK_SEQUENCE_TICKS, (Object)ticks);
    }

    public int getAmbushCounter() {
        return (Integer)this.field_6011.method_12789(AMBUSH_COUNTER);
    }

    public void setAmbushCounter(int value) {
        this.field_6011.method_12778(AMBUSH_COUNTER, (Object)value);
    }

    public void method_29509() {
        this.method_29514(ANGER_TIME_RANGE.method_35008(this.field_5974));
    }

    public void method_29514(int angerTime) {
        this.angerTime = angerTime;
    }

    public int method_29507() {
        return this.angerTime;
    }

    public void method_29513(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    @Nullable
    public UUID method_29508() {
        return this.angryAt;
    }

    public void playAngrySound() {
        if (this.field_6012 >= this.lastAngrySoundAge + 400) {
            this.lastAngrySoundAge = this.field_6012;
            if (!this.method_5701()) {
                this.method_37908().method_8486(this.method_23317(), this.method_23320(), this.method_23321(), UDMSounds.DEMOGORGON_ROAR, this.method_5634(), 2.5f, 1.0f, false);
            }
        }
    }

    public void method_5674(class_2940<?> data) {
        if (ANGRY.equals(data) && this.isProvoked() && this.method_37908().field_9236) {
            this.playAngrySound();
        }
        super.method_5674(data);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        class_2680 blockState = this.getCarriedBlock();
        if (blockState != null) {
            nbt.method_10566("carriedBlockState", (class_2520)class_2512.method_10686((class_2680)blockState));
        }
        this.method_29517(nbt);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        class_2680 blockState = null;
        if (nbt.method_10573("carriedBlockState", 10) && (blockState = class_2512.method_10681((class_7871)this.method_37908().method_45448(class_7924.field_41254), (class_2487)nbt.method_10562("carriedBlockState"))).method_26215()) {
            blockState = null;
        }
        this.setCarriedBlock(blockState);
        this.method_29512(this.method_37908(), nbt);
    }

    boolean isPlayerStaring(class_1657 player) {
        class_1799 itemStack = (class_1799)player.method_31548().field_7548.get(3);
        if (itemStack.method_31574(class_2246.field_10147.method_8389())) {
            return false;
        }
        class_243 vec3d = player.method_5828(1.0f).method_1029();
        class_243 vec3d2 = new class_243(this.method_23317() - player.method_23317(), this.method_23320() - player.method_23320(), this.method_23321() - player.method_23321());
        double d = vec3d2.method_1033();
        double e = vec3d.method_1026(vec3d2 = vec3d2.method_1029());
        return e > 1.0 - 0.025 / d ? player.method_6057((class_1297)this) : false;
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return 2.55f;
    }

    public void method_6007() {
        this.field_6282 = false;
        if (!this.method_37908().field_9236) {
            this.method_29510((class_3218)this.method_37908(), true);
        }
        super.method_6007();
    }

    private void stopPanic() {
        if (this.isPanicking) {
            this.isPanicking = false;
        }
        this.onFireTimer = -1;
    }

    public boolean method_29503() {
        return false;
    }

    private void ambushSequenceClient() {
        if (((Boolean)this.field_6011.method_12789(AMBUSH_SEQUENCE)).booleanValue()) {
            if (this.getAmbushCounter() == 1) {
                this.portalinAnimationState.method_41322(this.field_6012);
            }
            if (this.getAmbushCounter() == 100) {
                this.portalinAnimationState.method_41325();
                this.portaloutAnimationState.method_41322(this.field_6012);
            }
            if (this.getAmbushCounter() >= 314) {
                this.portaloutAnimationState.method_41325();
            }
        }
    }

    private void ambushSequence() {
        if (((Boolean)this.field_6011.method_12789(AMBUSH_SEQUENCE)).booleanValue()) {
            if (this.getAmbushCounter() < 0) {
                this.setAmbushCounter(0);
            }
            if (this.getAmbushCounter() == 0) {
                // empty if block
            }
            if (this.getAmbushCounter() < 101) {
                this.setAmbushCounter(this.getAmbushCounter() + 1);
            }
            if (this.getAmbushCounter() == 101) {
                class_1657 nearestPlayer = this.method_37908().method_18460((class_1297)this, 20.0);
                if (nearestPlayer == null) {
                    return;
                }
                this.playentity = nearestPlayer;
                this.teleportBehindPlayer(this.playentity);
                this.setAmbushCounter(this.getAmbushCounter() + 1);
            }
            if (this.getAmbushCounter() > 101 && this.getAmbushCounter() < 314) {
                this.setAmbushCounter(this.getAmbushCounter() + 1);
            }
            if (this.getAmbushCounter() >= 314) {
                this.setAmbushCounter(0);
                this.field_6011.method_12778(AMBUSH_SEQUENCE, (Object)false);
            }
        }
    }

    private void tickAttackSequence() {
        int ticks = this.getAttackSequenceTicks();
        if (ticks <= 0) {
            return;
        }
        boolean isRunAttack = this.isRunAttacking();
        class_1309 target = this.method_5968();
        this.method_5942().method_6340();
        this.method_18799(this.method_18798().method_18805(0.0, 1.0, 0.0));
        if (isRunAttack) {
            if (ticks == 42) {
                class_243 lookVec = this.method_5828(1.0f).method_18805(1.2, 0.0, 1.2);
                this.method_5762(lookVec.field_1352, 0.2, lookVec.field_1350);
                if (target != null && (double)this.method_5739((class_1297)target) <= 4.0) {
                    this.performSequenceHit(target, 12.0f, 0.5f, false);
                }
            }
            if (ticks <= 36) {
                this.method_5942().method_6340();
                this.method_18799(class_243.field_1353);
            }
        } else {
            if (ticks == 10 && target != null && (double)this.method_5739((class_1297)target) <= 3.0) {
                this.performSequenceHit(target, 4.0f, 0.4f, true);
            }
            if (ticks == 19 && target != null && (double)this.method_5739((class_1297)target) <= 3.0) {
                this.performSequenceHit(target, 6.0f, 0.8f, true);
            }
            if (ticks == 29) {
                class_243 lookVec = this.method_5828(1.0f).method_18805(0.5, 0.0, 0.5);
                this.method_5762(lookVec.field_1352, 0.1, lookVec.field_1350);
                if (target != null && (double)this.method_5739((class_1297)target) <= 3.5) {
                    this.performSequenceHit(target, 12.0f, 0.0f, false);
                }
            }
        }
        this.setAttackSequenceTicks(ticks - 1);
        if (ticks - 1 <= 0) {
            this.method_19540(false);
            this.setRunAttacking(false);
        }
    }

    private void performSequenceHit(class_1309 target, float damage, float bleedChance, boolean trapTarget) {
        target.method_5643(this.method_48923().method_48812((class_1309)this), damage);
        if (bleedChance > 0.0f && this.field_5974.method_43057() < bleedChance) {
            target.method_6092(new class_1293(UDMEffects.BLEEDING, 100, 0));
        }
        if (trapTarget) {
            target.method_18799(class_243.field_1353);
            target.field_6037 = true;
        }
    }

    protected void method_5958() {
        if ((Integer)this.field_6011.method_12789(KIDNAP_COOLDOWN) < 1000) {
            this.field_6011.method_12778(KIDNAP_COOLDOWN, (Object)((Integer)this.field_6011.method_12789(KIDNAP_COOLDOWN) + 1));
        }
        if (this.getAttackSequenceTicks() > 0) {
            this.tickAttackSequence();
            super.method_5958();
            return;
        }
        if (((Boolean)this.field_6011.method_12789(AMBUSH_SEQUENCE)).booleanValue()) {
            this.tickAmbushSequence();
            super.method_5958();
            return;
        }
        class_1309 class_13092 = this.method_5968();
        if (class_13092 instanceof class_1657) {
            class_1657 target = (class_1657)class_13092;
            if (this.method_6510()) {
                this.stuckTimer = this.method_18798().method_37268() < 0.001 ? ++this.stuckTimer : 0;
                if (this.stuckTimer >= 100) {
                    this.stuckTimer = 0;
                    this.playentity = target;
                    this.setAmbushCounter(0);
                    this.field_6011.method_12778(AMBUSH_SEQUENCE, (Object)true);
                    this.method_5942().method_6340();
                }
            }
        }
        class_243 currentPos = this.method_19538();
        if (this.method_5809()) {
            if (!this.isPanicking) {
                this.isPanicking = true;
                this.method_19540(false);
                this.method_5980(null);
            }
            if (this.onFireTimer == -1) {
                this.onFireTimer = 100;
            }
        } else {
            this.stopPanic();
        }
        if (this.onFireTimer >= 0) {
            --this.onFireTimer;
            if (this.onFireTimer == 0 && this.field_6235 <= 0 && !this.method_37908().field_9236) {
                class_1937 world = this.method_37908();
                if (world == world.method_8503().method_3847(class_1937.field_25179)) {
                    this.teleportRandomly();
                } else if (world == world.method_8503().method_3847(UpsideDown.UPSIDE_DOWN_DIMENSION_KEY)) {
                    class_2338 gateSpawn = new class_2338((int)this.method_19538().method_10216(), (int)(this.method_19538().method_10214() - 1.0), (int)this.method_19538().method_10215());
                    class_3218 UD = this.method_37908().method_8503().method_3847(UpsideDown.UPSIDE_DOWN_DIMENSION_KEY);
                    class_3218 OV = this.method_37908().method_8503().method_3847(class_1937.field_25179);
                    FloorGateBlock.gateSpawn(gateSpawn, UD);
                    FloorGateBlock.gateSpawn(gateSpawn, OV);
                    this.method_31472();
                }
                this.method_5783(class_3417.field_14879, 1.0f, 1.0f);
            }
        }
        this.noTargetTicks = this.method_5968() == null ? ++this.noTargetTicks : 0;
        if (this.noTargetTicks == 1200) {
            this.portalinAnimationTimeout = 0;
            this.setCrawlingIn(true);
        }
        if (this.noTargetTicks >= 1301) {
            this.method_31472();
        }
        if (this.method_5968() != null) {
            this.setAnimationState("attacking");
            this.isAttacking = true;
        } else {
            this.setAnimationState("idle");
            this.isAttacking = false;
        }
        super.method_5958();
    }

    private void tickAmbushSequence() {
        int counter = this.getAmbushCounter();
        this.setAmbushCounter(counter + 1);
        this.method_5942().method_6340();
        this.method_18799(class_243.field_1353);
        this.method_5977(true);
        if (counter == 1) {
            this.setCrawlingIn(true);
            this.skipDiscard = true;
        }
        if (counter == 52) {
            this.setCrawlingIn(false);
            if (this.playentity == null || !this.playentity.method_5805()) {
                this.field_6011.method_12778(AMBUSH_SEQUENCE, (Object)false);
                this.method_5977(false);
                return;
            }
            this.teleportBehindPlayer(this.playentity);
            this.setCrawlingOut(true);
        }
        if (counter >= 160) {
            this.setCrawlingOut(false);
            this.setAmbushCounter(0);
            this.field_6011.method_12778(AMBUSH_SEQUENCE, (Object)false);
            this.method_5977(false);
            this.skipDiscard = false;
        }
    }

    public void method_48922(class_1282 source) {
        super.method_48922(source);
        if (this.onFireTimer >= 0) {
            this.onFireTimer = -1;
        }
    }

    public void method_6005(double strength, double x, double z) {
    }

    protected boolean teleportRandomly() {
        if (!this.method_37908().method_8608() && this.method_5805()) {
            double d = this.method_23317() + (this.field_5974.method_43058() - 0.5) * 64.0;
            double e = this.method_23318() + (double)(this.field_5974.method_43048(64) - 32);
            double f = this.method_23321() + (this.field_5974.method_43058() - 0.5) * 64.0;
            return this.teleportTo(d, e, f);
        }
        return false;
    }

    boolean teleportTo(class_1297 entity) {
        class_243 vec3d = new class_243(this.method_23317() - entity.method_23317(), this.method_23323(0.5) - entity.method_23320(), this.method_23321() - entity.method_23321());
        vec3d = vec3d.method_1029();
        double d = 16.0;
        double e = this.method_23317() + (this.field_5974.method_43058() - 0.5) * 8.0 - vec3d.field_1352 * 16.0;
        double f = this.method_23318() + (double)(this.field_5974.method_43048(16) - 8) - vec3d.field_1351 * 16.0;
        double g = this.method_23321() + (this.field_5974.method_43058() - 0.5) * 8.0 - vec3d.field_1350 * 16.0;
        return this.teleportTo(e, f, g);
    }

    private class_2338 findFloorGateInRadius(class_3218 world, class_2338 center, int radius) {
        int startX = center.method_10263() - radius;
        int startY = Math.max(world.method_31607(), center.method_10264() - radius);
        int startZ = center.method_10260() - radius;
        int endX = center.method_10263() + radius;
        int endY = Math.min(world.method_31600(), center.method_10264() + radius);
        int endZ = center.method_10260() + radius;
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    if (!world.method_8320(pos).method_27852(UDMBlocks.FLOOR_GATE)) continue;
                    return pos;
                }
            }
        }
        return null;
    }

    private boolean teleportTo(double x, double y, double z) {
        class_2338.class_2339 mutable = new class_2338.class_2339(x, y, z);
        while (mutable.method_10264() > this.method_37908().method_31607() && !this.method_37908().method_8320((class_2338)mutable).method_51366()) {
            mutable.method_10098(class_2350.field_11033);
        }
        class_2680 blockState = this.method_37908().method_8320((class_2338)mutable);
        boolean bl = blockState.method_51366();
        boolean bl2 = blockState.method_26227().method_15767(class_3486.field_15517);
        if (bl && !bl2) {
            class_243 vec3d = this.method_19538();
            class_2338 portalplace = this.method_24515();
            this.teleportGateSpawn = new class_2338(portalplace.method_10263(), portalplace.method_10264() - 1, portalplace.method_10260());
            this.GateSpawnBlock = this.method_37908().method_8320(this.teleportGateSpawn).method_26204();
            if (this.method_37908().method_8320(this.teleportGateSpawn).method_26204() == class_2246.field_10219) {
                // empty if block
            }
            class_2680 lastBlock = this.GateSpawnBlock.method_9564();
            class_3218 UD = this.method_37908().method_8503().method_3847(UpsideDown.UPSIDE_DOWN_DIMENSION_KEY);
            class_3218 OV = this.method_37908().method_8503().method_3847(class_1937.field_25179);
            FloorGateBlock.gateSpawn(this.teleportGateSpawn, UD);
            FloorGateBlock.gateSpawn(this.teleportGateSpawn, OV);
            boolean bl3 = this.method_6082(x, y, z, true);
            if (bl3) {
                this.method_37908().method_32888(class_5712.field_39446, vec3d, class_5712.class_7397.method_43285((class_1297)this));
                if (!((Boolean)this.field_6011.method_12789(AMBUSH_SEQUENCE)).booleanValue()) {
                    this.portaloutAnimationTimeout = 0;
                    this.setCrawlingOut(true);
                }
                if (!this.method_5701()) {
                    this.method_37908().method_43128((class_1657)null, this.field_6014, this.field_6036, this.field_5969, class_3417.field_14879, this.method_5634(), 1.0f, 1.0f);
                    this.method_5783(class_3417.field_14879, 1.0f, 1.0f);
                }
            }
            return bl3;
        }
        return false;
    }

    private void ReplaceGate(class_2338 gatePos) {
        if (gatePos == null) {
            return;
        }
        if (this.method_37908().method_8320(gatePos).method_27852(UDMBlocks.FLOOR_GATE)) {
            class_2680 priBlock = null;
            class_2586 class_25862 = this.method_37908().method_8321(gatePos);
            if (class_25862 instanceof FloorGateBlockEntity) {
                FloorGateBlockEntity floorGate = (FloorGateBlockEntity)class_25862;
                priBlock = floorGate.getPriorBlock();
            }
            if (priBlock != null) {
                this.method_37908().method_8501(gatePos, priBlock);
            }
        }
    }

    protected class_3414 method_5994() {
        return UDMSounds.DEMOGORGON_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return UDMSounds.DEMOGORGON_HURT;
    }

    protected class_3414 method_6002() {
        return UDMSounds.DEMOGORGON_DEATH;
    }

    protected void method_6099(class_1282 source, int lootingMultiplier, boolean allowDrops) {
        super.method_6099(source, lootingMultiplier, allowDrops);
        class_2680 blockState = this.getCarriedBlock();
        if (blockState != null) {
            class_1799 itemStack = new class_1799((class_1935)class_1802.field_8556);
            itemStack.method_7978(class_1893.field_9099, 1);
            class_8567.class_8568 builder = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1229, (Object)itemStack).method_51877(class_181.field_1226, (Object)this);
            for (class_1799 itemStack2 : blockState.method_26189(builder)) {
                this.method_5775(itemStack2);
            }
        }
    }

    public void setCarriedBlock(@Nullable class_2680 state) {
        this.field_6011.method_12778(CARRIED_BLOCK, Optional.ofNullable(state));
    }

    @Nullable
    public class_2680 getCarriedBlock() {
        return ((Optional)this.field_6011.method_12789(CARRIED_BLOCK)).orElse(null);
    }

    private boolean damageFromPotion(class_1282 source, class_1686 potion, float amount) {
        class_1799 itemStack = potion.method_7495();
        class_1842 potion2 = class_1844.method_8063((class_1799)itemStack);
        List list = class_1844.method_8067((class_1799)itemStack);
        boolean bl = potion2 == class_1847.field_8991 && list.isEmpty();
        return bl ? super.method_5643(source, amount) : false;
    }

    public boolean isAngry() {
        return (Boolean)this.field_6011.method_12789(ANGRY);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            this.setupAnimationStates();
        }
    }

    public boolean isProvoked() {
        return (Boolean)this.field_6011.method_12789(PROVOKED);
    }

    public void setProvoked() {
        this.field_6011.method_12778(PROVOKED, (Object)true);
    }

    public boolean method_17326() {
        return super.method_17326() || this.getCarriedBlock() != null;
    }

    static {
        ALL_MOBS_EXCEPT_DEMOGORGON = entity -> entity != null && !(entity instanceof DemogorgonEntity) && entity.method_5805();
        CRAWLING_IN = class_2945.method_12791(DemogorgonEntity.class, (class_2941)class_2943.field_13323);
        CRAWLING_OUT = class_2945.method_12791(DemogorgonEntity.class, (class_2941)class_2943.field_13323);
        AMBUSH_SEQUENCE = class_2945.method_12791(DemogorgonEntity.class, (class_2941)class_2943.field_13323);
        AMBUSH_COUNTER = class_2945.method_12791(DemogorgonEntity.class, (class_2941)class_2943.field_13327);
        ATTACK_SEQUENCE_TICKS = class_2945.method_12791(DemogorgonEntity.class, (class_2941)class_2943.field_13327);
        RUN_ATTACK_ACTIVE = class_2945.method_12791(DemogorgonEntity.class, (class_2941)class_2943.field_13323);
        KIDNAP_COOLDOWN = class_2945.method_12791(DemogorgonEntity.class, (class_2941)class_2943.field_13327);
        ATTACKING_SPEED_BOOST = new class_1322(ATTACKING_SPEED_BOOST_ID, "Attacking speed boost", (double)0.15f, class_1322.class_1323.field_6328);
        CARRIED_BLOCK = class_2945.method_12791(DemogorgonEntity.class, (class_2941)class_2943.field_42236);
        ANGRY = class_2945.method_12791(DemogorgonEntity.class, (class_2941)class_2943.field_13323);
        PROVOKED = class_2945.method_12791(DemogorgonEntity.class, (class_2941)class_2943.field_13323);
        ANGER_TIME_RANGE = class_4802.method_24505((int)20, (int)39);
    }

    static class DemogorgonEscapeDangerGoal
    extends class_1352 {
        public static final int RANGE_Y = 1;
        protected final class_1314 mob;
        protected final double speed;
        protected double targetX;
        protected double targetY;
        protected double targetZ;
        protected boolean active;

        public DemogorgonEscapeDangerGoal(class_1314 mob, double speed) {
            this.mob = mob;
            this.speed = speed;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return this.mob.method_5809();
        }

        public void method_6269() {
            this.mob.method_5942().method_6337(this.targetX, this.targetY, this.targetZ, this.speed);
            this.active = true;
        }

        public void method_6270() {
            this.active = false;
        }

        public boolean method_6266() {
            return !this.mob.method_5942().method_6357();
        }
    }

    public class MeleeAttackGoal
    extends class_1352 {
        protected final class_1314 mob;
        private final double speed;
        private final boolean pauseWhenMobIdle;
        private class_11 path;
        private double targetX;
        private double targetY;
        private double targetZ;
        private int updateCountdownTicks;
        private int cooldown;
        private final int attackIntervalTicks = 20;
        private long lastUpdateTime;
        private static final long MAX_ATTACK_TIME = 20L;

        public MeleeAttackGoal(class_1314 mob, double speed, boolean pauseWhenMobIdle) {
            this.mob = mob;
            this.speed = speed;
            this.pauseWhenMobIdle = pauseWhenMobIdle;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            long l = this.mob.method_37908().method_8510();
            if (l - this.lastUpdateTime < 20L) {
                return false;
            }
            this.lastUpdateTime = l;
            class_1309 livingEntity = this.mob.method_5968();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.method_5805()) {
                return false;
            }
            this.path = this.mob.method_5942().method_6349((class_1297)livingEntity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getSquaredMaxAttackDistance(livingEntity) >= this.mob.method_5649(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321());
        }

        public boolean method_6266() {
            class_1309 livingEntity = this.mob.method_5968();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.method_5805()) {
                return false;
            }
            if (!this.pauseWhenMobIdle) {
                return !this.mob.method_5942().method_6357();
            }
            if (!this.mob.method_18407(livingEntity.method_24515())) {
                return false;
            }
            return !(livingEntity instanceof class_1657) || !livingEntity.method_7325() && !((class_1657)livingEntity).method_7337();
        }

        public void method_6269() {
            this.mob.method_5942().method_6334(this.path, this.speed);
            this.mob.method_19540(true);
            this.updateCountdownTicks = 0;
            this.cooldown = 0;
        }

        public void method_6270() {
            class_1309 livingEntity = this.mob.method_5968();
            if (!class_1301.field_6156.test(livingEntity)) {
                this.mob.method_5980((class_1309)null);
            }
            this.mob.method_19540(false);
            this.mob.method_5942().method_6340();
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            class_1309 livingEntity = this.mob.method_5968();
            if (livingEntity != null) {
                this.mob.method_5988().method_6226((class_1297)livingEntity, 30.0f, 30.0f);
                double d = this.mob.method_47922(livingEntity);
                this.updateCountdownTicks = Math.max(this.updateCountdownTicks - 1, 0);
                if ((this.pauseWhenMobIdle || this.mob.method_5985().method_6369((class_1297)livingEntity)) && this.updateCountdownTicks <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || livingEntity.method_5649(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.mob.method_6051().method_43057() < 0.05f)) {
                    this.targetX = livingEntity.method_23317();
                    this.targetY = livingEntity.method_23318();
                    this.targetZ = livingEntity.method_23321();
                    this.updateCountdownTicks = 4 + this.mob.method_6051().method_43048(7);
                    if (d > 1024.0) {
                        this.updateCountdownTicks += 10;
                    } else if (d > 256.0) {
                        this.updateCountdownTicks += 5;
                    }
                    if (!this.mob.method_5942().method_6335((class_1297)livingEntity, this.speed)) {
                        this.updateCountdownTicks += 15;
                    }
                    this.updateCountdownTicks = this.method_38847(this.updateCountdownTicks);
                }
                this.cooldown = Math.max(this.cooldown - 1, 0);
                this.attack(livingEntity, d);
            }
        }

        protected void attack(class_1309 target, double squaredDistance) {
            double d = this.getSquaredMaxAttackDistance(target);
            if (squaredDistance <= d && this.cooldown <= 0 && DemogorgonEntity.this.getAttackSequenceTicks() <= 0) {
                this.resetCooldown();
                class_1937 world = this.mob.method_37908();
                boolean isRunning = !this.mob.method_5942().method_6357() || this.mob.method_18798().method_37268() > 0.05;
                class_2945 tracker = this.mob.method_5841();
                if (world == world.method_8503().method_3847(class_1937.field_25179) && (Integer)tracker.method_12789(KIDNAP_COOLDOWN) >= 1000) {
                    tracker.method_12778(KIDNAP_COOLDOWN, (Object)0);
                    if (target instanceof class_1657) {
                        this.mob.method_31472();
                        BleedingKidnapGoal.teleportPlayer((class_3222)target, (class_3218)world);
                    } else {
                        this.triggerSequence(isRunning);
                    }
                } else {
                    this.triggerSequence(isRunning);
                }
            }
        }

        private void triggerSequence(boolean isRunning) {
            if (isRunning) {
                DemogorgonEntity.this.setRunAttacking(true);
                DemogorgonEntity.this.setAttackSequenceTicks(46);
            } else {
                DemogorgonEntity.this.setRunAttacking(false);
                DemogorgonEntity.this.setAttackSequenceTicks(47);
            }
            this.mob.method_19540(true);
        }

        protected void resetCooldown() {
            this.cooldown = this.method_38847(20);
        }

        protected boolean isCooledDown() {
            return this.cooldown <= 0;
        }

        protected int getCooldown() {
            return this.cooldown;
        }

        protected int getMaxCooldown() {
            return this.method_38847(20);
        }

        protected double getSquaredMaxAttackDistance(class_1309 entity) {
            return this.mob.method_17681() * 2.0f * this.mob.method_17681() * 2.0f + entity.method_17681();
        }
    }

    static class DemogorgonTeleportTowardsPlayerGoal
    extends class_1400<class_1657> {
        private final DemogorgonEntity demogorgon;
        @Nullable
        private class_1657 targetPlayer;
        private int lookAtPlayerWarmup;
        private int ticksSinceUnseenTeleport;
        private final class_4051 staringPlayerPredicate;
        private final class_4051 validTargetPredicate = class_4051.method_36625().method_36627();
        private final Predicate<class_1309> angerPredicate;
        public int crawlInCountdown = 0;

        public DemogorgonTeleportTowardsPlayerGoal(DemogorgonEntity demogorgon, @Nullable Predicate<class_1309> targetPredicate) {
            super((class_1308)demogorgon, class_1657.class, 10, false, false, targetPredicate);
            this.demogorgon = demogorgon;
            this.angerPredicate = playerEntity -> (demogorgon.isPlayerStaring((class_1657)playerEntity) || demogorgon.method_29515((class_1309)playerEntity)) && !demogorgon.method_5821((class_1297)playerEntity);
            this.staringPlayerPredicate = class_4051.method_36625().method_18418(this.method_6326()).method_18420(this.angerPredicate);
        }

        public boolean method_6264() {
            this.targetPlayer = this.demogorgon.method_37908().method_18462(this.staringPlayerPredicate, (class_1309)this.demogorgon);
            return this.targetPlayer != null;
        }

        public void method_6269() {
            this.lookAtPlayerWarmup = this.method_38847(5);
            this.ticksSinceUnseenTeleport = 0;
            this.demogorgon.setProvoked();
            this.crawlInCountdown = 0;
        }

        public void method_6270() {
            this.targetPlayer = null;
            this.crawlInCountdown = 0;
            super.method_6270();
        }

        public boolean method_6266() {
            if (this.targetPlayer != null) {
                if (!this.angerPredicate.test((class_1309)this.targetPlayer)) {
                    return false;
                }
                this.demogorgon.method_5951((class_1297)this.targetPlayer, 10.0f, 10.0f);
                return true;
            }
            if (this.field_6644 != null) {
                if (this.demogorgon.method_5821((class_1297)this.field_6644)) {
                    return false;
                }
                if (this.validTargetPredicate.method_18419((class_1309)this.demogorgon, this.field_6644)) {
                    return true;
                }
            }
            return super.method_6266();
        }

        public void method_6268() {
            if (this.demogorgon.method_5968() == null) {
                super.method_24632((class_1309)null);
            }
            this.demogorgon.portalinAnimationTimeout = 0;
            this.demogorgon.setCrawlingIn(false);
            if (this.targetPlayer != null) {
                if (--this.lookAtPlayerWarmup <= 0) {
                    this.field_6644 = this.targetPlayer;
                    this.targetPlayer = null;
                    super.method_6269();
                }
            } else {
                if (this.field_6644 != null && !this.demogorgon.method_5765()) {
                    if (this.demogorgon.isPlayerStaring((class_1657)this.field_6644)) {
                        if (this.field_6644.method_5858((class_1297)this.demogorgon) < 16.0) {
                            this.demogorgon.teleportRandomly();
                        }
                        this.ticksSinceUnseenTeleport = 0;
                    } else if (this.field_6644.method_5858((class_1297)this.demogorgon) > 256.0 && this.ticksSinceUnseenTeleport++ >= this.method_38847(30) && this.demogorgon.teleportTo((class_1297)this.field_6644)) {
                        this.ticksSinceUnseenTeleport = 0;
                    }
                }
                super.method_6268();
            }
        }
    }

    static class PickUpBlockGoal
    extends class_1352 {
        private final DemogorgonEntity enderman;

        public PickUpBlockGoal(DemogorgonEntity enderman) {
            this.enderman = enderman;
        }

        public boolean method_6264() {
            if (this.enderman.getCarriedBlock() != null) {
                return false;
            }
            if (!this.enderman.method_37908().method_8450().method_8355(class_1928.field_19388)) {
                return false;
            }
            return this.enderman.method_6051().method_43048(PickUpBlockGoal.method_38848((int)20)) == 0;
        }

        public void method_6268() {
            class_5819 random = this.enderman.method_6051();
            class_1937 world = this.enderman.method_37908();
            int i = class_3532.method_15357((double)(this.enderman.method_23317() - 2.0 + random.method_43058() * 4.0));
            int j = class_3532.method_15357((double)(this.enderman.method_23318() + random.method_43058() * 3.0));
            int k = class_3532.method_15357((double)(this.enderman.method_23321() - 2.0 + random.method_43058() * 4.0));
            class_2338 blockPos = new class_2338(i, j, k);
            class_2680 blockState = world.method_8320(blockPos);
            class_243 vec3d = new class_243((double)this.enderman.method_31477() + 0.5, (double)j + 0.5, (double)this.enderman.method_31479() + 0.5);
            class_243 vec3d2 = new class_243((double)i + 0.5, (double)j + 0.5, (double)k + 0.5);
            class_3965 blockHitResult = world.method_17742(new class_3959(vec3d, vec3d2, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)this.enderman));
            boolean bl = blockHitResult.method_17777().equals((Object)blockPos);
            if (blockState.method_26164(class_3481.field_15460) && bl) {
                world.method_8650(blockPos, false);
                world.method_43276(class_5712.field_28165, blockPos, class_5712.class_7397.method_43286((class_1297)this.enderman, (class_2680)blockState));
                this.enderman.setCarriedBlock(blockState.method_26204().method_9564());
            }
        }
    }

    static class PlaceBlockGoal
    extends class_1352 {
        private final DemogorgonEntity enderman;

        public PlaceBlockGoal(DemogorgonEntity enderman) {
            this.enderman = enderman;
        }

        public boolean method_6264() {
            if (this.enderman.getCarriedBlock() == null) {
                return false;
            }
            if (!this.enderman.method_37908().method_8450().method_8355(class_1928.field_19388)) {
                return false;
            }
            return this.enderman.method_6051().method_43048(PlaceBlockGoal.method_38848((int)2000)) == 0;
        }

        public void method_6268() {
            class_5819 random = this.enderman.method_6051();
            class_1937 world = this.enderman.method_37908();
            int i = class_3532.method_15357((double)(this.enderman.method_23317() - 1.0 + random.method_43058() * 2.0));
            int j = class_3532.method_15357((double)(this.enderman.method_23318() + random.method_43058() * 2.0));
            int k = class_3532.method_15357((double)(this.enderman.method_23321() - 1.0 + random.method_43058() * 2.0));
            class_2338 blockPos = new class_2338(i, j, k);
            class_2680 blockState = world.method_8320(blockPos);
            class_2338 blockPos2 = blockPos.method_10074();
            class_2680 blockState2 = world.method_8320(blockPos2);
            class_2680 blockState3 = this.enderman.getCarriedBlock();
            if (blockState3 != null && this.canPlaceOn(world, blockPos, blockState3 = class_2248.method_9510((class_2680)blockState3, (class_1936)this.enderman.method_37908(), (class_2338)blockPos), blockState, blockState2, blockPos2)) {
                world.method_8652(blockPos, blockState3, 3);
                world.method_43276(class_5712.field_28164, blockPos, class_5712.class_7397.method_43286((class_1297)this.enderman, (class_2680)blockState3));
                this.enderman.setCarriedBlock(null);
            }
        }

        private boolean canPlaceOn(class_1937 world, class_2338 posAbove, class_2680 carriedState, class_2680 stateAbove, class_2680 state, class_2338 pos) {
            return stateAbove.method_26215() && !state.method_26215() && !state.method_27852(class_2246.field_9987) && state.method_26234((class_1922)world, pos) && carriedState.method_26184((class_4538)world, posAbove) && world.method_8335((class_1297)this.enderman, class_238.method_29968((class_243)class_243.method_24954((class_2382)posAbove))).isEmpty();
        }
    }

    static class ChasePlayerGoal
    extends class_1352 {
        private final DemogorgonEntity enderman;
        @Nullable
        private class_1309 target;

        public ChasePlayerGoal(DemogorgonEntity enderman) {
            this.enderman = enderman;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18407, class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            this.target = this.enderman.method_5968();
            if (!(this.target instanceof class_1657)) {
                return false;
            }
            double d = this.target.method_5858((class_1297)this.enderman);
            return d > 256.0 ? false : this.enderman.isPlayerStaring((class_1657)this.target);
        }

        public void method_6269() {
            this.enderman.method_5942().method_6340();
        }

        public void method_6268() {
            this.enderman.method_5988().method_20248(this.target.method_23317(), this.target.method_23320(), this.target.method_23321());
        }
    }

    public static class DemogorgonTeleportPacket {
        private final int entityId;

        public DemogorgonTeleportPacket(int entityId) {
            this.entityId = entityId;
        }

        public void encode(DemogorgonTeleportPacket packet, class_2540 buf) {
            buf.writeInt(packet.entityId);
        }

        public static DemogorgonTeleportPacket decode(class_2540 buf) {
            return new DemogorgonTeleportPacket(buf.readInt());
        }

        public static void handle(DemogorgonTeleportPacket packet, class_3222 player) {
            player.method_5682().execute(() -> {
                class_1297 entity = player.method_37908().method_8469(packet.entityId);
                if (entity instanceof DemogorgonEntity) {
                    ((DemogorgonEntity)entity).teleportBehindPlayer((class_1657)player);
                }
            });
        }
    }
}

