/*
 * Decompiled with CFR 0.152.
 */
package prim.upsidedown.entity.ai.goal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import prim.upsidedown.blocks.FloorGateBlock;
import prim.upsidedown.core.UDMBlocks;
import prim.upsidedown.core.UDMEffects;
import prim.upsidedown.core.UDMEntities;
import prim.upsidedown.core.UDMSounds;
import prim.upsidedown.dimension.UpsideDown;
import prim.upsidedown.dimension.UpsideDownInitializer;
import prim.upsidedown.entity.DemogorgonEntity;

public class BleedingKidnapGoal {
    private final class_3218 serverWorld;
    private final Map<class_3222, DemogorgonEntity> demogorgons = new HashMap<class_3222, DemogorgonEntity>();
    public class_2248 GateSpawnBlock;
    private static final Map<class_2338, Integer> gateDelays = new HashMap<class_2338, Integer>();

    public BleedingKidnapGoal(class_3218 serverWorld) {
        this.serverWorld = serverWorld;
    }

    public void tick() {
        List players = this.serverWorld.method_18766(player -> player.method_6059(UDMEffects.BLEEDING));
        for (class_3222 player2 : players) {
            class_1293 bleedingEffect = player2.method_6112(UDMEffects.BLEEDING);
            if (bleedingEffect == null) continue;
            int duration = bleedingEffect.method_5584();
            if (duration <= 460 && duration > 340 && duration % 2 == 0) {
                BleedingKidnapGoal.toggleRedstoneLamps(this.serverWorld, player2.method_24515(), true, 10);
            }
            if (duration == 340) {
                this.freezePlayer(player2);
                this.playCustomSound(this.serverWorld, player2.method_24515(), UDMSounds.DEMOGORGON_PREPARE);
            }
            if (duration != 201) continue;
            BleedingKidnapGoal.afterTeleportEvent(player2, this.serverWorld);
        }
        this.demogorgons.keySet().removeIf(player -> !players.contains(player));
    }

    public static void toggleRedstoneLamps(class_3218 world, class_2338 playerPos, boolean blink, int radius) {
        class_2338.method_20437((class_2338)playerPos.method_10069(-radius, -radius, -radius), (class_2338)playerPos.method_10069(radius, radius, radius)).forEach(pos -> {
            if (world.method_8320(pos).method_27852(class_2246.field_10524)) {
                boolean powered = (Boolean)world.method_8320(pos).method_11654((class_2769)class_2741.field_12548);
                world.method_8501(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(blink ? !powered : false)));
            }
        });
    }

    private void spawnDemogorgon(class_3218 world, class_3222 player) {
        class_243 spawnVec = player.method_19538().method_1019(player.method_5720().method_1021(-3.0));
        class_2338 spawnPos = new class_2338((int)spawnVec.field_1352, (int)spawnVec.field_1351, (int)spawnVec.field_1350);
        DemogorgonEntity demogorgon = (DemogorgonEntity)UDMEntities.DEMOGORGON.method_5883((class_1937)world);
        if (demogorgon != null) {
            demogorgon.method_5977(true);
            demogorgon.method_5808((double)spawnPos.method_10263() + 0.5, spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, player.method_36454(), 0.0f);
            world.method_8649((class_1297)demogorgon);
            this.demogorgons.put(player, demogorgon);
        }
    }

    private void forcePlayerLookAtDemogorgon(class_3222 player) {
        DemogorgonEntity demogorgon = this.demogorgons.get(player);
        if (demogorgon == null) {
            return;
        }
        class_243 demogorgonPos = demogorgon.method_19538();
        class_243 lookDirection = demogorgonPos.method_1020(player.method_19538()).method_1029();
        double pitch = -Math.toDegrees(Math.asin(lookDirection.field_1351));
        double yaw = Math.toDegrees(Math.atan2(lookDirection.field_1350, lookDirection.field_1352)) - 90.0;
        player.method_36456((float)yaw);
        player.method_36457((float)pitch);
        player.field_13987.method_14372();
        System.out.println("Forced player to look at Demogorgon: " + player.method_5477().getString());
    }

    private void freezePlayer(class_3222 player) {
        player.method_6092(new class_1293(class_1294.field_5909, 180, 255, false, false, true));
        player.method_6092(new class_1293(class_1294.field_5919, 180, 0, false, false, true));
    }

    public static void teleportPlayer(class_3222 player, class_3218 currentWorld) {
        if (!player.method_37908().method_27983().equals(class_3218.field_25179)) {
            return;
        }
        class_3218 upsideDownWorld = currentWorld.method_8503().method_3847(UpsideDown.UPSIDE_DOWN_DIMENSION_KEY);
        if (upsideDownWorld != null) {
            class_3218 targetWorld = currentWorld.method_27983().equals(UpsideDown.UPSIDE_DOWN_DIMENSION_KEY) ? currentWorld.method_8503().method_3847(class_1937.field_25179) : upsideDownWorld;
            if (currentWorld.method_27983().equals(class_1937.field_25179)) {
                UpsideDownInitializer.initialize(targetWorld, upsideDownWorld, player, false);
            }
            class_2338 targetPos = class_2338.method_49638((class_2374)player.method_19538());
            player.method_14251(targetWorld, (double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264(), (double)targetPos.method_10260() + 0.5, player.method_36454(), player.method_36455());
            BleedingKidnapGoal.afterTeleportEvent(player, upsideDownWorld);
        } else {
            System.err.println("Upside Down world not found!");
        }
    }

    private static List<DemogorgonEntity> findDemogorgonsInRadius(class_3218 world, class_2338 center, int radius) {
        ArrayList<DemogorgonEntity> demogorgons = new ArrayList<DemogorgonEntity>();
        int startX = center.method_10263() - radius;
        int startY = Math.max(world.method_31607(), center.method_10264() - radius);
        int startZ = center.method_10260() - radius;
        int endX = center.method_10263() + radius;
        int endY = Math.min(world.method_31600(), center.method_10264() + radius);
        int endZ = center.method_10260() + radius;
        for (DemogorgonEntity demogorgon : world.method_8390(DemogorgonEntity.class, new class_238((double)startX, (double)startY, (double)startZ, (double)endX, (double)endY, (double)endZ), entity -> true)) {
            demogorgons.add(demogorgon);
            System.out.println("Found Demogorgon at: " + demogorgon.method_24515());
        }
        System.out.println("Total Demogorgons found: " + demogorgons.size());
        return demogorgons;
    }

    private static void afterTeleportEvent(class_3222 player, class_3218 upsideDownWorld) {
        class_2338 groundPos = BleedingKidnapGoal.findRandomGroundPosition(upsideDownWorld, player.method_24515());
        if (groundPos != null) {
            class_3218 UD = upsideDownWorld.method_8503().method_3847(UpsideDown.UPSIDE_DOWN_DIMENSION_KEY);
            class_3218 OV = upsideDownWorld.method_8503().method_3847(class_1937.field_25179);
            FloorGateBlock.gateSpawn(groundPos, UD);
            FloorGateBlock.gateSpawn(groundPos, OV);
            BleedingKidnapGoal.spawnDemogorgonFromGate(upsideDownWorld, groundPos, player);
            System.out.println("Spawning Demogorgon from gate at: " + groundPos);
        }
        ArrayList<class_2338> toRemove = new ArrayList<class_2338>();
        for (Map.Entry<class_2338, Integer> entry : gateDelays.entrySet()) {
            class_2338 pos = entry.getKey();
            int ticksLeft = entry.getValue();
            System.out.println("Processing gate delay at: " + pos + " with " + ticksLeft + " ticks remaining.");
            if (ticksLeft <= 0) {
                class_2338 playerPos = player.method_24515();
                List<DemogorgonEntity> nearbyDemogorgons = BleedingKidnapGoal.findDemogorgonsInRadius(upsideDownWorld, playerPos, 50);
                if (!nearbyDemogorgons.isEmpty()) {
                    System.out.println("There is already a Demogorgon nearby. No new ones will be spawned.");
                    continue;
                }
                BleedingKidnapGoal.spawnDemogorgonFromGate(upsideDownWorld, pos, player);
                System.out.println("Spawning Demogorgon from gate at: " + pos);
                toRemove.add(pos);
                continue;
            }
            gateDelays.put(pos, ticksLeft - 1);
            System.out.println("Decremented gate delay at: " + pos + " to " + (ticksLeft - 1) + " ticks.");
            break;
        }
        for (class_2338 pos : toRemove) {
            gateDelays.remove(pos);
            System.out.println("Removed gate delay at: " + pos);
        }
    }

    private class_2338 findFloorGateInRadius(class_3218 world, class_2338 center, int radius) {
        int startX = center.method_10263() - radius;
        int startY = Math.max(world.method_31607(), center.method_10264() - radius);
        int startZ = center.method_10260() - radius;
        int endX = center.method_10263() + radius;
        int endY = Math.min(world.method_31600(), center.method_10264() + radius);
        int endZ = center.method_10260() + radius;
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    if (!world.method_8320(pos).method_27852(UDMBlocks.FLOOR_GATE)) continue;
                    System.out.println("Found Floor Gate at: " + pos);
                    return pos;
                }
            }
        }
        System.out.println("No Floor Gate found within " + radius + " blocks of: " + center);
        return null;
    }

    private void playCustomSound(class_3218 world, class_2338 pos, class_3414 soundEvent) {
        world.method_8396(null, pos, soundEvent, class_3419.field_15251, 1.5f, 1.0f);
    }

    private static class_2338 findRandomGroundPosition(class_3218 world, class_2338 center) {
        int range = 20;
        for (int i = 0; i < 10; ++i) {
            int x = center.method_10263() + world.method_8409().method_43048(range) - range / 2;
            int z = center.method_10260() + world.method_8409().method_43048(range) - range / 2;
            int y = world.method_31600() - 1;
            class_2338 pos = new class_2338(x, y, z);
            while (y > world.method_31607() && !world.method_8320(pos).method_26225()) {
                pos = new class_2338(x, --y, z);
            }
            if (!world.method_8320(pos).method_26225()) continue;
            return pos;
        }
        return null;
    }

    private static void spawnDemogorgonFromGate(class_3218 world, class_2338 gatePos, class_3222 player) {
        world.method_8396(null, gatePos, UDMSounds.DEMOGORGON_ROAR, class_3419.field_15251, 1.5f, 1.0f);
        world.method_8406((class_2394)class_2398.field_11214, (double)gatePos.method_10263() + 0.5, (double)(gatePos.method_10264() + 1), (double)gatePos.method_10260() + 0.5, 0.0, 0.1, 0.0);
        DemogorgonEntity demogorgon = (DemogorgonEntity)UDMEntities.DEMOGORGON.method_5883((class_1937)world);
        if (demogorgon != null) {
            demogorgon.method_5808((double)gatePos.method_10263() + 0.5, gatePos.method_10264() + 1, (double)gatePos.method_10260() + 0.5, player.method_36454(), 0.0f);
            demogorgon.method_5977(false);
            world.method_8649((class_1297)demogorgon);
            System.out.println("Demogorgon spawned from Gate at: " + gatePos);
        }
    }
}

