/*
 * Decompiled with CFR 0.152.
 */
package prim.upsidedown.powers;

import java.util.HashMap;
import java.util.UUID;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import prim.upsidedown.powers.TelekinesisMode;

public class TelekinesisHandler {
    private static final HashMap<UUID, class_1297> activeEntityTargets = new HashMap();
    private static final HashMap<UUID, TelekinesisMode> playerModes = new HashMap();
    private static final HashMap<UUID, Long> forceWaveCooldowns = new HashMap();
    private static final HashMap<UUID, Long> throwCooldowns = new HashMap();
    private static final HashMap<UUID, Long> grabCooldowns = new HashMap();
    private static final long FORCE_WAVE_COOLDOWN_MILLIS = 25000L;
    private static final long THROW_COOLDOWN_MILLIS = 5000L;
    private static final long GRAB_COOLDOWN_MILLIS = 5000L;
    private static final long BLOCK_COLLISION_COOLDOWN_MILLIS = 1000L;
    private static final double FORCE_WAVE_RADIUS = 10.0;
    private static final double FORCE_WAVE_STRENGTH = 2.0;
    private static final double THROW_STRENGTH = 2.5;
    public static final double ENTITY_GRAB_RANGE = 10.0;
    public static final class_2960 GRAB_ENTITY_PACKET = new class_2960("prims-upsidedown", "grab_entity");
    public static final class_2960 MOVE_ENTITY_PACKET = new class_2960("prims-upsidedown", "move_entity");
    public static final class_2960 TOGGLE_MODE_PACKET = new class_2960("prims-upsidedown", "toggle_mode");

    public static void assignEntityToPlayer(UUID playerId, class_1297 entity) {
        activeEntityTargets.put(playerId, entity);
    }

    public static void removeEntityFromPlayer(UUID playerId) {
        activeEntityTargets.remove(playerId);
    }

    public static TelekinesisMode getMode(class_1657 player) {
        return playerModes.getOrDefault(player.method_5667(), TelekinesisMode.NONE);
    }

    public static void registerAttackHandler() {
        AttackEntityCallback.EVENT.register((player, world, hand, target, hitResult) -> {
            UUID playerId = player.method_5667();
            if (activeEntityTargets.containsKey(playerId)) {
                class_1297 heldEntity = activeEntityTargets.get(playerId);
                class_243 throwDirection = player.method_5828(1.0f).method_1029().method_1021(2.5);
                heldEntity.method_18799(throwDirection);
                heldEntity.field_6037 = true;
                activeEntityTargets.remove(playerId);
                grabCooldowns.put(playerId, System.currentTimeMillis());
                player.method_7353((class_2561)class_2561.method_43470((String)"Entity thrown! Grabbing disabled for 5 seconds."), true);
                System.out.println("Player " + player.method_5477().getString() + " threw entity " + heldEntity.method_5477().getString());
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
    }

    public static void toggleMode(class_1657 player) {
        UUID playerId = player.method_5667();
        TelekinesisMode currentMode = playerModes.getOrDefault(playerId, TelekinesisMode.NONE);
        TelekinesisMode newMode = switch (currentMode) {
            case TelekinesisMode.NONE -> TelekinesisMode.ENTITIES;
            case TelekinesisMode.ENTITIES -> TelekinesisMode.NONE;
            default -> TelekinesisMode.NONE;
        };
        playerModes.put(playerId, newMode);
        player.method_7353((class_2561)class_2561.method_43470((String)("Telekinesis mode set to: " + newMode)), true);
        System.out.println("Telekinesis mode changed to: " + newMode);
    }

    public static void handleLiftOrToggle(class_1657 player, class_3218 world) {
        UUID playerId = player.method_5667();
        if (TelekinesisHandler.isOnCooldown(grabCooldowns, playerId, 5000L)) {
            player.method_7353((class_2561)class_2561.method_43470((String)"You cannot grab entities yet! Cooldown in effect."), true);
            return;
        }
        TelekinesisMode currentMode = playerModes.getOrDefault(playerId, TelekinesisMode.NONE);
        if (!player.method_5715()) {
            TelekinesisHandler.resetPlayerTargets(playerId);
            return;
        }
        if (currentMode == TelekinesisMode.ENTITIES) {
            if (activeEntityTargets.containsKey(playerId)) {
                class_1297 entity = activeEntityTargets.get(playerId);
                if (entity != null && entity.method_5805()) {
                    TelekinesisHandler.moveControlledEntity(player, entity, world);
                } else {
                    System.out.println("Server: No active target or target is invalid.");
                    TelekinesisHandler.resetPlayerTargets(playerId);
                }
            } else {
                class_1297 entity = TelekinesisHandler.getEntityPlayerIsLookingAt(player, (class_1937)world, 10.0);
                if (entity != null) {
                    TelekinesisHandler.handleEntityLift(entity, player);
                    System.out.println("Server: Entity " + entity.method_5477().getString() + " successfully grabbed.");
                } else {
                    System.out.println("Server: No entity found to grab.");
                }
            }
        }
    }

    private static void handleEntityLift(class_1297 entity, class_1657 player) {
        UUID playerId = player.method_5667();
        activeEntityTargets.put(playerId, entity);
        entity.method_18800(0.0, 0.0, 0.0);
        System.out.println("Player " + player.method_5477().getString() + " is now controlling " + entity.method_5477().getString());
    }

    private static void resetPlayerTargets(UUID playerId) {
        activeEntityTargets.remove(playerId);
    }

    public static void moveControlledEntity(class_1657 player, class_1297 entity, class_3218 world) {
        class_243 targetPosition = player.method_33571().method_1019(player.method_5828(1.0f).method_1021(5.0));
        class_2338 targetBlockPos = new class_2338(class_3532.method_15357((double)targetPosition.field_1352), class_3532.method_15357((double)targetPosition.field_1351), class_3532.method_15357((double)targetPosition.field_1350));
        class_2680 blockState = world.method_8320(targetBlockPos);
        if (!blockState.method_26215()) {
            UUID playerId = player.method_5667();
            activeEntityTargets.remove(playerId);
            player.method_7353((class_2561)class_2561.method_43470((String)"Entity dropped due to block collision! Powers disabled for 1 second."), true);
            return;
        }
        entity.method_20620(targetPosition.field_1352, targetPosition.field_1351, targetPosition.field_1350);
        entity.method_18800(0.0, 0.0, 0.0);
        entity.field_6037 = true;
        System.out.println("Server: Moving entity to " + targetPosition);
    }

    public static double getEntityGrabRange() {
        return 10.0;
    }

    public static class_1297 getEntityPlayerIsLookingAt(class_1657 player, class_1937 world, double range) {
        if (!(world instanceof class_3218)) {
            return null;
        }
        class_243 start = player.method_33571();
        class_243 direction = player.method_5828(1.0f);
        class_243 end = start.method_1019(direction.method_1021(range));
        class_238 box = new class_238(start, end).method_1014(1.0);
        class_1297 closestEntity = null;
        double closestDistanceSquared = range * range;
        for (class_1297 entity : world.method_8335((class_1297)player, box)) {
            double distanceSquared;
            if (!entity.method_5805() || entity.method_31481() || !((distanceSquared = start.method_1025(entity.method_5829().method_1005())) < closestDistanceSquared)) continue;
            closestEntity = entity;
            closestDistanceSquared = distanceSquared;
        }
        return closestEntity;
    }

    public static void useForceWave(class_1657 player, class_3218 world) {
        UUID playerId = player.method_5667();
        if (TelekinesisHandler.isOnCooldown(forceWaveCooldowns, playerId, 25000L)) {
            long remainingTime = (25000L - (System.currentTimeMillis() - forceWaveCooldowns.get(playerId))) / 1000L;
            player.method_7353((class_2561)class_2561.method_43470((String)("Force Wave is on cooldown! Remaining: " + remainingTime + " seconds.")), true);
            return;
        }
        class_243 playerPos = player.method_19538();
        class_238 knockbackBox = new class_238(playerPos.field_1352 - 10.0, playerPos.field_1351 - 10.0, playerPos.field_1350 - 10.0, playerPos.field_1352 + 10.0, playerPos.field_1351 + 10.0, playerPos.field_1350 + 10.0);
        for (class_1297 entity : world.method_8335((class_1297)player, knockbackBox)) {
            class_243 knockbackDirection = entity.method_19538().method_1020(playerPos).method_1029().method_1021(2.0);
            entity.method_18799(knockbackDirection);
            entity.field_6037 = true;
        }
        forceWaveCooldowns.put(playerId, System.currentTimeMillis());
        player.method_7353((class_2561)class_2561.method_43470((String)"Force Wave activated! Cooldown: 25 seconds."), true);
    }

    private static boolean isOnCooldown(HashMap<UUID, Long> cooldownMap, UUID playerId, long cooldownMillis) {
        Long lastUseTime = cooldownMap.get(playerId);
        return lastUseTime != null && System.currentTimeMillis() - lastUseTime < cooldownMillis;
    }
}

