/*
 * Decompiled with CFR 0.152.
 */
package prim.upsidedown.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import prim.upsidedown.render.VineData;
import prim.upsidedown.util.UpsideDownUtil;

@Environment(value=EnvType.CLIENT)
public class VineRenderer {
    private static final class_5819 RANDOM = class_5819.method_43047();
    private static class_2338 lastPlayerPos;
    private static final Map<class_1923, List<VineData>> vineChunkCache;
    private static class_1923 lastChunkPos;

    public static void register() {
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            class_310 client = class_310.method_1551();
            class_638 world = client.field_1687;
            if (world != null && VineRenderer.isUpsideDownDimension((class_1937)world)) {
                class_4587 matrices = context.matrixStack();
                class_4597 vertexConsumers = context.consumers();
                class_4604 frustum = context.frustum();
                int particleCount = 500;
                double range = 20.0;
                double motionFactor = 0.02;
                for (int i = 0; i < particleCount; ++i) {
                    double x = client.field_1724.method_23317() + RANDOM.method_43059() * range;
                    double y = client.field_1724.method_23318() + RANDOM.method_43059() * 10.0;
                    double z = client.field_1724.method_23321() + RANDOM.method_43059() * range;
                    double dx = RANDOM.method_43059() * motionFactor;
                    double dy = RANDOM.method_43059() * motionFactor * 0.2;
                    double dz = RANDOM.method_43059() * motionFactor;
                    world.method_8406((class_2394)class_2398.field_23956, x, y, z, dx, dy, dz);
                }
                VineRenderer.renderVines(matrices, client.field_1724.method_24515(), (class_1937)world, vertexConsumers, frustum);
            }
        });
    }

    private static void renderCachedVines(class_4587 matrices, class_4597 vertexConsumers, class_4604 frustum) {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (world == null) {
            return;
        }
        class_243 cameraPos = client.field_1773.method_19418().method_19326();
        int maxDistanceSq = 1024;
        vineChunkCache.values().forEach(arg_0 -> VineRenderer.lambda$renderCachedVines$1(cameraPos, maxDistanceSq, frustum, matrices, (class_1937)world, vertexConsumers, arg_0));
    }

    public static void renderVines(class_4587 matrices, class_2338 playerPos, class_1937 world, class_4597 vertexConsumers, class_4604 frustum) {
        class_1923 currentChunkPos = new class_1923(playerPos);
        if (vineChunkCache.isEmpty() || !currentChunkPos.equals((Object)lastChunkPos)) {
            lastChunkPos = currentChunkPos;
            VineRenderer.recalculateVineCache(world, currentChunkPos);
        }
        VineRenderer.renderCachedVines(matrices, vertexConsumers, frustum);
    }

    private static boolean isUpsideDownDimension(class_1937 world) {
        return UpsideDownUtil.isInUpsideDown(world);
    }

    private static boolean isVineEligible(class_2338 pos) {
        long seed = pos.method_10063();
        class_5819 random = class_5819.method_43049((long)seed);
        return random.method_43057() < 0.7f;
    }

    private static List<VineData> computeVinesForChunk(class_1937 world, class_1923 chunkPos) {
        ArrayList<VineData> vineDataList = new ArrayList<VineData>();
        int minY = world.method_31607();
        int maxY = world.method_31600();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = minY; y < maxY; ++y) {
                    class_2338 blockPos = new class_2338(chunkPos.method_8326() + x, y, chunkPos.method_8328() + z);
                    if (!world.method_8320(blockPos).method_26225() || !VineRenderer.isVineEligible(blockPos)) continue;
                    for (class_2350 face : class_2350.values()) {
                        if (!world.method_22347(blockPos.method_10093(face))) continue;
                        int bitmask = VineRenderer.calculateBitmask(world, blockPos, face);
                        vineDataList.add(new VineData(blockPos, face, bitmask));
                    }
                }
            }
        }
        return vineDataList;
    }

    private static int calculateBitmask(class_1937 world, class_2338 pos, class_2350 face) {
        class_2350 right;
        class_2350 left;
        class_2350 down;
        class_2350 up;
        int mask = 0;
        if (face.method_10166() == class_2350.class_2351.field_11052) {
            up = class_2350.field_11043;
            down = class_2350.field_11035;
            left = class_2350.field_11039;
            right = class_2350.field_11034;
        } else {
            up = class_2350.field_11036;
            down = class_2350.field_11033;
            left = face.method_10160();
            right = face.method_10170();
        }
        if (VineRenderer.hasVineAt(world, pos.method_10093(up), face)) {
            mask |= 1;
        }
        if (VineRenderer.hasVineAt(world, pos.method_10093(down), face)) {
            mask |= 2;
        }
        if (VineRenderer.hasVineAt(world, pos.method_10093(left), face)) {
            mask |= 4;
        }
        if (VineRenderer.hasVineAt(world, pos.method_10093(right), face)) {
            mask |= 8;
        }
        return mask;
    }

    private static boolean hasVineAt(class_1937 world, class_2338 pos, class_2350 face) {
        return world.method_8320(pos).method_26225() && VineRenderer.isVineEligible(pos) && world.method_22347(pos.method_10093(face));
    }

    private static class_2960 getDynamicVineTexture(int bitmask, class_2338 pos, class_2350 face) {
        String path;
        int variants = 3;
        boolean isCluster = false;
        if (bitmask == 15 && face.method_10166().method_10179()) {
            isCluster = true;
            variants = 10;
        }
        if (isCluster) {
            int variantSeed = Math.abs(Objects.hash(pos.method_10263(), pos.method_10264(), pos.method_10260()));
            int variant = variantSeed % variants + 1;
            return new class_2960("prims-upside-down-mod", "textures/environment/vine_" + variant + ".png");
        }
        switch (bitmask) {
            case 1: {
                path = "single/vine_n";
                break;
            }
            case 2: {
                path = "single/vine_s";
                break;
            }
            case 4: {
                path = "single/vine_w";
                break;
            }
            case 8: {
                path = "single/vine_e";
                break;
            }
            case 3: {
                path = "straight/vine_ns";
                break;
            }
            case 12: {
                path = "straight/vine_ew";
                break;
            }
            case 5: {
                path = "corner/vine_nw";
                break;
            }
            case 9: {
                path = "corner/vine_ne";
                break;
            }
            case 6: {
                path = "corner/vine_sw";
                break;
            }
            case 10: {
                path = "corner/vine_se";
                break;
            }
            case 13: {
                path = "t/vine_new";
                break;
            }
            case 7: {
                path = "t/vine_nsw";
                break;
            }
            case 11: {
                path = "t/vine_nse";
                break;
            }
            case 14: {
                path = "t/vine_sew";
                break;
            }
            case 15: {
                path = "cross/vine_nsew";
                break;
            }
            default: {
                path = "vine";
                variants = 8;
            }
        }
        int variantSeed = Math.abs(Objects.hash(pos.method_10263(), pos.method_10264(), pos.method_10260()));
        int variant = variantSeed % variants + 1;
        return new class_2960("prims-upside-down-mod", "textures/environment/" + path + "_" + variant + ".png");
    }

    private static void recalculateVineCache(class_1937 world, class_1923 currentChunkPos) {
        int chunkRadius = 1;
        vineChunkCache.keySet().removeIf(pos -> Math.abs(pos.field_9181 - currentChunkPos.field_9181) > chunkRadius || Math.abs(pos.field_9180 - currentChunkPos.field_9180) > chunkRadius);
        for (int dx = -chunkRadius; dx <= chunkRadius; ++dx) {
            for (int dz = -chunkRadius; dz <= chunkRadius; ++dz) {
                List<VineData> vines;
                class_1923 chunkPos = new class_1923(currentChunkPos.field_9181 + dx, currentChunkPos.field_9180 + dz);
                if (!world.method_8398().method_12123(chunkPos.field_9181, chunkPos.field_9180) || vineChunkCache.containsKey(chunkPos) && !vineChunkCache.get(chunkPos).isEmpty() || (vines = VineRenderer.computeVinesForChunk(world, chunkPos)).isEmpty() && !world.method_8398().method_12123(chunkPos.field_9181, chunkPos.field_9180)) continue;
                vineChunkCache.put(chunkPos, vines);
            }
        }
    }

    private static void renderVineAtPosition(class_4587 matrices, class_1937 world, class_243 cameraPos, class_2338 pos, class_2350 face, int bitmask, class_4597 vertexConsumers) {
        class_2680 blockState = world.method_8320(pos);
        class_265 shape = blockState.method_26218((class_1922)world, pos);
        if (shape.method_1110()) {
            return;
        }
        class_238 boundingBox = shape.method_1107();
        class_2960 vineTexture = VineRenderer.getDynamicVineTexture(bitmask, pos, face);
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23578((class_2960)vineTexture));
        boolean shouldMirror = false;
        double renderX = (double)pos.method_10263() - cameraPos.field_1352;
        double renderY = (double)pos.method_10264() - cameraPos.field_1351;
        double renderZ = (double)pos.method_10260() - cameraPos.field_1350;
        matrices.method_22903();
        matrices.method_22904(renderX, renderY, renderZ);
        switch (face) {
            case field_11043: {
                matrices.method_22904(boundingBox.field_1323, boundingBox.field_1322, boundingBox.field_1321 - 0.001);
                matrices.method_22905((float)(boundingBox.field_1320 - boundingBox.field_1323), (float)(boundingBox.field_1325 - boundingBox.field_1322), 1.0f);
                matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                matrices.method_46416(-1.0f, 0.0f, 0.0f);
                shouldMirror = true;
                break;
            }
            case field_11035: {
                matrices.method_22904(boundingBox.field_1323, boundingBox.field_1322, boundingBox.field_1324 + 0.001);
                matrices.method_22905((float)(boundingBox.field_1320 - boundingBox.field_1323), (float)(boundingBox.field_1325 - boundingBox.field_1322), 1.0f);
                shouldMirror = true;
                break;
            }
            case field_11034: {
                matrices.method_22904(boundingBox.field_1320 + 0.001, boundingBox.field_1322, boundingBox.field_1321);
                matrices.method_22905(1.0f, (float)(boundingBox.field_1325 - boundingBox.field_1322), (float)(boundingBox.field_1324 - boundingBox.field_1321));
                matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                matrices.method_46416(-1.0f, 0.0f, 0.0f);
                shouldMirror = true;
                break;
            }
            case field_11039: {
                matrices.method_22904(boundingBox.field_1323 - 0.001, boundingBox.field_1322, boundingBox.field_1324);
                matrices.method_22905(1.0f, (float)(boundingBox.field_1325 - boundingBox.field_1322), (float)(boundingBox.field_1324 - boundingBox.field_1321));
                matrices.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
                matrices.method_46416(-1.0f, 0.0f, 0.0f);
                shouldMirror = true;
                break;
            }
            case field_11036: {
                matrices.method_22904(boundingBox.field_1323, boundingBox.field_1325 + 0.001, boundingBox.field_1324);
                matrices.method_22905((float)(boundingBox.field_1320 - boundingBox.field_1323), 1.0f, (float)(boundingBox.field_1324 - boundingBox.field_1321));
                matrices.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
                break;
            }
            case field_11033: {
                matrices.method_22904(boundingBox.field_1323, boundingBox.field_1322 - 0.001, boundingBox.field_1321);
                matrices.method_22905((float)(boundingBox.field_1320 - boundingBox.field_1323), 1.0f, (float)(boundingBox.field_1324 - boundingBox.field_1321));
                matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            }
        }
        VineRenderer.renderQuad(vertexConsumer, matrices, 1.0f, 1.0f, shouldMirror);
        matrices.method_22909();
    }

    private static void renderQuad(class_4588 vertexConsumer, class_4587 matrices, float width, float height, boolean mirror) {
        Matrix4f positionMatrix = matrices.method_23760().method_23761();
        float uMin = mirror ? 1.0f : 0.0f;
        float uMax = mirror ? 0.0f : 1.0f;
        vertexConsumer.method_22918(positionMatrix, 0.0f, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(uMin, 1.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_22914(0.0f, 0.0f, -1.0f).method_1344();
        vertexConsumer.method_22918(positionMatrix, width, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(uMax, 1.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_22914(0.0f, 0.0f, -1.0f).method_1344();
        vertexConsumer.method_22918(positionMatrix, width, height, 0.0f).method_1336(255, 255, 255, 255).method_22913(uMax, 0.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_22914(0.0f, 0.0f, -1.0f).method_1344();
        vertexConsumer.method_22918(positionMatrix, 0.0f, height, 0.0f).method_1336(255, 255, 255, 255).method_22913(uMin, 0.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_22914(0.0f, 0.0f, -1.0f).method_1344();
    }

    private static /* synthetic */ void lambda$renderCachedVines$1(class_243 cameraPos, int maxDistanceSq, class_4604 frustum, class_4587 matrices, class_1937 world, class_4597 vertexConsumers, List vines) {
        for (VineData vine : vines) {
            class_2338 vinePos = vine.getBlockPos();
            double distSq = vinePos.method_40081(cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350);
            if (distSq > (double)maxDistanceSq || !frustum.method_23093(new class_238(vinePos))) continue;
            VineRenderer.renderVineAtPosition(matrices, world, cameraPos, vinePos, vine.getFace(), vine.getBitmask(), vertexConsumers);
        }
    }

    static {
        vineChunkCache = new HashMap<class_1923, List<VineData>>();
        lastChunkPos = new class_1923(0, 0);
    }
}

