/*
 * Decompiled with CFR 0.152.
 */
package prim.upsidedown.render;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class VineTextureManager {
    private static final String BASE_PATH = "textures/environment/";
    private static final Random RANDOM = new Random();
    private static final Map<String, class_2960[]> vineTextures = new HashMap<String, class_2960[]>();

    private static void registerTextures(String type, Map<String, Integer> baseNameToVariantCount) {
        int totalTextures = baseNameToVariantCount.values().stream().mapToInt(Integer::intValue).sum();
        class_2960[] textures = new class_2960[totalTextures];
        int index = 0;
        for (Map.Entry<String, Integer> entry : baseNameToVariantCount.entrySet()) {
            String baseName = entry.getKey();
            int variantCount = entry.getValue();
            for (int i = 1; i <= variantCount; ++i) {
                textures[index++] = new class_2960("prims-upside-down-mod", BASE_PATH + type + "/" + baseName + "_" + i + ".png");
            }
        }
        vineTextures.put(type, textures);
    }

    public static class_2960 getRandomTexture(String type) {
        class_2960[] textures = vineTextures.get(type);
        return textures != null ? textures[RANDOM.nextInt(textures.length)] : null;
    }

    static {
        VineTextureManager.registerTextures("single", Map.of("vine_n", 3, "vine_s", 3, "vine_e", 3, "vine_w", 3));
        VineTextureManager.registerTextures("straight", Map.of("vine_ns", 4, "vine_ew", 4));
        VineTextureManager.registerTextures("corner", Map.of("vine_ne", 4, "vine_nw", 4, "vine_se", 4, "vine_sw", 4));
        VineTextureManager.registerTextures("t", Map.of("vine_nse", 4, "vine_nsw", 4, "vine_new", 4, "vine_sew", 4));
        VineTextureManager.registerTextures("cross", Map.of("vine_nsew", 4));
    }
}

