/*
 * Decompiled with CFR 0.152.
 */
package prim.upsidedown.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1921;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class WebbingRenderer {
    private static final class_2960 WEBBING_TEXTURE = new class_2960("prims-upside-down-mod", "textures/environment/webbing_1.png");
    private static final Map<class_1923, List<class_2338>> webbingCache = new HashMap<class_1923, List<class_2338>>();
    private static class_1923 lastChunkPos = new class_1923(0, 0);
    private static final Random RANDOM = new Random();

    public static void register() {
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            class_310 client = class_310.method_1551();
            class_638 world = client.field_1687;
            if (world != null && WebbingRenderer.isUpsideDownDimension((class_1937)world)) {
                class_4587 matrices = context.matrixStack();
                class_4597 vertexConsumers = context.consumers();
                class_243 playerPos = client.field_1724.method_5836(1.0f);
                class_2338 playerBlockPos = client.field_1724.method_24515();
                class_1923 currentChunkPos = new class_1923(playerBlockPos);
                if (!currentChunkPos.equals((Object)lastChunkPos)) {
                    lastChunkPos = currentChunkPos;
                    WebbingRenderer.updateWebbingCache((class_1937)world, currentChunkPos);
                }
                WebbingRenderer.renderWebbing(matrices, playerPos, vertexConsumers, (class_1937)world);
            }
        });
    }

    private static boolean isUpsideDownDimension(class_1937 world) {
        return world.method_27983().method_29177().toString().equals("prims-upside-down-mod:upsidedown");
    }

    private static void updateWebbingCache(class_1937 world, class_1923 chunkPos) {
        int chunkRadius = 2;
        webbingCache.clear();
        for (int dx = -chunkRadius; dx <= chunkRadius; ++dx) {
            for (int dz = -chunkRadius; dz <= chunkRadius; ++dz) {
                class_1923 offsetChunk = new class_1923(chunkPos.field_9181 + dx, chunkPos.field_9180 + dz);
                if (webbingCache.containsKey(offsetChunk)) continue;
                List<class_2338> webbingPositions = WebbingRenderer.computeWebbingForChunk(world, offsetChunk);
                webbingCache.put(offsetChunk, webbingPositions);
                System.out.println("[Debug] Cached " + webbingPositions.size() + " webbing positions in chunk " + offsetChunk);
            }
        }
    }

    private static List<class_2338> computeWebbingForChunk(class_1937 world, class_1923 chunkPos) {
        ArrayList<class_2338> webbingPositions = new ArrayList<class_2338>();
        class_2338 chunkStart = new class_2338(chunkPos.method_8326(), 0, chunkPos.method_8328());
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = world.method_31605() - 1; y > 0; --y) {
                    class_2338 pos = chunkStart.method_10069(x, y, z);
                    if (!WebbingRenderer.isCeilingCorner(world, pos)) continue;
                    webbingPositions.add(pos);
                }
            }
        }
        return webbingPositions;
    }

    private static boolean isCeilingCorner(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        class_2680 above = world.method_8320(pos.method_10084());
        class_2680 north = world.method_8320(pos.method_10095());
        class_2680 west = world.method_8320(pos.method_10067());
        return state.method_26215() && above.method_26225() && !north.method_26225() && !west.method_26225();
    }

    private static void renderWebbing(class_4587 matrices, class_243 playerPos, class_4597 vertexConsumers, class_1937 world) {
        webbingCache.values().forEach(webbingList -> {
            for (class_2338 webbingPos : webbingList) {
                class_243 renderPos = class_243.method_24953((class_2382)webbingPos).method_1020(playerPos).method_1031(0.0, -0.5, 0.0);
                WebbingRenderer.renderWebbingTexture(matrices, renderPos, vertexConsumers);
            }
        });
    }

    private static void renderWebbingTexture(class_4587 matrices, class_243 renderPos, class_4597 vertexConsumers) {
        matrices.method_22903();
        matrices.method_22904(renderPos.field_1352, renderPos.field_1351, renderPos.field_1350);
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23578((class_2960)WEBBING_TEXTURE));
        WebbingRenderer.renderQuad(vertexConsumer, matrices, 1.0f, 1.0f);
        matrices.method_22909();
    }

    private static void renderQuad(class_4588 vertexConsumer, class_4587 matrices, float width, float height) {
        Matrix4f positionMatrix = matrices.method_23760().method_23761();
        vertexConsumer.method_22918(positionMatrix, 0.0f, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_22914(0.0f, 0.0f, -1.0f).method_1344();
        vertexConsumer.method_22918(positionMatrix, width, 0.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_22914(0.0f, 0.0f, -1.0f).method_1344();
        vertexConsumer.method_22918(positionMatrix, width, height, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_22914(0.0f, 0.0f, -1.0f).method_1344();
        vertexConsumer.method_22918(positionMatrix, 0.0f, height, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_22914(0.0f, 0.0f, -1.0f).method_1344();
    }
}

