/*
 * Decompiled with CFR 0.152.
 */
package prim.upsidedown.world;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import prim.upsidedown.core.UDMEntities;
import prim.upsidedown.core.UDMGameRules;
import prim.upsidedown.core.UDMSounds;
import prim.upsidedown.dimension.UpsideDown;
import prim.upsidedown.entities.RedLightningEntity;
import prim.upsidedown.entity.DemogorgonEntity;

public class UpsideDownEventTracker {
    private static final int MIN_DELAY = 2400;
    private static final int MAX_DELAY = 6000;
    private int nextSpawnDelay = this.getRandomDelay();
    private int demogorgonSpawnTimer = 0;
    public static boolean inUpsideDown;
    public static final Set<class_3222> playersInUpsideDown;

    private int getRandomDelay() {
        Random random = new Random();
        return 2400 + random.nextInt(3601);
    }

    public static boolean isPlayerInUpsideDown(class_3222 player) {
        return playersInUpsideDown.contains(player);
    }

    private static boolean isUpsideDownDimension(class_1937 world) {
        return world.method_27983().method_29177().toString().equals("prims-upside-down-mod:upsidedown");
    }

    private static void forceLightUpdate(class_1937 world, class_2338 pos) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_8503().execute(() -> {
                for (int x = -4; x <= 4; ++x) {
                    for (int y = -4; y <= 4; ++y) {
                        for (int z = -4; z <= 4; ++z) {
                            class_2338 checkPos = pos.method_10069(x, y, z);
                            serverWorld.method_14178().method_17293().method_15513(checkPos);
                        }
                    }
                }
            });
        }
    }

    public void tick(class_3218 world) {
        if (!world.method_27983().equals(UpsideDown.UPSIDE_DOWN_DIMENSION_KEY)) {
            return;
        }
        List players = world.method_18456();
        if (players.isEmpty()) {
            return;
        }
        if (world.method_8450().method_8355(UDMGameRules.UPSIDE_DOWN_WAR)) {
            this.spawnWarLightning(world, players);
            this.handleWarSpawns(world, players);
        }
        ++this.demogorgonSpawnTimer;
        if (this.demogorgonSpawnTimer == this.nextSpawnDelay) {
            this.spawnDemogorgonNearRandomPlayer(world);
            this.demogorgonSpawnTimer = 0;
            this.nextSpawnDelay = this.getRandomDelay();
        }
    }

    private void spawnWarLightning(class_3218 world, List<class_3222> players) {
        if (world.field_9229.method_43048(30) == 0) {
            class_3222 target = players.get(world.field_9229.method_43048(players.size()));
            int xOffset = world.field_9229.method_43048(101) - 70;
            int zOffset = world.field_9229.method_43048(101) - 70;
            class_2338 targetPos = target.method_24515().method_10069(xOffset, 0, zOffset);
            class_2338 lightningPos = world.method_8598(class_2902.class_2903.field_13197, targetPos);
            RedLightningEntity lightning = new RedLightningEntity(UDMEntities.RED_LIGHTNING, (class_1937)world);
            lightning.method_29495(lightningPos.method_46558());
            world.method_8649((class_1297)lightning);
        }
    }

    private void handleWarSpawns(class_3218 world, List<class_3222> players) {
        if (world.field_9229.method_43048(100) == 0) {
            for (class_3222 player : players) {
                List localDemogorgons = world.method_8390(DemogorgonEntity.class, player.method_5829().method_1014(50.0), entity -> entity.method_5805());
                if (localDemogorgons.size() >= 5) continue;
                this.spawnDemogorgonNearPlayer(world, player);
            }
        }
    }

    private void spawnDemogorgonNearPlayer(class_3218 world, class_3222 player) {
        DemogorgonEntity demogorgon;
        int range = 20;
        int x = player.method_31477() + world.field_9229.method_43048(range * 2) - range;
        int z = player.method_31479() + world.field_9229.method_43048(range * 2) - range;
        class_2338 spawnPos = this.findGroundPosition(world, new class_2338(x, player.method_31478(), z));
        if (spawnPos != null && (demogorgon = (DemogorgonEntity)UDMEntities.DEMOGORGON.method_5883((class_1937)world)) != null) {
            demogorgon.method_5808((double)spawnPos.method_10263() + 0.5, spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, world.field_9229.method_43057() * 360.0f, 0.0f);
            world.method_8649((class_1297)demogorgon);
            world.method_8396(null, spawnPos, UDMSounds.DEMOGORGON_ROAR, class_3419.field_15251, 1.0f, 0.8f);
        }
    }

    private void spawnDemogorgonNearRandomPlayer(class_3218 world) {
        List players = world.method_18456();
        if (players.isEmpty()) {
            return;
        }
        class_3222 targetPlayer = (class_3222)players.get(world.method_8409().method_43048(players.size()));
        this.spawnDemogorgonWithRoar(world, targetPlayer);
    }

    private void spawnDemogorgonWithRoar(class_3218 world, class_3222 player) {
        int range = 5;
        class_2338 playerPos = player.method_24515();
        class_2338 spawnPos = playerPos.method_10069(world.method_8409().method_43048(range * 2) - range, 0, world.method_8409().method_43048(range * 2) - range);
        class_2338 groundPos = this.findGroundPosition(world, spawnPos);
        if (groundPos == null) {
            return;
        }
        DemogorgonEntity demogorgon = (DemogorgonEntity)UDMEntities.DEMOGORGON.method_5883((class_1937)world);
        if (demogorgon != null) {
            demogorgon.method_5808((double)groundPos.method_10263() + 0.5, groundPos.method_10264(), (double)groundPos.method_10260() + 0.5, 0.0f, 0.0f);
            world.method_8649((class_1297)demogorgon);
            world.method_8396(null, groundPos, UDMSounds.DEMOGORGON_ROAR, class_3419.field_15251, 1.5f, 1.0f);
        }
    }

    private class_2338 findGroundPosition(class_3218 world, class_2338 pos) {
        int y = pos.method_10264();
        class_2338.class_2339 mutable = new class_2338.class_2339(pos.method_10263(), y, pos.method_10260());
        while (y > world.method_31607() && !world.method_8320((class_2338)mutable).method_26225()) {
            mutable.method_33098(--y);
        }
        if (world.method_8320((class_2338)mutable).method_26225()) {
            class_2338 abovePos = mutable.method_10084();
            class_2338 twoAbovePos = abovePos.method_10084();
            if (world.method_8320(abovePos).method_26215() && world.method_8320(twoAbovePos).method_26215() && !world.method_8320((class_2338)mutable).method_26227().method_15767(class_3486.field_15518) && !world.method_8320((class_2338)mutable).method_26227().method_15767(class_3486.field_15517)) {
                return mutable.method_10062();
            }
        }
        return null;
    }

    static {
        playersInUpsideDown = new HashSet<class_3222>();
    }
}

