/*
 * Decompiled with CFR 0.152.
 */
package prim.upsidedown.world;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2453;
import net.minecraft.class_2457;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.joml.Vector3f;

public class UpsideDownRedstoneManager {
    private static final Set<class_2338> activePositions = new HashSet<class_2338>();
    private static final Set<class_2338> illuminatedPositions = new HashSet<class_2338>();

    public static boolean isPositionActive(class_2338 pos) {
        return activePositions.contains(pos);
    }

    public static void tick(class_3218 upsideDownWorld) {
        class_3218 overworld = upsideDownWorld.method_8503().method_3847(class_1937.field_25179);
        if (overworld == null) {
            return;
        }
        HashSet<class_2338> currentTickPositions = new HashSet<class_2338>();
        illuminatedPositions.clear();
        for (class_3222 player : upsideDownWorld.method_18456()) {
            class_2338 playerPos = player.method_24515();
            currentTickPositions.add(playerPos);
            int radius = 5;
            for (class_2338 checkPos : class_2338.method_10097((class_2338)playerPos.method_10069(-radius, -radius, -radius), (class_2338)playerPos.method_10069(radius, radius, radius))) {
                if (!UpsideDownRedstoneManager.isRedstoneComponent((class_1937)overworld, checkPos) || overworld.method_49804(checkPos) <= 0) continue;
                illuminatedPositions.add(checkPos.method_10062());
            }
        }
        for (class_2338 pos : currentTickPositions) {
            if (activePositions.contains(pos)) continue;
            UpsideDownRedstoneManager.updateRedstone(overworld, pos);
        }
        for (class_2338 pos : activePositions) {
            if (currentTickPositions.contains(pos)) continue;
            UpsideDownRedstoneManager.updateRedstone(overworld, pos);
        }
        activePositions.clear();
        activePositions.addAll(currentTickPositions);
        UpsideDownRedstoneManager.spawnParticles(upsideDownWorld);
    }

    private static boolean isRedstoneComponent(class_1937 world, class_2338 pos) {
        class_2248 block = world.method_8320(pos).method_26204();
        return block instanceof class_2453 || block instanceof class_2457 || block instanceof class_2312 || block == class_2246.field_9973 || block == class_2246.field_10453 || block == class_2246.field_10560 || block == class_2246.field_10615;
    }

    private static void spawnParticles(class_3218 world) {
        class_2390 goldenDust = new class_2390(new Vector3f(1.0f, 0.8f, 0.0f), 1.0f);
        for (class_2338 pos : illuminatedPositions) {
            for (int i = 0; i < 2; ++i) {
                double x = (double)pos.method_10263() + world.field_9229.method_43058();
                double y = (double)pos.method_10264() + world.field_9229.method_43058();
                double z = (double)pos.method_10260() + world.field_9229.method_43058();
                world.method_14199((class_2394)goldenDust, x, y, z, 1, 0.05, 0.05, 0.05, 0.02);
            }
        }
    }

    private static void updateRedstone(class_3218 world, class_2338 pos) {
        world.method_8408(pos, world.method_8320(pos).method_26204());
        for (class_2350 direction : class_2350.values()) {
            world.method_8408(pos.method_10093(direction), world.method_8320(pos).method_26204());
        }
    }

    public static int getRedstonePower(class_1937 world, class_2338 pos) {
        if (!world.field_9236 && world.method_27983().equals(class_1937.field_25179) && activePositions.contains(pos)) {
            return 15;
        }
        return 0;
    }
}

