/*
 * Decompiled with CFR 0.152.
 */
package prim.upsidedown.world;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2861;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3227;
import net.minecraft.class_3481;
import net.minecraft.class_5218;
import net.minecraft.class_7923;

public class UpsideDownSyncHandler {
    private static final Set<String> OMIT_LIST = Set.of("minecraft:water", "minecraft:lava", "minecraft:torch", "minecraft:wall_torch", "minecraft:soul_torch", "minecraft:soul_wall_torch", "minecraft:lantern", "minecraft:soul_lantern", "minecraft:glowstone", "minecraft:sea_lantern", "minecraft:jack_o_lantern", "minecraft:campfire", "minecraft:soul_campfire", "minecraft:seagrass", "minecraft:tall_seagrass", "minecraft:kelp", "minecraft:kelp_plant", "minecraft:glow_berries", "minecraft:cave_vines", "minecraft:cave_vines_plant", "minecraft:shroomlight", "minecraft:ochre_froglight", "minecraft:pearlescent_froglight", "minecraft:verdant_froglight", "minecraft:magma_block", "minecraft:crying_obsidian", "minecraft:redstone_torch", "minecraft:redstone_wall_torch", "minecraft:sea_pickle", "minecraft:end_rod", "minecraft:glow_lichen", "minecraft:amethyst_cluster", "minecraft:large_amethyst_bud", "minecraft:medium_amethyst_bud", "minecraft:small_amethyst_bud", "minecraft:conduit", "minecraft:beacon", "minecraft:brown_mushroom", "minecraft:oak_leaves", "minecraft:spruce_leaves", "minecraft:birch_leaves", "minecraft:jungle_leaves", "minecraft:acacia_leaves", "minecraft:dark_oak_leaves", "minecraft:mangrove_leaves", "minecraft:cherry_leaves", "minecraft:azalea_leaves", "minecraft:flowering_azalea_leaves", "minecraft:candle", "minecraft:white_candle", "minecraft:orange_candle", "minecraft:magenta_candle", "minecraft:light_blue_candle", "minecraft:yellow_candle", "minecraft:lime_candle", "minecraft:pink_candle", "minecraft:gray_candle", "minecraft:light_gray_candle", "minecraft:cyan_candle", "minecraft:purple_candle", "minecraft:blue_candle", "minecraft:brown_candle", "minecraft:green_candle", "minecraft:red_candle", "minecraft:black_candle", "minecraft:light");

    public static void massSyncSavedChunks(class_3218 overworld, class_3218 upsideDown) {
        Path overDir = overworld.method_8503().method_27050(class_5218.field_24188).resolve("region");
        Path udDir = overworld.method_8503().method_27050(class_5218.field_24188).resolve("dimensions").resolve("prims-upside-down-mod").resolve("upsidedown").resolve("region");
        File[] regionFiles = overDir.toFile().listFiles((dir, name) -> name.endsWith(".mca"));
        if (regionFiles == null) {
            return;
        }
        try {
            Files.createDirectories(udDir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((Stream)Arrays.stream(regionFiles).parallel()).forEach(file -> {
            Matcher matcher = Pattern.compile("r\\.(-?\\d+)\\.(-?\\d+)\\.mca").matcher(file.getName());
            if (matcher.matches()) {
                int regionX = Integer.parseInt(matcher.group(1));
                int regionZ = Integer.parseInt(matcher.group(2));
                File targetFile = udDir.resolve(file.getName()).toFile();
                UpsideDownSyncHandler.processRegionHybrid(overworld, upsideDown, file, targetFile, regionX, regionZ);
            }
        });
    }

    private static void processRegionHybrid(class_3218 over, class_3218 ud, File source, File target, int rX, int rZ) {
        try (class_2861 srcRegion = new class_2861(source.toPath(), source.getParentFile().toPath(), true);
             class_2861 dstRegion = new class_2861(target.toPath(), target.getParentFile().toPath(), true);){
            for (int x = 0; x < 32; ++x) {
                for (int z = 0; z < 32; ++z) {
                    class_1923 pos = new class_1923((rX << 5) + x, (rZ << 5) + z);
                    if (!srcRegion.method_12423(new class_1923(x, z))) continue;
                    if (ud.method_14178().method_12123(pos.field_9181, pos.field_9180)) {
                        ud.method_8503().execute(() -> UpsideDownSyncHandler.syncSingleChunk(over, ud, pos));
                        continue;
                    }
                    try (DataInputStream in = srcRegion.method_21873(new class_1923(x, z));){
                        class_2487 nbt = class_2507.method_10627((DataInput)in);
                        if (nbt == null) continue;
                        UpsideDownSyncHandler.scrubNbt(nbt);
                        try (DataOutputStream out = dstRegion.method_21881(new class_1923(x, z));){
                            class_2507.method_10628((class_2487)nbt, (DataOutput)out);
                            continue;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void scrubNbt(class_2487 nbt) {
        if (!nbt.method_10573("sections", 9)) {
            return;
        }
        class_2499 sections = nbt.method_10554("sections", 10);
        for (int i = 0; i < sections.size(); ++i) {
            class_2487 section = sections.method_10602(i);
            section.method_10551("BlockLight");
            section.method_10551("SkyLight");
            if (!section.method_10573("block_states", 10)) continue;
            class_2499 palette = section.method_10562("block_states").method_10554("palette", 10);
            for (int p = 0; p < palette.size(); ++p) {
                class_2487 props;
                class_2487 entry = palette.method_10602(p);
                String blockId = entry.method_10558("Name");
                if (entry.method_10573("Properties", 10) && (props = entry.method_10562("Properties")).method_10545("waterlogged")) {
                    props.method_10582("waterlogged", "false");
                }
                class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960(blockId));
                class_2680 state = block.method_9564();
                if (!OMIT_LIST.contains(blockId) && state.method_26213() <= 0 && !(block instanceof class_2404) && !state.method_26164(class_3481.field_15503) && !blockId.equals("minecraft:light")) continue;
                entry.method_10582("Name", "minecraft:air");
                entry.method_10551("Properties");
            }
        }
        nbt.method_10551("BlockLight");
        nbt.method_10551("SkyLight");
        nbt.method_10551("Heightmaps");
    }

    public static void syncSingleChunk(class_3218 over, class_3218 ud, class_1923 pos) {
        class_2818 source = over.method_14178().method_21730(pos.field_9181, pos.field_9180);
        if (source == null) {
            return;
        }
        class_3227 lightingProvider = ud.method_14178().method_17293();
        class_2338.class_2339 mPos = new class_2338.class_2339();
        for (int y = over.method_31607(); y < over.method_31600(); ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    mPos.method_10103(pos.method_8326() + x, y, pos.method_8328() + z);
                    class_2680 state = source.method_8320((class_2338)mPos);
                    int updateFlags = 3;
                    boolean changed = false;
                    if (UpsideDownSyncHandler.shouldOmit(state)) {
                        ud.method_8652((class_2338)mPos, class_2246.field_10124.method_9564(), updateFlags);
                        changed = true;
                    } else {
                        if (state.method_28498((class_2769)class_2741.field_12508) && ((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
                            state = (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
                            changed = true;
                        }
                        if (!state.method_26227().method_15769()) {
                            changed = true;
                        }
                        ud.method_8652((class_2338)mPos, state, updateFlags);
                    }
                    if (!changed) continue;
                    lightingProvider.method_15513((class_2338)mPos);
                }
            }
        }
        ud.method_14178().method_14128((class_2338)mPos);
    }

    private static boolean shouldOmit(class_2680 state) {
        String id = class_7923.field_41175.method_10221((Object)state.method_26204()).toString();
        boolean isLightSource = state.method_26213() > 0;
        return OMIT_LIST.contains(id) || isLightSource || state.method_26204() instanceof class_2404 || state.method_26164(class_3481.field_15503) || id.equals("minecraft:light");
    }
}

