#version 150

uniform sampler2D Sampler0;
uniform float Time;
out vec4 FragColor;

void main() {
    vec4 color = texture(Sampler0, gl_FragCoord.xy / vec2(1920.0, 1080.0));
    float gray = dot(color.rgb, vec3(0.299, 0.587, 0.114)); // Luminance calculation
    color.rgb = mix(color.rgb, vec3(gray), 0.3); // Adjust the mix factor (0.3) to control desaturation level
    FragColor = color;
}
