/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.world;

import com.sonicether.soundphysics.world.ClonedLevelHeightAccessor;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_148;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2826;
import net.minecraft.class_2902;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5539;
import net.minecraft.class_6755;
import net.minecraft.class_6763;
import net.minecraft.class_7924;

public class ClonedLevelChunk
extends class_2791 {
    private final class_6755<class_2248> blockTicks;
    private final class_6755<class_3611> fluidTicks;

    public ClonedLevelChunk(class_1937 level, class_1923 chunkPos, @Nullable class_2826[] levelChunkSections) {
        super(chunkPos, null, (class_5539)new ClonedLevelHeightAccessor(level), level.method_30349().method_30530(class_7924.field_41236), 0L, levelChunkSections, null);
        for (class_2902.class_2903 types : class_2902.class_2903.values()) {
            if (!class_2806.field_12803.method_12160().contains(types)) continue;
            this.field_34541.put(types, new class_2902((class_2791)this, types));
        }
        this.blockTicks = new class_6755();
        this.fluidTicks = new class_6755();
    }

    public class_2586 method_8321(@Nonnull class_2338 blockPos) {
        return (class_2586)this.field_34543.get(blockPos);
    }

    public class_2680 method_8320(@Nonnull class_2338 blockPos) {
        return this.withLevelChunkSectionAtPosition(blockPos, section -> {
            if (section == null || section.method_38292()) {
                return class_2246.field_10124.method_9564();
            }
            return section.method_12254(blockPos.method_10263() & 0xF, blockPos.method_10264() & 0xF, blockPos.method_10260() & 0xF);
        });
    }

    public class_3610 method_8316(@Nonnull class_2338 blockPos) {
        return this.withLevelChunkSectionAtPosition(blockPos, section -> {
            if (section == null || section.method_38292()) {
                return class_3612.field_15906.method_15785();
            }
            return section.method_12255(blockPos.method_10263() & 0xF, blockPos.method_10264() & 0xF, blockPos.method_10260() & 0xF);
        });
    }

    private <T> T withLevelChunkSectionAtPosition(class_2338 blockPos, Function<class_2826, T> block) {
        try {
            int sectionIndex = this.method_31602(blockPos.method_10264());
            if (sectionIndex >= 0 && sectionIndex < this.field_34545.length) {
                class_2826 section = this.field_34545[sectionIndex];
                return block.apply(section);
            }
            return block.apply(null);
        }
        catch (Throwable exception) {
            class_128 crashReport = class_128.method_560((Throwable)exception, (String)"Getting section in cloned level chunk");
            class_129 crashReportCategory = crashReport.method_562("Chunk Section Get");
            crashReportCategory.method_577("Location", () -> class_129.method_581((class_5539)this, (int)blockPos.method_10263(), (int)blockPos.method_10264(), (int)blockPos.method_10260()));
            throw new class_148(crashReport);
        }
    }

    public class_6763<class_2248> method_12013() {
        return this.blockTicks;
    }

    public class_6763<class_3611> method_12014() {
        return this.fluidTicks;
    }

    public class_2791.class_6745 method_39296() {
        return new class_2791.class_6745(this.blockTicks, this.fluidTicks);
    }

    public class_2806 method_12009() {
        return class_2806.field_12803;
    }

    public void method_12002(@Nonnull class_1297 entity) {
        throw new UnsupportedOperationException("Can not add entity to read-only level clone");
    }

    public class_2487 method_20598(@Nonnull class_2338 blockPos) {
        throw new UnsupportedOperationException("Can not read block entity NBT data from read-only level clone");
    }

    public void method_12041(@Nonnull class_2338 blockPos) {
        throw new UnsupportedOperationException("Can not remove entity from read-only level clone");
    }

    public void method_12007(@Nonnull class_2586 blockEntity) {
        throw new UnsupportedOperationException("Can not set block entity in read-only level clone");
    }

    public class_2680 method_12010(@Nonnull class_2338 blockPos, @Nonnull class_2680 blockState, boolean unknownFlag) {
        throw new UnsupportedOperationException("Can not set block state in read-only level clone");
    }
}

