/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.api.dye;

import info.u_team.u_team_core.api.dye.DyeableItemsRegistry;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public interface DyeableItem {
    public static final String TAG_DISPLAY = "display";
    public static final String TAG_COLOR = "color";
    public static final int DEFAULT_COLOR = 10511680;

    default public <T extends class_1792> void addColoredItem(T item) {
        DyeableItemsRegistry.addItem(item);
    }

    default public boolean hasColor(class_1799 stack) {
        class_2487 compound = stack.method_7941(TAG_DISPLAY);
        return compound != null && compound.method_10573(TAG_COLOR, 99);
    }

    default public int getColor(class_1799 stack) {
        class_2487 compound = stack.method_7941(TAG_DISPLAY);
        return compound != null && compound.method_10573(TAG_COLOR, 99) ? compound.method_10550(TAG_COLOR) : this.getDefaultColor();
    }

    default public void removeColor(class_1799 stack) {
        class_2487 compound = stack.method_7941(TAG_DISPLAY);
        if (compound != null && compound.method_10545(TAG_COLOR)) {
            compound.method_10551(TAG_COLOR);
        }
    }

    default public void setColor(class_1799 stack, int color) {
        stack.method_7911(TAG_DISPLAY).method_10569(TAG_COLOR, color);
    }

    default public int getDefaultColor() {
        return 10511680;
    }

    public static class_1799 colorStack(class_1799 stack, List<class_1767> dyeList) {
        if (!(stack.method_7909() instanceof DyeableItem)) {
            return class_1799.field_8037;
        }
        DyeableItem dyeableItem = (DyeableItem)stack.method_7909();
        class_1799 dyedStack = stack.method_7972();
        dyedStack.method_7939(1);
        int[] rbgItemSum = new int[3];
        int mostIntenseChannelSum = 0;
        int colorItemSum = 0;
        if (dyeableItem.hasColor(dyedStack)) {
            int color = dyeableItem.getColor(dyedStack);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            mostIntenseChannelSum = (int)((float)mostIntenseChannelSum + Math.max(red, Math.max(green, blue)) * 255.0f);
            rbgItemSum[0] = (int)((float)rbgItemSum[0] + red * 255.0f);
            rbgItemSum[1] = (int)((float)rbgItemSum[1] + green * 255.0f);
            rbgItemSum[2] = (int)((float)rbgItemSum[2] + blue * 255.0f);
            ++colorItemSum;
        }
        for (class_1767 dye : dyeList) {
            float[] colorComponents = dye.method_7787();
            int red = (int)(colorComponents[0] * 255.0f);
            int green = (int)(colorComponents[1] * 255.0f);
            int blue = (int)(colorComponents[2] * 255.0f);
            mostIntenseChannelSum += Math.max(red, Math.max(green, blue));
            rbgItemSum[0] = rbgItemSum[0] + red;
            rbgItemSum[1] = rbgItemSum[1] + green;
            rbgItemSum[2] = rbgItemSum[2] + blue;
            ++colorItemSum;
        }
        int red = rbgItemSum[0] / colorItemSum;
        int green = rbgItemSum[1] / colorItemSum;
        int blue = rbgItemSum[2] / colorItemSum;
        float averageChannel = (float)mostIntenseChannelSum / (float)colorItemSum;
        float mostIntenseChannel = Math.max(red, Math.max(green, blue));
        red = (int)((float)red * averageChannel / mostIntenseChannel);
        green = (int)((float)green * averageChannel / mostIntenseChannel);
        blue = (int)((float)blue * averageChannel / mostIntenseChannel);
        int finalColor = (red << 8) + green;
        finalColor = (finalColor << 8) + blue;
        dyeableItem.setColor(dyedStack, finalColor);
        return dyedStack;
    }

    public static class_1799 colorStackDyeItem(class_1799 stack, List<class_1769> dyeItemList) {
        return DyeableItem.colorStack(stack, dyeItemList.stream().map(dyeItem -> dyeItem.method_7802()).collect(Collectors.toList()));
    }
}

