/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.api.gui.Scalable;
import info.u_team.u_team_core.api.gui.ScaleProvider;
import info.u_team.u_team_core.gui.elements.UEditBox;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.WidgetUtil;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5481;

public class ScalableEditBox
extends UEditBox
implements Scalable,
ScaleProvider {
    protected float scale;

    public ScalableEditBox(class_327 font, int x, int y, int width, int height, UEditBox previousEditBox, class_2561 title, float scale) {
        super(font, x, y, width, height, previousEditBox, title);
        this.scale = scale;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float scale) {
        this.scale = scale;
    }

    @Override
    public void renderForeground(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        float currentScale = this.getCurrentScale(guiGraphics, mouseX, mouseY, partialTick);
        float positionFactor = 1.0f / this.scale;
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_22905(currentScale, currentScale, 0.0f);
        RGBA currentTextColor = WidgetUtil.respectWidgetAlpha((class_339)this, this.getCurrentTextColor(guiGraphics, mouseX, mouseY, partialTick));
        String currentText = this.field_2105.method_27523(this.field_2092.substring(this.field_2103), (int)((float)this.method_1859() * positionFactor));
        int cursorOffset = this.field_2102 - this.field_2103;
        int selectionOffset = Math.min(this.field_2101 - this.field_2103, currentText.length());
        boolean isCursorInText = cursorOffset >= 0 && cursorOffset <= currentText.length();
        boolean shouldCursorBlink = this.method_25370() && this.field_2107 / 6 % 2 == 0 && isCursorInText;
        boolean isCursorInTheMiddle = this.field_2102 < this.field_2092.length() || this.field_2092.length() >= this.field_2108;
        int xOffset = (int)((float)(this.field_2095 ? this.field_22760 + 4 : this.field_22760) * positionFactor);
        int yOffset = (int)((this.field_2095 ? (float)this.field_22761 + ((float)this.field_22759 - 8.0f * currentScale) / 2.0f : (float)this.field_22761) * positionFactor);
        int leftRenderedTextX = xOffset;
        if (!currentText.isEmpty()) {
            String firstTextPart = isCursorInText ? currentText.substring(0, cursorOffset) : currentText;
            leftRenderedTextX = guiGraphics.method_35720(this.field_2105, (class_5481)this.field_2099.apply(firstTextPart, this.field_2103), xOffset, yOffset, currentTextColor.getColorARGB());
        }
        int rightRenderedTextX = leftRenderedTextX;
        if (!isCursorInText) {
            rightRenderedTextX = cursorOffset > 0 ? (int)((float)xOffset + (float)this.field_22758 * positionFactor) : xOffset;
        } else if (isCursorInTheMiddle) {
            rightRenderedTextX = leftRenderedTextX - 1;
            --leftRenderedTextX;
        }
        if (!currentText.isEmpty() && isCursorInText && cursorOffset < currentText.length()) {
            guiGraphics.method_35720(this.field_2105, (class_5481)this.field_2099.apply(currentText.substring(cursorOffset), this.field_2102), leftRenderedTextX, yOffset, currentTextColor.getColorARGB());
        }
        if (this.field_41100 != null && currentText.isEmpty() && !this.method_25370()) {
            guiGraphics.method_27535(this.field_2105, this.field_41100, leftRenderedTextX, yOffset, WidgetUtil.respectWidgetAlpha((class_339)this, this.getCurrentHintTextColor(guiGraphics, mouseX, mouseY, partialTick)).getColorARGB());
        }
        if (!isCursorInTheMiddle && this.field_2106 != null) {
            guiGraphics.method_25303(this.field_2105, this.field_2106, rightRenderedTextX - 1, yOffset, WidgetUtil.respectWidgetAlpha((class_339)this, this.getCurrentSuggestionTextColor(guiGraphics, mouseX, mouseY, partialTick)).getColorARGB());
        }
        if (shouldCursorBlink) {
            if (isCursorInTheMiddle) {
                guiGraphics.method_25294(rightRenderedTextX, yOffset - 1, rightRenderedTextX + 1, yOffset + 1 + 9, WidgetUtil.respectWidgetAlpha((class_339)this, this.getCurrentCursorColor(guiGraphics, mouseX, mouseY, partialTick)).getColorARGB());
            } else {
                guiGraphics.method_25303(this.field_2105, "_", rightRenderedTextX, yOffset, currentTextColor.getColorARGB());
            }
        }
        poseStack.method_22909();
        if (selectionOffset != cursorOffset) {
            int selectedX = xOffset + this.field_2105.method_1727(currentText.substring(0, selectionOffset));
            this.method_1886(guiGraphics, (int)((float)rightRenderedTextX * currentScale), (int)((float)(yOffset - 1) * currentScale), (int)((float)(selectedX - 1) * currentScale), (int)((float)(yOffset + 1 + 9) * currentScale));
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.field_22763 && this.field_22764 && this.method_25351(button)) {
            boolean clicked = this.method_25361(mouseX, mouseY);
            if (this.field_2096) {
                this.method_25365(clicked);
            }
            if (this.method_25370() && clicked) {
                int clickOffset = class_3532.method_15357((double)mouseX) - this.field_22760;
                if (this.field_2095) {
                    clickOffset -= 4;
                }
                clickOffset = (int)((float)clickOffset / this.getCurrentScale());
                String currentText = this.field_2105.method_27523(this.field_2092.substring(this.field_2103), (int)((float)(this.method_1859() * 1) / this.getCurrentScale()));
                this.method_1883(this.field_2105.method_27523(currentText, clickOffset).length() + this.field_2103);
                return true;
            }
        }
        return false;
    }

    public void method_1884(int position) {
        int valueLength = this.field_2092.length();
        this.field_2101 = class_3532.method_15340((int)position, (int)0, (int)valueLength);
        if (this.field_2105 != null) {
            if (this.field_2103 > valueLength) {
                this.field_2103 = valueLength;
            }
            int scaledInnerWidth = (int)((float)(this.method_1859() * 1) / this.getCurrentScale());
            String currentText = this.field_2105.method_27523(this.field_2092.substring(this.field_2103), scaledInnerWidth);
            int offset = currentText.length() + this.field_2103;
            if (this.field_2101 == this.field_2103) {
                this.field_2103 -= this.field_2105.method_27524(this.field_2092, scaledInnerWidth, true).length();
            }
            if (this.field_2101 > offset) {
                this.field_2103 += this.field_2101 - offset;
            } else if (this.field_2101 <= this.field_2103) {
                this.field_2103 -= this.field_2103 - this.field_2101;
            }
            this.field_2103 = class_3532.method_15340((int)this.field_2103, (int)0, (int)valueLength);
        }
    }

    @Override
    public float getCurrentScale(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        return this.getCurrentScale();
    }

    public float getCurrentScale() {
        return this.scale;
    }
}

