/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.fabric.citresewn.pack.format;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertiesGroupAdapter;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyKey;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertySeparator;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyValue;

public abstract class PropertyGroup {
    public final Map<PropertyKey, Set<PropertyValue>> properties = new LinkedHashMap<PropertyKey, Set<PropertyValue>>();
    public final class_2960 identifier;
    public final String packName;

    protected PropertyGroup(String packName, class_2960 identifier) {
        this.packName = packName;
        this.identifier = identifier;
    }

    public static PropertyGroup tryParseGroup(String packName, class_2960 identifier, InputStream is) throws IOException {
        PropertiesGroupAdapter group = null;
        if (identifier.method_12832().endsWith(".properties")) {
            group = new PropertiesGroupAdapter(packName, identifier);
        }
        return group == null ? null : ((PropertyGroup)group).load(packName, identifier, is);
    }

    public abstract String getExtension();

    public abstract PropertyGroup load(String var1, class_2960 var2, InputStream var3) throws IOException, class_151;

    protected void put(int position, String packName, class_2960 propertiesIdentifier, String key, String keyMetadata, PropertySeparator separator, String value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.properties.computeIfAbsent(PropertyKey.of(key), id -> new LinkedHashSet()).add(new PropertyValue(keyMetadata, value, separator, position, propertiesIdentifier, packName));
    }

    public Set<PropertyValue> get(String namespace, String ... pathAliases) {
        LinkedHashSet<PropertyValue> values = new LinkedHashSet<PropertyValue>();
        for (String path : pathAliases) {
            Set<PropertyValue> possibleValues = this.properties.get(new PropertyKey(namespace, path));
            if (possibleValues == null) continue;
            values.addAll(possibleValues);
        }
        return values;
    }

    public PropertyValue getLastWithoutMetadata(String namespace, String ... pathAliases) {
        PropertyValue value = null;
        for (PropertyValue next : this.get(namespace, pathAliases)) {
            if (next.keyMetadata() != null) continue;
            value = next;
        }
        return value;
    }

    public PropertyValue getLastWithoutMetadataOrDefault(String defaultValue, String namespace, String ... pathAliases) {
        PropertyValue property = this.getLastWithoutMetadata(namespace, pathAliases);
        if (property == null) {
            property = new PropertyValue(null, defaultValue, PropertySeparator.EQUALS, -1, this.identifier, this.packName);
        }
        return property;
    }

    public String stripName() {
        return this.identifier.method_12832().substring(this.identifier.method_12832().lastIndexOf(47) + 1, this.identifier.method_12832().length() - this.getExtension().length());
    }

    public String messageWithDescriptorOf(String message, int position) {
        return message + (String)(position != -1 ? " @L" + position : "") + " in " + this.identifier.toString() + " from " + this.packName;
    }
}

