/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify;

import com.google.common.collect.ImmutableList;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.gamepad.GamepadController;
import dev.isxander.controlify.controller.joystick.CompoundJoystickController;
import dev.isxander.controlify.controller.joystick.SingleJoystickController;
import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.hid.ControllerHIDService;
import dev.isxander.controlify.hid.HIDDevice;
import dev.isxander.controlify.utils.DebugLog;
import dev.isxander.controlify.utils.Log;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import org.lwjgl.glfw.GLFW;

public final class ControllerManager {
    private static final Map<String, Controller<?, ?>> CONTROLLERS = new HashMap();

    private ControllerManager() {
    }

    public static Optional<Controller<?, ?>> createOrGet(int joystickId, ControllerHIDService.ControllerHIDInfo hidInfo) {
        try {
            Optional<String> uid = hidInfo.createControllerUID();
            if (uid.isPresent() && CONTROLLERS.containsKey(uid.get())) {
                return Optional.of(CONTROLLERS.get(uid.get()));
            }
            if (hidInfo.type().dontLoad()) {
                DebugLog.log("Preventing load of controller #" + joystickId + " because its type prevents loading.", new Object[0]);
                return Optional.empty();
            }
            if (GLFW.glfwJoystickIsGamepad((int)joystickId) && !DebugProperties.FORCE_JOYSTICK && !hidInfo.type().forceJoystick()) {
                GamepadController controller = new GamepadController(joystickId, hidInfo);
                CONTROLLERS.put(controller.uid(), controller);
                ControllerManager.checkCompoundJoysticks();
                return Optional.of(controller);
            }
            SingleJoystickController controller = new SingleJoystickController(joystickId, hidInfo);
            CONTROLLERS.put(controller.uid(), controller);
            ControllerManager.checkCompoundJoysticks();
            return Optional.of(controller);
        }
        catch (Throwable e) {
            class_128 crashReport = class_128.method_560((Throwable)e, (String)("Creating controller #" + joystickId));
            class_129 category = crashReport.method_562("Controller Info");
            category.method_578("Joystick ID", (Object)joystickId);
            category.method_578("Controller identification", (Object)hidInfo.type());
            category.method_578("HID path", (Object)hidInfo.hidDevice().map(HIDDevice::path).orElse("N/A"));
            category.method_578("HID service status", (Object)(Controlify.instance().controllerHIDService().isDisabled() ? "Disabled" : "Enabled"));
            category.method_578("GLFW name", (Object)Optional.ofNullable(GLFW.glfwGetJoystickName((int)joystickId)).orElse("N/A"));
            throw new class_148(crashReport);
        }
    }

    public static void disconnect(Controller<?, ?> controller) {
        controller.close();
        CONTROLLERS.remove(controller.uid(), controller);
        ControllerManager.checkCompoundJoysticks();
    }

    public static void disconnect(String uid) {
        Controller<?, ?> prev = CONTROLLERS.remove(uid);
        if (prev != null) {
            prev.close();
        }
        ControllerManager.checkCompoundJoysticks();
    }

    public static List<Controller<?, ?>> getConnectedControllers() {
        return ImmutableList.copyOf(CONTROLLERS.values());
    }

    public static boolean isControllerConnected(String uid) {
        return CONTROLLERS.containsKey(uid);
    }

    private static void checkCompoundJoysticks() {
        Controlify.instance().config().getCompoundJoysticks().values().forEach(info -> {
            try {
                if (info.isLoaded() && !info.canBeUsed()) {
                    Log.LOGGER.warn("Unloading compound joystick " + info.friendlyName() + " due to missing controllers.");
                    ControllerManager.disconnect(info.type().mappingId());
                }
                if (!info.isLoaded() && info.canBeUsed()) {
                    Log.LOGGER.info("Loading compound joystick " + info.type().mappingId() + ".");
                    CompoundJoystickController controller = info.attemptCreate().orElseThrow();
                    CONTROLLERS.put(info.type().mappingId(), controller);
                    Controlify.instance().config().loadOrCreateControllerData(controller);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

