/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.bindings;

import com.google.gson.JsonObject;
import dev.isxander.controlify.bindings.IBind;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.joystick.JoystickController;
import dev.isxander.controlify.controller.joystick.JoystickState;
import dev.isxander.controlify.controller.joystick.mapping.JoystickMapping;
import dev.isxander.controlify.controller.joystick.mapping.UnmappedJoystickMapping;
import dev.isxander.controlify.gui.DrawSize;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class JoystickAxisBind
implements IBind<JoystickState> {
    public static final String BIND_ID = "joystick_axis";
    private final JoystickController<?> joystick;
    private final int axisIndex;
    private final AxisDirection direction;

    public JoystickAxisBind(JoystickController<?> joystick, int axisIndex, AxisDirection direction) {
        this.joystick = joystick;
        this.axisIndex = axisIndex;
        this.direction = direction;
    }

    @Override
    public float state(JoystickState state) {
        Float rawState = state.axes().get(this.axisIndex);
        return switch (this.direction) {
            default -> throw new IncompatibleClassChangeError();
            case AxisDirection.POSITIVE -> Math.max(0.0f, rawState.floatValue());
            case AxisDirection.NEGATIVE -> -Math.min(0.0f, rawState.floatValue());
        };
    }

    @Override
    public void draw(class_332 graphics, int x, int centerY) {
        JoystickMapping mapping = this.joystick.mapping();
        String type = this.joystick.type().themeId();
        String axis = mapping.axes()[this.axisIndex].identifier();
        String direction = mapping.axes()[this.axisIndex].getDirectionIdentifier(this.axisIndex, this.direction);
        class_2960 texture = new class_2960("controlify", "textures/gui/joystick/" + type + "/axis_" + axis + "_" + direction + ".png");
        graphics.method_25290(texture, x, centerY - 11, 0.0f, 0.0f, 22, 22, 22, 22);
        if (mapping instanceof UnmappedJoystickMapping) {
            String text = Integer.toString(this.axisIndex + 1);
            class_327 font = class_310.method_1551().field_1772;
            Objects.requireNonNull(font);
            graphics.method_25300(font, text, x + 11, centerY - 9 / 2, 0xFFFFFF);
        }
    }

    @Override
    public DrawSize drawSize() {
        int width = 22;
        if (this.joystick.mapping() instanceof UnmappedJoystickMapping) {
            width = Math.max(width, class_310.method_1551().field_1772.method_1727(Integer.toString(this.axisIndex + 1)));
        }
        return new DrawSize(width, 22);
    }

    @Override
    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("type", BIND_ID);
        object.addProperty("axis", (Number)this.axisIndex);
        object.addProperty("direction", this.direction.name());
        return object;
    }

    @Override
    public Controller<JoystickState, ?> controller() {
        return this.joystick;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoystickAxisBind that = (JoystickAxisBind)o;
        return this.axisIndex == that.axisIndex && this.direction == that.direction;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.axisIndex, this.direction});
    }

    public static JoystickAxisBind fromJson(JsonObject object, JoystickController<?> joystick) {
        int axisIndex = object.get("axis").getAsInt();
        AxisDirection direction = AxisDirection.valueOf(object.get("direction").getAsString());
        return new JoystickAxisBind(joystick, axisIndex, direction);
    }

    public static enum AxisDirection {
        POSITIVE,
        NEGATIVE;

    }
}

