/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.bindings;

import com.google.gson.JsonObject;
import dev.isxander.controlify.bindings.IBind;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.joystick.JoystickController;
import dev.isxander.controlify.controller.joystick.JoystickState;
import dev.isxander.controlify.gui.DrawSize;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class JoystickHatBind
implements IBind<JoystickState> {
    public static final String BIND_ID = "joystick_hat";
    private final JoystickController<?> joystick;
    private final int hatIndex;
    private final JoystickState.HatState hatState;

    public JoystickHatBind(JoystickController<?> joystick, int hatIndex, JoystickState.HatState hatState) {
        this.joystick = joystick;
        this.hatIndex = hatIndex;
        this.hatState = hatState;
    }

    @Override
    public float state(JoystickState state) {
        return state.hats().get(this.hatIndex) == this.hatState ? 1.0f : 0.0f;
    }

    @Override
    public void draw(class_332 graphics, int x, int centerY) {
        String type = this.joystick.type().themeId();
        String hat = this.joystick.mapping().hats()[this.hatIndex].identifier();
        String direction = "centered";
        if (this.hatState.isUp()) {
            direction = "up";
        } else if (this.hatState.isDown()) {
            direction = "down";
        } else if (this.hatState.isLeft()) {
            direction = "left";
        } else if (this.hatState.isRight()) {
            direction = "right";
        }
        class_2960 texture = new class_2960("controlify", "textures/gui/joystick/" + type + "/hat" + hat + "_" + direction + ".png");
        graphics.method_25290(texture, x, centerY - 11, 0.0f, 0.0f, 22, 22, 22, 22);
    }

    @Override
    public DrawSize drawSize() {
        return new DrawSize(22, 22);
    }

    @Override
    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("type", BIND_ID);
        object.addProperty("hat", (Number)this.hatIndex);
        object.addProperty("state", this.hatState.name());
        return object;
    }

    @Override
    public Controller<JoystickState, ?> controller() {
        return this.joystick;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoystickHatBind that = (JoystickHatBind)o;
        return this.hatIndex == that.hatIndex && this.hatState == that.hatState && this.joystick.uid().equals(that.joystick.uid());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hatIndex, this.hatState, this.joystick.uid()});
    }

    public static JoystickHatBind fromJson(JsonObject object, JoystickController<?> joystick) {
        int hatIndex = object.get("hat").getAsInt();
        JoystickState.HatState hatState = JoystickState.HatState.valueOf(object.get("state").getAsString());
        return new JoystickHatBind(joystick, hatIndex, hatState);
    }
}

