/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;

public final class TypeAdapters {

    public static class VersionTypeAdapter
    implements JsonSerializer<Version>,
    JsonDeserializer<Version> {
        public JsonElement serialize(Version src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.getFriendlyString());
        }

        public Version deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return Version.parse((String)json.getAsString());
            }
            catch (VersionParsingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class ClassTypeAdapter
    implements JsonSerializer<Class<?>>,
    JsonDeserializer<Class<?>> {
        public Class<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return Class.forName(json.getAsString());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public JsonElement serialize(Class<?> src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.getName());
        }
    }
}

