/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.joystick;

import dev.isxander.controlify.controller.ControllerState;
import dev.isxander.controlify.controller.joystick.JoystickConfig;
import dev.isxander.controlify.controller.joystick.JoystickController;
import dev.isxander.controlify.controller.joystick.mapping.JoystickMapping;
import dev.isxander.controlify.controller.joystick.mapping.UnmappedJoystickMapping;
import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.utils.ControllerUtils;
import dev.isxander.controlify.utils.Log;
import dev.isxander.yacl3.api.NameableEnum;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_2561;
import org.lwjgl.glfw.GLFW;

public class JoystickState
implements ControllerState {
    public static final JoystickState EMPTY = new JoystickState(UnmappedJoystickMapping.EMPTY, List.of(), List.of(), List.of(), List.of());
    private final JoystickMapping mapping;
    private final List<Float> axes;
    private final List<Float> rawAxes;
    private final List<Boolean> buttons;
    private final List<HatState> hats;

    protected JoystickState(JoystickMapping mapping, List<Float> axes, List<Float> rawAxes, List<Boolean> buttons, List<HatState> hats) {
        this.mapping = mapping;
        this.axes = axes;
        this.rawAxes = rawAxes;
        this.buttons = buttons;
        this.hats = hats;
    }

    @Override
    public List<Float> axes() {
        return this.axes;
    }

    @Override
    public List<Float> rawAxes() {
        return this.rawAxes;
    }

    @Override
    public List<Boolean> buttons() {
        return this.buttons;
    }

    public List<HatState> hats() {
        return this.hats;
    }

    @Override
    public boolean hasAnyInput() {
        return IntStream.range(0, this.axes().size()).anyMatch(i -> !this.mapping.axes()[i].isAxisResting(this.axes().get(i).floatValue())) || this.buttons().stream().anyMatch(Boolean::booleanValue) || this.hats().stream().anyMatch(hat -> hat != HatState.CENTERED);
    }

    public String toString() {
        return "JoystickState{axes=" + this.axes + ", rawAxes=" + this.rawAxes + ", buttons=" + this.buttons + ", hats=" + this.hats + "}";
    }

    public static JoystickState fromJoystick(JoystickController<?> joystick, int joystickId) {
        Optional<FloatBuffer> axesBuffer = Optional.ofNullable(GLFW.glfwGetJoystickAxes((int)joystickId));
        float[] inAxes = new float[axesBuffer.map(Buffer::limit).orElse(0).intValue()];
        int i = 0;
        while (axesBuffer.isPresent() && axesBuffer.get().hasRemaining()) {
            inAxes[i] = axesBuffer.get().get();
            ++i;
        }
        Optional<ByteBuffer> buttonBuffer = Optional.ofNullable(GLFW.glfwGetJoystickButtons((int)joystickId));
        boolean[] inButtons = new boolean[buttonBuffer.map(Buffer::limit).orElse(0).intValue()];
        int i2 = 0;
        while (buttonBuffer.isPresent() && buttonBuffer.get().hasRemaining()) {
            inButtons[i2] = buttonBuffer.get().get() == 1;
            ++i2;
        }
        Optional<ByteBuffer> hatBuffer = Optional.ofNullable(GLFW.glfwGetJoystickHats((int)joystickId));
        HatState[] inHats = new HatState[hatBuffer.map(Buffer::limit).orElse(0).intValue()];
        int i3 = 0;
        while (hatBuffer.isPresent() && hatBuffer.get().hasRemaining()) {
            HatState state;
            inHats[i3] = state = (switch (hatBuffer.get().get()) {
                case 0 -> HatState.CENTERED;
                case 1 -> HatState.UP;
                case 2 -> HatState.RIGHT;
                case 4 -> HatState.DOWN;
                case 8 -> HatState.LEFT;
                case 3 -> HatState.RIGHT_UP;
                case 6 -> HatState.RIGHT_DOWN;
                case 9 -> HatState.LEFT_UP;
                case 12 -> HatState.LEFT_DOWN;
                default -> throw new IllegalStateException("Unexpected value: " + hatBuffer.get());
            });
        }
        JoystickMapping.JoystickData data = new JoystickMapping.JoystickData(inAxes, inButtons, inHats);
        JoystickMapping mapping = joystick.mapping();
        JoystickMapping.Axis[] axes = mapping.axes();
        ArrayList<Float> rawAxes = new ArrayList<Float>(axes.length);
        ArrayList<Float> deadzoneAxes = new ArrayList<Float>(axes.length);
        for (int i4 = 0; i4 < axes.length; ++i4) {
            JoystickMapping.Axis axis2 = axes[i4];
            float state = axis2.getAxis(data);
            rawAxes.add(Float.valueOf(state));
            deadzoneAxes.add(Float.valueOf(axis2.requiresDeadzone() ? ControllerUtils.deadzone(state, ((JoystickConfig)joystick.config()).getDeadzone(i4)) : state));
        }
        List<Boolean> buttons = Arrays.stream(mapping.buttons()).map(button -> button.isPressed(data)).toList();
        List<HatState> hats = Arrays.stream(mapping.hats()).map(hat -> hat.getHatState(data)).toList();
        if (DebugProperties.PRINT_JOY_STATE) {
            Log.LOGGER.info("Printing joystick state for controller {}", joystick);
            Log.LOGGER.info(Arrays.stream(axes).map(axis -> axis.name().getString() + ": " + axis.getAxis(data)).toList().toString());
            Log.LOGGER.info(Arrays.stream(mapping.buttons()).map(button -> button.name().getString() + ": " + button.isPressed(data)).toList().toString());
            Log.LOGGER.info(Arrays.stream(mapping.hats()).map(hat -> hat.name().getString() + ": " + hat.getHatState(data)).toList().toString());
        }
        return new JoystickState(joystick.mapping(), deadzoneAxes, rawAxes, buttons, hats);
    }

    public static JoystickState empty(JoystickController<?> joystick) {
        List<Float> axes = Arrays.stream(joystick.mapping().axes()).map(JoystickMapping.Axis::restingValue).toList();
        List<Boolean> buttons = IntStream.range(0, joystick.mapping().buttons().length).mapToObj(i -> false).toList();
        List<HatState> hats = IntStream.range(0, joystick.mapping().hats().length).mapToObj(i -> HatState.CENTERED).toList();
        return new JoystickState(joystick.mapping(), axes, axes, buttons, hats);
    }

    public static JoystickState merged(JoystickMapping mapping, Collection<JoystickState> states) {
        ArrayList<Float> axes = new ArrayList<Float>();
        ArrayList<Float> rawAxes = new ArrayList<Float>();
        ArrayList<Boolean> buttons = new ArrayList<Boolean>();
        ArrayList<HatState> hats = new ArrayList<HatState>();
        for (JoystickState state : states) {
            axes.addAll(state.axes);
            rawAxes.addAll(state.rawAxes);
            buttons.addAll(state.buttons);
            hats.addAll(state.hats);
        }
        return new JoystickState(mapping, axes, rawAxes, buttons, hats);
    }

    public static enum HatState implements NameableEnum
    {
        CENTERED,
        UP,
        RIGHT,
        DOWN,
        LEFT,
        RIGHT_UP,
        RIGHT_DOWN,
        LEFT_UP,
        LEFT_DOWN;


        public boolean isCentered() {
            return this == CENTERED;
        }

        public boolean isRight() {
            return this == RIGHT || this == RIGHT_UP || this == RIGHT_DOWN;
        }

        public boolean isUp() {
            return this == UP || this == RIGHT_UP || this == LEFT_UP;
        }

        public boolean isLeft() {
            return this == LEFT || this == LEFT_UP || this == LEFT_DOWN;
        }

        public boolean isDown() {
            return this == DOWN || this == RIGHT_DOWN || this == LEFT_DOWN;
        }

        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)("controlify.hat_state." + this.name().toLowerCase()));
        }
    }
}

