/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver;

import dev.isxander.controlify.controller.BatteryLevel;
import dev.isxander.controlify.controller.gamepad.GamepadState;
import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.driver.BasicGamepadInputDriver;
import dev.isxander.controlify.driver.BatteryDriver;
import dev.isxander.controlify.driver.GUIDProvider;
import dev.isxander.controlify.driver.GyroDriver;
import dev.isxander.controlify.driver.RumbleDriver;
import dev.isxander.controlify.utils.Log;
import net.minecraft.class_3532;
import org.libsdl.SDL;

public class SDL2GamepadDriver
implements BasicGamepadInputDriver,
GyroDriver,
RumbleDriver,
BatteryDriver,
GUIDProvider {
    private final long ptrGamepad;
    private BasicGamepadInputDriver.BasicGamepadState state = BasicGamepadInputDriver.BasicGamepadState.EMPTY;
    private GamepadState.GyroState gyroDelta = new GamepadState.GyroState(0.0f, 0.0f, 0.0f);
    private final boolean isGyroSupported;
    private final boolean isRumbleSupported;
    private final String guid;

    public SDL2GamepadDriver(int jid) {
        this.ptrGamepad = SDL.SDL_GameControllerOpen((int)jid);
        this.guid = SDL.SDL_JoystickGUIDString((long)SDL.SDL_GameControllerGetJoystick((long)this.ptrGamepad));
        this.isGyroSupported = SDL.SDL_GameControllerHasSensor((long)this.ptrGamepad, (int)2);
        this.isRumbleSupported = SDL.SDL_GameControllerHasRumble((long)this.ptrGamepad);
        if (this.isGyroSupported()) {
            SDL.SDL_GameControllerSetSensorEnabled((long)this.ptrGamepad, (int)2, (boolean)true);
        }
    }

    @Override
    public void update() {
        if (this.isGyroSupported()) {
            float[] gyro = new float[3];
            if (SDL.SDL_GameControllerGetSensorData((long)this.ptrGamepad, (int)2, (float[])gyro, (int)3) == 0) {
                this.gyroDelta = new GamepadState.GyroState(gyro[0], gyro[1], gyro[2]);
                if (DebugProperties.PRINT_GYRO) {
                    Log.LOGGER.info("Gyro delta: " + this.gyroDelta);
                }
            } else {
                Log.LOGGER.error("Could not get gyro data: " + SDL.SDL_GetError());
            }
        }
        SDL.SDL_GameControllerUpdate();
        GamepadState.AxesState axes = new GamepadState.AxesState(class_3532.method_37960((float)SDL.SDL_GameControllerGetAxis((long)this.ptrGamepad, (int)0), (float)-32768.0f, (float)32767.0f) * 2.0f - 1.0f, class_3532.method_37960((float)SDL.SDL_GameControllerGetAxis((long)this.ptrGamepad, (int)1), (float)-32768.0f, (float)32767.0f) * 2.0f - 1.0f, class_3532.method_37960((float)SDL.SDL_GameControllerGetAxis((long)this.ptrGamepad, (int)2), (float)-32768.0f, (float)32767.0f) * 2.0f - 1.0f, class_3532.method_37960((float)SDL.SDL_GameControllerGetAxis((long)this.ptrGamepad, (int)3), (float)-32768.0f, (float)32767.0f) * 2.0f - 1.0f, class_3532.method_37960((float)SDL.SDL_GameControllerGetAxis((long)this.ptrGamepad, (int)4), (float)0.0f, (float)32767.0f), class_3532.method_37960((float)SDL.SDL_GameControllerGetAxis((long)this.ptrGamepad, (int)5), (float)0.0f, (float)32767.0f));
        GamepadState.ButtonState buttons = new GamepadState.ButtonState(SDL.SDL_GameControllerGetButton((long)this.ptrGamepad, (int)0) == 1, SDL.SDL_GameControllerGetButton((long)this.ptrGamepad, (int)1) == 1, SDL.SDL_GameControllerGetButton((long)this.ptrGamepad, (int)2) == 1, SDL.SDL_GameControllerGetButton((long)this.ptrGamepad, (int)3) == 1, SDL.SDL_GameControllerGetButton((long)this.ptrGamepad, (int)9) == 1, SDL.SDL_GameControllerGetButton((long)this.ptrGamepad, (int)10) == 1, SDL.SDL_GameControllerGetButton((long)this.ptrGamepad, (int)4) == 1, SDL.SDL_GameControllerGetButton((long)this.ptrGamepad, (int)6) == 1, SDL.SDL_GameControllerGetButton((long)this.ptrGamepad, (int)5) == 1, SDL.SDL_GameControllerGetButton((long)this.ptrGamepad, (int)11) == 1, SDL.SDL_GameControllerGetButton((long)this.ptrGamepad, (int)12) == 1, SDL.SDL_GameControllerGetButton((long)this.ptrGamepad, (int)13) == 1, SDL.SDL_GameControllerGetButton((long)this.ptrGamepad, (int)14) == 1, SDL.SDL_GameControllerGetButton((long)this.ptrGamepad, (int)7) == 1, SDL.SDL_GameControllerGetButton((long)this.ptrGamepad, (int)8) == 1);
        this.state = new BasicGamepadInputDriver.BasicGamepadState(axes, buttons);
    }

    @Override
    public BasicGamepadInputDriver.BasicGamepadState getBasicGamepadState() {
        return this.state;
    }

    @Override
    public boolean rumble(float strongMagnitude, float weakMagnitude) {
        if (!SDL.SDL_GameControllerRumble((long)this.ptrGamepad, (int)((int)(strongMagnitude * 65535.0f)), (int)((int)(weakMagnitude * 65535.0f)), (int)0)) {
            Log.LOGGER.error("Could not rumble controller: " + SDL.SDL_GetError());
            return false;
        }
        return true;
    }

    @Override
    public GamepadState.GyroStateC getGyroState() {
        return this.gyroDelta;
    }

    @Override
    public BatteryLevel getBatteryLevel() {
        return switch (SDL.SDL_JoystickCurrentPowerLevel((long)this.ptrGamepad)) {
            case -1 -> BatteryLevel.UNKNOWN;
            case 0 -> BatteryLevel.EMPTY;
            case 1 -> BatteryLevel.LOW;
            case 2 -> BatteryLevel.MEDIUM;
            case 3 -> BatteryLevel.FULL;
            case 4 -> BatteryLevel.WIRED;
            case 5 -> BatteryLevel.MAX;
            default -> throw new IllegalStateException("Unexpected value: " + SDL.SDL_JoystickCurrentPowerLevel((long)this.ptrGamepad));
        };
    }

    @Override
    public boolean isGyroSupported() {
        return this.isGyroSupported;
    }

    @Override
    public boolean isRumbleSupported() {
        return this.isRumbleSupported;
    }

    @Override
    public String getGUID() {
        return this.guid;
    }

    @Override
    public void close() {
        SDL.SDL_GameControllerClose((long)this.ptrGamepad);
    }

    @Override
    public String getGyroDetails() {
        return "SDL2gp supported=" + this.isGyroSupported();
    }

    @Override
    public String getRumbleDetails() {
        return "SDL2gp supported=" + this.isRumbleSupported();
    }

    @Override
    public String getBatteryDriverDetails() {
        return "SDL2gp";
    }

    @Override
    public String getGUIDProviderDetails() {
        return "SDL2gp";
    }

    @Override
    public String getBasicGamepadDetails() {
        return "SDL2gp";
    }
}

