/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver;

import dev.isxander.controlify.driver.RumbleDriver;
import dev.isxander.controlify.utils.Log;
import org.libsdl.SDL;

public class SDL2JoystickDriver
implements RumbleDriver {
    private final long ptrJoystick;
    private final boolean isRumbleSupported;

    public SDL2JoystickDriver(int jid) {
        this.ptrJoystick = SDL.SDL_JoystickOpen((int)jid);
        this.isRumbleSupported = SDL.SDL_JoystickHasRumble((long)this.ptrJoystick);
    }

    @Override
    public void update() {
    }

    @Override
    public boolean rumble(float strongMagnitude, float weakMagnitude) {
        if (!SDL.SDL_JoystickRumble((long)this.ptrJoystick, (int)((int)(strongMagnitude * 65535.0f)), (int)((int)(weakMagnitude * 65535.0f)), (int)0)) {
            Log.LOGGER.error("Could not rumble controller: " + SDL.SDL_GetError());
            return false;
        }
        return true;
    }

    @Override
    public boolean isRumbleSupported() {
        return this.isRumbleSupported;
    }

    @Override
    public String getRumbleDetails() {
        return "SDL2joy supported=" + this.isRumbleSupported();
    }

    @Override
    public void close() {
        SDL.SDL_JoystickClose((long)this.ptrJoystick);
    }
}

