/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.controllers;

import dev.isxander.controlify.bindings.IBind;
import dev.isxander.controlify.bindings.JoystickAxisBind;
import dev.isxander.controlify.bindings.JoystickButtonBind;
import dev.isxander.controlify.bindings.JoystickHatBind;
import dev.isxander.controlify.controller.joystick.JoystickConfig;
import dev.isxander.controlify.controller.joystick.JoystickController;
import dev.isxander.controlify.controller.joystick.JoystickState;
import dev.isxander.controlify.gui.controllers.AbstractBindController;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.YACLScreen;
import java.util.Optional;

public class JoystickBindController
extends AbstractBindController<JoystickState> {
    public JoystickBindController(Option<IBind<JoystickState>> option, JoystickController<?> controller) {
        super(option, controller);
    }

    @Override
    public AbstractBindController.AbstractBindControllerElement<JoystickState> provideWidget(YACLScreen yaclScreen, Dimension<Integer> dimension) {
        return new BindButtonWidget(this, yaclScreen, dimension);
    }

    public static class BindButtonWidget
    extends AbstractBindController.AbstractBindControllerElement<JoystickState> {
        public BindButtonWidget(JoystickBindController control, YACLScreen screen, Dimension<Integer> dim) {
            super(control, screen, dim);
        }

        @Override
        public Optional<IBind<JoystickState>> getPressedBind() {
            int i;
            JoystickController joystick = (JoystickController)((AbstractBindController)this.control).controller;
            JoystickState state = (JoystickState)joystick.state();
            JoystickState prevState = (JoystickState)joystick.prevState();
            for (i = 0; i < Math.min(state.buttons().size(), prevState.buttons().size()); ++i) {
                if (!state.buttons().get(i).booleanValue() || prevState.buttons().get(i).booleanValue()) continue;
                return Optional.of(new JoystickButtonBind(joystick, i));
            }
            for (i = 0; i < Math.min(state.axes().size(), prevState.axes().size()); ++i) {
                Float axis = state.axes().get(i);
                Float prevAxis = prevState.axes().get(i);
                float activationThreshold = ((JoystickConfig)joystick.config()).buttonActivationThreshold;
                if (!(Math.abs(prevAxis.floatValue()) < activationThreshold)) continue;
                if (axis.floatValue() > activationThreshold) {
                    return Optional.of(new JoystickAxisBind(joystick, i, JoystickAxisBind.AxisDirection.POSITIVE));
                }
                if (!(axis.floatValue() < -activationThreshold)) continue;
                return Optional.of(new JoystickAxisBind(joystick, i, JoystickAxisBind.AxisDirection.NEGATIVE));
            }
            for (i = 0; i < Math.min(state.hats().size(), prevState.hats().size()); ++i) {
                JoystickState.HatState hat = state.hats().get(i);
                JoystickState.HatState prevHat = prevState.hats().get(i);
                if (!prevHat.isCentered() || hat.isCentered()) continue;
                return Optional.of(new JoystickHatBind(joystick, i, hat));
            }
            return Optional.empty();
        }
    }
}

