/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.layout;

import dev.isxander.controlify.gui.layout.RenderComponent;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractLayoutComponent<T extends RenderComponent>
implements RenderComponent {
    private final List<T> components = new ArrayList<T>();

    public List<T> getChildComponents() {
        return this.components;
    }

    public <U extends T> U insertTop(U area) {
        this.components.add(area);
        return area;
    }

    public <U extends T> U insertBottom(U area) {
        this.components.add(0, area);
        return area;
    }

    public <U extends T> U insertAbove(U area, T above) {
        int index = this.components.indexOf(above);
        if (index == -1) {
            throw new IllegalArgumentException("InteractionArea " + above + " is not registered!");
        }
        this.components.add(index + 1, area);
        return area;
    }

    public <U extends T> U insertBelow(U area, T below) {
        int index = this.components.indexOf(below);
        if (index == -1) {
            throw new IllegalArgumentException("InteractionArea " + below + " is not registered!");
        }
        this.components.add(index, area);
        return area;
    }
}

