/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.ControllerBinding;
import dev.isxander.controlify.bindings.BindContext;
import dev.isxander.controlify.bindings.EmptyBind;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.ControllerConfig;
import dev.isxander.controlify.controller.gamepad.GamepadConfig;
import dev.isxander.controlify.controller.gamepad.GamepadController;
import dev.isxander.controlify.controller.joystick.JoystickConfig;
import dev.isxander.controlify.controller.joystick.SingleJoystickController;
import dev.isxander.controlify.controller.joystick.mapping.JoystickMapping;
import dev.isxander.controlify.driver.SteamDeckDriver;
import dev.isxander.controlify.gui.controllers.AbstractBindController;
import dev.isxander.controlify.gui.guide.InGameButtonGuide;
import dev.isxander.controlify.gui.screen.ControllerCalibrationScreen;
import dev.isxander.controlify.gui.screen.RadialMenuScreen;
import dev.isxander.controlify.rumble.BasicRumbleEffect;
import dev.isxander.controlify.rumble.RumbleSource;
import dev.isxander.controlify.rumble.RumbleState;
import dev.isxander.controlify.server.ServerPolicies;
import dev.isxander.controlify.server.ServerPolicy;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public class ControllerConfigScreenFactory {
    private static final Function<Float, class_2561> percentFormatter = v -> class_2561.method_43470((String)String.format("%.0f%%", Float.valueOf(v.floatValue() * 100.0f)));
    private static final Function<Float, class_2561> percentOrOffFormatter = v -> v.floatValue() == 0.0f ? class_5244.field_24333 : percentFormatter.apply((Float)v);
    private static final class_2561 newOptionLabel = class_2561.method_43471((String)"controlify.gui.new_options.label").method_27692(class_124.field_1065);
    private final List<Option<?>> newOptions = new ArrayList();

    public static class_437 generateConfigScreen(class_437 parent, Controller<?, ?> controller) {
        return new ControllerConfigScreenFactory().generateConfigScreen0(parent, controller);
    }

    private class_437 generateConfigScreen0(class_437 parent, Controller<?, ?> controller) {
        Object def = controller.defaultConfig();
        Object config = controller.config();
        ConfigCategory advancedCategory = this.createAdvancedCategory(controller);
        ConfigCategory bindsCategory = this.createBindsCategory(controller);
        ConfigCategory basicCategory = this.createBasicCategory(controller, (ControllerConfig)def, (ControllerConfig)config);
        return YetAnotherConfigLib.createBuilder().title((class_2561)class_2561.method_43470((String)"Controlify")).category(basicCategory).category(advancedCategory).category(bindsCategory).save(() -> Controlify.instance().config().save()).build().generateScreen(parent);
    }

    private ConfigCategory createBasicCategory(Controller<?, ?> controller, ControllerConfig def, ControllerConfig config) {
        OptionGroup sensitivityGroup = this.makeSensitivityGroup(controller, def, config);
        OptionGroup controlsGroup = this.makeControlsGroup(controller, def, config);
        OptionGroup accessibilityGroup = this.makeAccessibilityGroup(controller, def, config);
        OptionGroup deadzoneGroup = this.makeDeadzoneGroup(controller, def, config);
        ConfigCategory.Builder builder = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.config.category.basic")).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.custom_name")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"controlify.gui.custom_name.tooltip")})).binding((Object)(def.customName == null ? "" : def.customName), () -> config.customName == null ? "" : config.customName, v -> {
            config.customName = v.equals("") ? null : v;
        }).controller(StringControllerBuilder::create).build());
        if (!this.newOptions.isEmpty()) {
            builder.group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.new_options").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"controlify.gui.new_options.tooltip")})).options(this.newOptions).build());
        }
        builder.group(sensitivityGroup).group(controlsGroup).group(accessibilityGroup).group(deadzoneGroup);
        return builder.build();
    }

    private OptionGroup makeSensitivityGroup(Controller<?, ?> controller, ControllerConfig def, ControllerConfig config) {
        return OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.config.group.sensitivity")).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.horizontal_look_sensitivity")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.horizontal_look_sensitivity.tooltip")}).build()).binding((Object)Float.valueOf(def.horizontalLookSensitivity), () -> Float.valueOf(config.horizontalLookSensitivity), v -> {
            config.horizontalLookSensitivity = v.floatValue();
        }).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.1f), (Number)Float.valueOf(2.0f))).step((Number)Float.valueOf(0.05f))).valueFormatter(percentFormatter)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.vertical_look_sensitivity")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.vertical_look_sensitivity.tooltip")}).build()).binding((Object)Float.valueOf(def.verticalLookSensitivity), () -> Float.valueOf(config.verticalLookSensitivity), v -> {
            config.verticalLookSensitivity = v.floatValue();
        }).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.1f), (Number)Float.valueOf(2.0f))).step((Number)Float.valueOf(0.05f))).valueFormatter(percentFormatter)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.vmouse_sensitivity")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.vmouse_sensitivity.tooltip")}).build()).binding((Object)Float.valueOf(def.virtualMouseSensitivity), () -> Float.valueOf(config.virtualMouseSensitivity), v -> {
            config.virtualMouseSensitivity = v.floatValue();
        }).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.1f), (Number)Float.valueOf(2.0f))).step((Number)Float.valueOf(0.05f))).valueFormatter(percentFormatter)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.reduce_aiming_sensitivity")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.reduce_aiming_sensitivity.tooltip")}).webpImage(ControllerConfigScreenFactory.screenshot("reduce-aim-sensitivity.webp")).build()).binding((Object)def.reduceAimingSensitivity, () -> config.reduceAimingSensitivity, v -> {
            config.reduceAimingSensitivity = v;
        }).controller(TickBoxControllerBuilder::create).build()).build();
    }

    private OptionGroup makeControlsGroup(Controller<?, ?> controller, ControllerConfig def, ControllerConfig config) {
        Function<Boolean, class_2561> holdToggleFormatter = v -> class_2561.method_43471((String)("controlify.gui.format.hold_toggle." + (v != false ? "toggle" : "hold")));
        return OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.config.group.controls")).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.toggle_sprint")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.toggle_sprint.tooltip")}).build()).binding((Object)def.toggleSprint, () -> config.toggleSprint, v -> {
            config.toggleSprint = v;
        }).controller(opt -> ((BooleanControllerBuilder)BooleanControllerBuilder.create((Option)opt).valueFormatter(holdToggleFormatter)).coloured(false)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.toggle_sneak")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.toggle_sneak.tooltip")}).build()).binding((Object)def.toggleSneak, () -> config.toggleSneak, v -> {
            config.toggleSneak = v;
        }).controller(opt -> ((BooleanControllerBuilder)BooleanControllerBuilder.create((Option)opt).valueFormatter(holdToggleFormatter)).coloured(false)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.auto_jump")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.auto_jump.tooltip")}).build()).binding((Object)def.autoJump, () -> config.autoJump, v -> {
            config.autoJump = v;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).onOffFormatter()).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.no_fly_drifting")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.no_fly_drifting.tooltip")}).text(new class_2561[]{ServerPolicies.DISABLE_FLY_DRIFTING.get() != ServerPolicy.UNSET ? class_2561.method_43471((String)"controlify.gui.server_controlled").method_27692(class_124.field_1065) : class_2561.method_43473()}).build()).binding((Object)def.disableFlyDrifting, () -> ServerPolicies.DISABLE_FLY_DRIFTING.get().isAllowed() && config.disableFlyDrifting, v -> {
            config.disableFlyDrifting = v;
        }).controller(TickBoxControllerBuilder::create).available(ServerPolicies.DISABLE_FLY_DRIFTING.get().isAllowed()).build()).build();
    }

    private OptionGroup makeAccessibilityGroup(Controller<?, ?> controller, ControllerConfig def, ControllerConfig config) {
        return OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.config.group.accessibility")).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.show_ingame_guide")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.show_ingame_guide.tooltip")}).image(ControllerConfigScreenFactory.screenshot("ingame-button-guide.png"), 961, 306).build()).binding((Object)def.showIngameGuide, () -> config.showIngameGuide, v -> {
            config.showIngameGuide = v;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.ingame_button_guide_position")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"controlify.gui.ingame_button_guide_position.tooltip")})).binding((Object)def.ingameGuideBottom, () -> config.ingameGuideBottom, v -> {
            config.ingameGuideBottom = v;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).valueFormatter(v -> class_2561.method_43471((String)(v != false ? "controlify.gui.format.bottom" : "controlify.gui.format.top")))).flag(new OptionFlag[]{mc -> Controlify.instance().inGameButtonGuide().ifPresent(InGameButtonGuide::refreshLayout)}).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.show_screen_guide")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.show_screen_guide.tooltip")}).webpImage(ControllerConfigScreenFactory.screenshot("screen-button-guide.webp")).build()).binding((Object)def.showScreenGuide, () -> config.showScreenGuide, v -> {
            config.showScreenGuide = v;
        }).controller(TickBoxControllerBuilder::create).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.chat_screen_offset")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.chat_screen_offset.tooltip")}).build()).binding((Object)Float.valueOf(def.chatKeyboardHeight), () -> Float.valueOf(config.chatKeyboardHeight), v -> {
            config.chatKeyboardHeight = v.floatValue();
        }).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(8.0f))).step((Number)Float.valueOf(0.1f))).valueFormatter(percentFormatter)).build()).build();
    }

    private OptionGroup makeDeadzoneGroup(Controller<?, ?> controller, ControllerConfig def, ControllerConfig config) {
        ArrayList<Option> deadzoneOpts = new ArrayList<Option>();
        OptionGroup.Builder group = OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.config.group.deadzones"));
        if (controller instanceof GamepadController) {
            GamepadController gamepad = (GamepadController)controller;
            GamepadConfig gpCfg = (GamepadConfig)gamepad.config();
            GamepadConfig gpCfgDef = (GamepadConfig)gamepad.defaultConfig();
            Option left = Option.createBuilder().name((class_2561)class_2561.method_43469((String)"controlify.gui.axis_deadzone", (Object[])new Object[]{class_2561.method_43471((String)"controlify.gui.left_stick")})).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43469((String)"controlify.gui.axis_deadzone.tooltip", (Object[])new Object[]{class_2561.method_43471((String)"controlify.gui.left_stick")})}).text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.stickdrift_warning").method_27692(class_124.field_1061)}).build()).binding((Object)Float.valueOf(gpCfgDef.getLeftStickDeadzone()), gpCfg::getLeftStickDeadzone, gpCfg::setLeftStickDeadzone).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f))).step((Number)Float.valueOf(0.01f))).valueFormatter(percentFormatter)).build();
            Option right = Option.createBuilder().name((class_2561)class_2561.method_43469((String)"controlify.gui.axis_deadzone", (Object[])new Object[]{class_2561.method_43471((String)"controlify.gui.right_stick")})).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43469((String)"controlify.gui.axis_deadzone.tooltip", (Object[])new Object[]{class_2561.method_43471((String)"controlify.gui.right_stick")})}).text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.stickdrift_warning").method_27692(class_124.field_1061)}).build()).binding((Object)Float.valueOf(gpCfgDef.getRightStickDeadzone()), gpCfg::getRightStickDeadzone, gpCfg::setRightStickDeadzone).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f))).step((Number)Float.valueOf(0.01f))).valueFormatter(percentFormatter)).build();
            group.option(left);
            group.option(right);
            deadzoneOpts.add(left);
            deadzoneOpts.add(right);
        } else if (controller instanceof SingleJoystickController) {
            SingleJoystickController joystick = (SingleJoystickController)controller;
            JoystickMapping.Axis[] axes = joystick.mapping().axes();
            Collection deadzoneAxes = IntStream.range(0, axes.length).filter(i -> axes[i].requiresDeadzone()).boxed().collect(Collectors.toMap(i -> axes[i].identifier(), i -> i, (x, y) -> x, LinkedHashMap::new)).values();
            JoystickConfig jsCfg = (JoystickConfig)joystick.config();
            JoystickConfig jsCfgDef = (JoystickConfig)joystick.defaultConfig();
            Iterator iterator = deadzoneAxes.iterator();
            while (iterator.hasNext()) {
                int i2 = (Integer)iterator.next();
                JoystickMapping.Axis axis = axes[i2];
                Option deadzoneOpt = Option.createBuilder().name((class_2561)class_2561.method_43469((String)"controlify.gui.axis_deadzone", (Object[])new Object[]{axis.name()})).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43469((String)"controlify.gui.axis_deadzone.tooltip", (Object[])new Object[]{axis.name()})}).text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.stickdrift_warning").method_27692(class_124.field_1061)}).build()).binding((Object)Float.valueOf(jsCfgDef.getDeadzone(i2)), () -> Float.valueOf(jsCfg.getDeadzone(i2)), v -> jsCfg.setDeadzone(i2, v.floatValue())).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f))).step((Number)Float.valueOf(0.01f))).valueFormatter(percentFormatter)).build();
                group.option(deadzoneOpt);
                deadzoneOpts.add(deadzoneOpt);
            }
        }
        group.option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.button_activation_threshold")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.button_activation_threshold.tooltip")}).build()).binding((Object)Float.valueOf(def.buttonActivationThreshold), () -> Float.valueOf(config.buttonActivationThreshold), v -> {
            config.buttonActivationThreshold = v.floatValue();
        }).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f))).step((Number)Float.valueOf(0.01f))).valueFormatter(percentFormatter)).build());
        group.option((Option)ButtonOption.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.auto_calibration")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.auto_calibration.tooltip")}).build()).action((screen, button) -> class_310.method_1551().method_1507((class_437)new ControllerCalibrationScreen(controller, () -> {
            deadzoneOpts.forEach(Option::forgetPendingValue);
            return screen;
        }))).build());
        return group.build();
    }

    private ConfigCategory createAdvancedCategory(Controller<?, ?> controller) {
        return ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.config.category.advanced")).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.mixed_input")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"controlify.gui.mixed_input.tooltip")})).binding((Object)((ControllerConfig)controller.defaultConfig()).mixedInput, () -> ((ControllerConfig)controller.config()).mixedInput, v -> {
            ((ControllerConfig)controller.config()).mixedInput = v;
        }).controller(TickBoxControllerBuilder::create).build()).group(this.makeVibrationGroup(controller)).group(this.makeGyroGroup(controller)).build();
    }

    private ConfigCategory createBindsCategory(Controller<?, ?> controller) {
        ConfigCategory.Builder category = ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.group.controls"));
        ArrayList<OptionBindPair> optionBinds = new ArrayList<OptionBindPair>();
        ButtonOption editRadialButton = ButtonOption.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.radial_menu").method_27692(class_124.field_1065)).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.radial_menu.tooltip")}).text(new class_2561[]{newOptionLabel}).build()).action((screen, opt) -> class_310.method_1551().method_1507((class_437)new RadialMenuScreen(controller, true, (class_437)screen))).text((class_2561)class_2561.method_43471((String)"controlify.gui.radial_menu.btn_text")).build();
        this.newOptions.add((Option<?>)editRadialButton);
        Option radialBind = controller.bindings().RADIAL_MENU.startYACLOption().listener((opt, val) -> this.updateConflictingBinds(optionBinds)).build();
        optionBinds.add(new OptionBindPair(radialBind, controller.bindings().RADIAL_MENU));
        category.option((Option)editRadialButton);
        category.option(radialBind);
        ControllerConfigScreenFactory.groupBindings(controller.bindings().registry().values()).forEach((categoryName, bindGroup) -> {
            OptionGroup.Builder controlsGroup = OptionGroup.createBuilder().name(categoryName);
            controlsGroup.options(bindGroup.stream().map(binding -> {
                Option.Builder option = binding.startYACLOption().listener((opt, val) -> this.updateConflictingBinds(optionBinds));
                Option built = option.build();
                optionBinds.add(new OptionBindPair((Option<?>)built, (ControllerBinding)binding));
                return built;
            }).toList());
            category.group(controlsGroup.build());
        });
        this.updateConflictingBinds(optionBinds);
        return category.build();
    }

    private void updateConflictingBinds(List<OptionBindPair> all) {
        all.forEach(pair -> ((AbstractBindController)pair.option().controller()).setConflicting(false));
        for (OptionBindPair opt : all) {
            Set<class_2960> ctxs = BindContext.flatten(opt.binding().contexts());
            List<OptionBindPair> conflicting = all.stream().filter(pair -> pair.binding() != opt.binding()).filter(pair -> {
                boolean contextsMatch = BindContext.flatten(pair.binding().contexts()).stream().anyMatch(ctxs::contains);
                boolean bindMatches = pair.option().pendingValue().equals(opt.option().pendingValue());
                boolean bindIsNotEmpty = !(pair.option().pendingValue() instanceof EmptyBind);
                return contextsMatch && bindMatches && bindIsNotEmpty;
            }).toList();
            conflicting.forEach(conflict -> ((AbstractBindController)conflict.option().controller()).setConflicting(true));
        }
    }

    private OptionGroup makeVibrationGroup(Controller<?, ?> controller) {
        boolean canRumble = controller.supportsRumble();
        Object config = controller.config();
        Object def = controller.defaultConfig();
        OptionGroup.Builder vibrationGroup = OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.group.vibration")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.group.vibration.tooltip")}).build());
        if (canRumble) {
            ArrayList<Option> strengthOptions = new ArrayList<Option>();
            Option allowVibrationOption = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.allow_vibrations")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.allow_vibrations.tooltip")}).build()).binding((Object)((ControllerConfig)def).allowVibrations, () -> config.allowVibrations, v -> {
                config.allowVibrations = v;
            }).listener((opt, allowVibration) -> strengthOptions.forEach(so -> so.setAvailable(allowVibration.booleanValue()))).controller(TickBoxControllerBuilder::create).build();
            vibrationGroup.option(allowVibrationOption);
            for (RumbleSource source : RumbleSource.values()) {
                Option option = Option.createBuilder().name((class_2561)class_2561.method_43471((String)("controlify.vibration_strength." + source.id().method_12836() + "." + source.id().method_12832()))).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)("controlify.vibration_strength." + source.id().method_12836() + "." + source.id().method_12832() + ".tooltip"))}).build()).binding((Object)Float.valueOf(((ControllerConfig)def).getRumbleStrength(source)), () -> Float.valueOf(config.getRumbleStrength(source)), v -> config.setRumbleStrength(source, v.floatValue())).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(2.0f))).step((Number)Float.valueOf(0.05f))).valueFormatter(percentOrOffFormatter)).available(((Boolean)allowVibrationOption.pendingValue()).booleanValue()).build();
                strengthOptions.add(option);
                vibrationGroup.option(option);
            }
            vibrationGroup.option((Option)ButtonOption.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.test_vibration")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"controlify.gui.test_vibration.tooltip")})).action((screen, btn) -> controller.rumbleManager().play(RumbleSource.MASTER, BasicRumbleEffect.byTime(t -> new RumbleState(0.0f, t.floatValue()), 20).join(BasicRumbleEffect.byTime(t -> new RumbleState(0.0f, 1.0f - t.floatValue()), 20)).repeat(3).join(BasicRumbleEffect.constant(1.0f, 0.0f, 5).join(BasicRumbleEffect.constant(0.0f, 1.0f, 5)).repeat(10)).earlyFinish(BasicRumbleEffect.finishOnScreenChange()))).build());
        } else {
            vibrationGroup.option((Option)LabelOption.create((class_2561)class_2561.method_43471((String)"controlify.gui.allow_vibrations.not_available").method_27692(class_124.field_1061)));
        }
        return vibrationGroup.build();
    }

    private OptionGroup makeGyroGroup(Controller<?, ?> controller) {
        GamepadController gamepad = controller instanceof GamepadController ? (GamepadController)controller : null;
        boolean hasGyro = gamepad != null && gamepad.hasGyro();
        GamepadConfig gpCfg = gamepad != null ? (GamepadConfig)gamepad.config() : null;
        GamepadConfig gpCfgDef = gamepad != null ? (GamepadConfig)gamepad.defaultConfig() : null;
        ArrayList gyroOptions = new ArrayList();
        OptionGroup.Builder gyroGroup = OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.group.gyro")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.group.gyro.tooltip")}).build()).collapsed(!hasGyro);
        if (hasGyro) {
            Option gyroSensitivity = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.gyro_look_sensitivity")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.gyro_look_sensitivity.tooltip")}).build()).binding((Object)Float.valueOf(gpCfgDef.gyroLookSensitivity), () -> Float.valueOf(gpCfg.gyroLookSensitivity), v -> {
                gpCfg.gyroLookSensitivity = v.floatValue();
            }).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(3.0f))).step((Number)Float.valueOf(0.1f))).valueFormatter(percentOrOffFormatter)).listener((opt, sensitivity) -> gyroOptions.forEach(o -> {
                o.setAvailable(sensitivity.floatValue() > 0.0f);
                o.requestSetDefault();
            })).build();
            gyroGroup.option(gyroSensitivity);
            Option relativeModeOpt = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.gyro_behaviour")).description(val -> OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.gyro_behaviour.tooltip")}).text(new class_2561[]{val != false ? class_2561.method_43471((String)"controlify.gui.gyro_behaviour.relative.tooltip") : class_2561.method_43471((String)"controlify.gui.gyro_behaviour.absolute.tooltip")}).build()).binding((Object)gpCfgDef.relativeGyroMode, () -> gpCfg.relativeGyroMode, v -> {
                gpCfg.relativeGyroMode = v;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).valueFormatter(v -> v != false ? class_2561.method_43471((String)"controlify.gui.gyro_behaviour.relative") : class_2561.method_43471((String)"controlify.gui.gyro_behaviour.absolute"))).build();
            gyroGroup.option(relativeModeOpt);
            gyroGroup.option((Option)class_156.method_656(() -> {
                Option opt = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.gyro_invert_x")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"controlify.gui.gyro_invert_x.tooltip")})).binding((Object)gpCfgDef.invertGyroX, () -> gpCfg.invertGyroX, v -> {
                    gpCfg.invertGyroX = v;
                }).controller(TickBoxControllerBuilder::create).build();
                gyroOptions.add(opt);
                return opt;
            }));
            gyroGroup.option((Option)class_156.method_656(() -> {
                Option opt = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.gyro_invert_y")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"controlify.gui.gyro_invert_y.tooltip")})).binding((Object)gpCfgDef.invertGyroY, () -> gpCfg.invertGyroY, v -> {
                    gpCfg.invertGyroY = v;
                }).controller(TickBoxControllerBuilder::create).build();
                gyroOptions.add(opt);
                return opt;
            }));
            gyroGroup.option((Option)class_156.method_656(() -> {
                Option opt = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.gyro_requires_button")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.gyro_requires_button.tooltip")}).build()).binding((Object)gpCfgDef.gyroRequiresButton, () -> gpCfg.gyroRequiresButton, v -> {
                    gpCfg.gyroRequiresButton = v;
                }).controller(TickBoxControllerBuilder::create).available(((Float)gyroSensitivity.pendingValue()).floatValue() > 0.0f).listener((o, val) -> {
                    if (val.booleanValue()) {
                        relativeModeOpt.setAvailable(((Float)gyroSensitivity.pendingValue()).floatValue() > 0.0f);
                    } else {
                        relativeModeOpt.setAvailable(false);
                        relativeModeOpt.requestSet((Object)false);
                    }
                }).build();
                gyroOptions.add(opt);
                return opt;
            }));
            gyroGroup.option((Option)class_156.method_656(() -> {
                Option opt = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"controlify.gui.flick_stick")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"controlify.gui.flick_stick.tooltip")}).build()).binding((Object)gpCfgDef.flickStick, () -> gpCfg.flickStick, v -> {
                    gpCfg.flickStick = v;
                }).controller(TickBoxControllerBuilder::create).available(((Float)gyroSensitivity.pendingValue()).floatValue() > 0.0f).build();
                gyroOptions.add(opt);
                return opt;
            }));
        } else {
            boolean isSteamDeck = gamepad != null && gamepad.hidInfo().map(hid -> hid.hidDevice().map(d -> SteamDeckDriver.isSteamDeck(d.vendorID(), d.productID())).orElse(false)).orElse(false) != false;
            gyroGroup.option((Option)LabelOption.create((class_2561)class_2561.method_43471((String)(!isSteamDeck ? "controlify.gui.group.gyro.no_gyro.tooltip" : "controlify.gui.group.gyro.no_gyro_steamdeck.tooltip")).method_27692(class_124.field_1061)));
        }
        return gyroGroup.build();
    }

    private static Map<class_2561, List<ControllerBinding>> groupBindings(Collection<ControllerBinding> bindings) {
        return bindings.stream().collect(Collectors.groupingBy(ControllerBinding::category, LinkedHashMap::new, Collectors.toList()));
    }

    private static class_2960 screenshot(String filename) {
        return Controlify.id("textures/screenshots/" + filename);
    }

    private record OptionBindPair(Option<?> option, ControllerBinding binding) {
    }
}

