/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.rumble;

import dev.isxander.controlify.rumble.RumbleCapable;
import dev.isxander.controlify.rumble.RumbleEffect;
import dev.isxander.controlify.rumble.RumbleSource;
import dev.isxander.controlify.rumble.RumbleState;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class RumbleManager {
    private final RumbleCapable controller;
    private final Queue<RumbleEffectInstance> effectQueue;
    private boolean silent;
    private boolean wasSilent;

    public RumbleManager(RumbleCapable controller) {
        this.controller = controller;
        this.effectQueue = new PriorityQueue<RumbleEffectInstance>(Comparator.comparing(RumbleEffectInstance::effect));
    }

    @Deprecated
    public void play(RumbleEffect effect) {
        this.play(RumbleSource.MASTER, effect);
    }

    public void play(RumbleSource source, RumbleEffect effect) {
        if (!this.controller.supportsRumble()) {
            return;
        }
        this.effectQueue.add(new RumbleEffectInstance(source, effect));
    }

    public void tick() {
        this.effectQueue.removeIf(e -> e.effect().isFinished());
        this.effectQueue.forEach(e -> e.effect().tick());
        if (this.effectQueue.isEmpty()) {
            this.clearRumble();
            return;
        }
        float strong = 0.0f;
        float weak = 0.0f;
        for (RumbleEffectInstance effect : this.effectQueue) {
            RumbleState effectState = this.controller.applyRumbleSourceStrength(effect.effect().currentState(), effect.source());
            strong = Math.max(strong, effectState.strong());
            weak = Math.max(weak, effectState.weak());
        }
        RumbleState state = new RumbleState(strong, weak);
        if (state.isZero()) {
            this.clearRumble();
            return;
        }
        if (this.silent) {
            this.clearRumble();
        } else {
            this.controller.setRumble(state.strong(), state.weak());
            this.wasSilent = false;
        }
    }

    private void clearRumble() {
        if (this.wasSilent) {
            return;
        }
        this.controller.setRumble(0.0f, 0.0f);
        this.wasSilent = true;
    }

    public void clearEffects() {
        this.effectQueue.clear();
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean isPlaying() {
        return !this.effectQueue.isEmpty();
    }

    private record RumbleEffectInstance(RumbleSource source, RumbleEffect effect) implements Comparable<RumbleEffectInstance>
    {
        @Override
        public int compareTo(@NotNull RumbleEffectInstance o) {
            return this.effect.compareTo(o.effect);
        }
    }
}

