/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify.fixes;

import java.util.Locale;

public enum OS {
    WINDOWS("debugify.os.windows"),
    MAC("debugify.os.macos"),
    LINUX("debugify.os.linux"),
    SOLARIS("debugify.os.solaris"),
    UNKNOWN("debugify.os.unknown");

    private final String displayName;

    public static OS getOperatingSystem() {
        String string = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (string.contains("win")) {
            return WINDOWS;
        }
        if (string.contains("mac")) {
            return MAC;
        }
        if (string.contains("solaris")) {
            return SOLARIS;
        }
        if (string.contains("sunos")) {
            return SOLARIS;
        }
        if (string.contains("linux")) {
            return LINUX;
        }
        return string.contains("unix") ? LINUX : UNKNOWN;
    }

    private OS(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

