/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.leaf;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.leaf.LeafBreakingSchedule;
import fr.rakambda.fallingtree.common.wrapper.DirectionCompat;
import fr.rakambda.fallingtree.common.wrapper.IBlock;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.IChunk;
import fr.rakambda.fallingtree.common.wrapper.IChunkPos;
import fr.rakambda.fallingtree.common.wrapper.IServerLevel;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class LeafBreakingHandler {
    private final Set<LeafBreakingSchedule> scheduledLeavesBreaking = ConcurrentHashMap.newKeySet();
    @NotNull
    private final FallingTreeCommon<?> mod;

    public void onServerTick() {
        Iterator<LeafBreakingSchedule> leavesBreak = this.scheduledLeavesBreaking.iterator();
        while (leavesBreak.hasNext()) {
            IChunk chunk;
            IChunkPos chunkPos;
            LeafBreakingSchedule leafBreakingSchedule = leavesBreak.next();
            if (leafBreakingSchedule.getRemainingTicks() > 0) {
                leafBreakingSchedule.tick();
                continue;
            }
            IServerLevel level = leafBreakingSchedule.getLevel();
            if (level.hasChunk((chunkPos = (chunk = level.getChunk(leafBreakingSchedule.getBlockPos())).getPos()).getX(), chunkPos.getZ())) {
                IBlockState state = level.getBlockState(leafBreakingSchedule.getBlockPos());
                state.tick(level, leafBreakingSchedule.getBlockPos(), level.getRandom());
                if (state.isRandomlyTicking()) {
                    state.randomTick(level, leafBreakingSchedule.getBlockPos(), level.getRandom());
                }
            }
            leavesBreak.remove();
        }
    }

    public void onBlockUpdate(@NotNull IServerLevel level, @NotNull IBlockPos eventPos, @NotNull IBlockState eventState, Set<DirectionCompat> directions) {
        if (!this.mod.getConfiguration().getTrees().isLeavesBreaking()) {
            return;
        }
        if (!level.isServer()) {
            return;
        }
        IBlock eventBlock = eventState.getBlock();
        if (!eventBlock.isAir()) {
            return;
        }
        for (DirectionCompat direction : directions) {
            IBlockState neighborState;
            IBlockPos neighborPos = eventPos.relative(direction);
            IChunk chunk = level.getChunk(neighborPos);
            IChunkPos chunkPos = chunk.getPos();
            if (!level.hasChunk(chunkPos.getX(), chunkPos.getZ()) || !this.mod.isLeafBlock((neighborState = level.getBlockState(neighborPos)).getBlock())) continue;
            this.addSchedule(new LeafBreakingSchedule(level, neighborPos, 4));
        }
    }

    public void addSchedule(@NotNull LeafBreakingSchedule schedule) {
        this.scheduledLeavesBreaking.add(schedule);
    }

    public void onWorldUnload(@NotNull IServerLevel level) {
        this.scheduledLeavesBreaking.removeIf(leafBreakingSchedule -> Objects.equals(level.getRaw(), leafBreakingSchedule.getLevel().getRaw()));
    }

    public LeafBreakingHandler(@NotNull FallingTreeCommon<?> mod) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        this.mod = mod;
    }
}

