/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class MoonHandler {
    private static String moonID = null;
    private static float[] moonColor = null;
    private static Matrix4f moonScale;
    private static class_2960 moonTexture;

    public static void colorTheMoon(class_638 level, class_4587 poseStack, Matrix4f matrix4f, float f, class_4184 camera) {
        if (MoonHandler.isEventActive()) {
            RenderSystem.setShaderColor((float)moonColor[0], (float)moonColor[1], (float)moonColor[2], (float)1.0f);
        }
    }

    public static void setMoon(String eventID, int color, float scale) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        moonColor = new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
        moonID = eventID;
        if (scale != 1.0f) {
            moonScale = new Matrix4f().translation(scale, 1.0f, scale);
        }
    }

    public static void setMoonTexture(@Nullable class_2960 location) {
        moonTexture = location;
    }

    public static void disableMoon() {
        moonColor = null;
        moonID = null;
        moonScale = null;
        moonTexture = null;
    }

    public static boolean isEventActive() {
        return moonID != null && moonColor != null;
    }

    public static boolean isMoonScaled() {
        return moonScale != null;
    }

    public static class_2960 getMoonTexture(class_2960 defaultTexture) {
        if (moonTexture != null) {
            return moonTexture;
        }
        return defaultTexture;
    }

    public static Matrix4f getMoonScale() {
        return moonScale;
    }
}

