/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.registry.events;

import com.mrbysco.lunar.api.LunarEvent;
import com.mrbysco.lunar.handler.result.EventResult;
import com.mrbysco.lunar.platform.Services;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_5819;

public class BloodMoonEvent
extends LunarEvent {
    private static final UUID DAMAGE_MODIFIER_UUID = UUID.fromString("2f00d1d5-a4aa-4c2f-bb48-1d6570507666");
    private static final UUID HEALTH_MODIFIER_UUID = UUID.fromString("267db29a-2a6f-4c9d-b3c8-512c085bdf21");

    public BloodMoonEvent() {
        super(new class_2960("lunar", "blood_moon"), 0x882E2E);
    }

    @Override
    public int spawnWeight() {
        return Services.PLATFORM.getBloodMoonWeight();
    }

    @Override
    public String getTranslationKey() {
        return "lunar.event.blood_moon";
    }

    @Override
    public boolean applySpawnEffect() {
        return true;
    }

    @Override
    public void applySpawnEffect(class_1309 livingEntity, class_3730 spawnType) {
        if (spawnType == class_3730.field_16459) {
            class_1324 healthAttribute;
            float difficultyMultiplier = livingEntity.method_37908().method_8404(livingEntity.method_24515()).method_5458();
            class_5819 random = livingEntity.method_6051();
            class_1324 attackAttribute = livingEntity.method_5996(class_5134.field_23721);
            if (attackAttribute != null) {
                int damageBoost = 0;
                if (difficultyMultiplier > 0.0f) {
                    int i = (int)Math.floor(2.0f * difficultyMultiplier);
                    int n = damageBoost = i > 0 ? random.method_43048(i) : 0;
                }
                if (damageBoost > 0) {
                    attackAttribute.method_26837(new class_1322(DAMAGE_MODIFIER_UUID, "Blood moon damage boost", (double)damageBoost, class_1322.class_1323.field_6328));
                }
            }
            if ((healthAttribute = livingEntity.method_5996(class_5134.field_23716)) != null) {
                int healthBoost = 0;
                if (difficultyMultiplier > 0.0f) {
                    int i = (int)Math.floor(2.0f * difficultyMultiplier);
                    int n = healthBoost = i > 0 ? random.method_43048(i) : 0;
                }
                if (healthBoost > 0) {
                    healthAttribute.method_26837(new class_1322(HEALTH_MODIFIER_UUID, "Blood moon health boost", (double)healthBoost, class_1322.class_1323.field_6328));
                }
            }
        }
    }

    @Override
    public void stopEffects(class_1937 level) {
        if (!level.field_9236) {
            class_3218 serverLevel = (class_3218)level;
            for (class_1297 entity : serverLevel.method_27909()) {
                class_1324 healthAttribute;
                class_1309 livingEntity;
                if (!(entity instanceof class_1309) || !(livingEntity = (class_1309)entity).method_5805()) continue;
                class_1324 attackAttribute = livingEntity.method_5996(class_5134.field_23721);
                if (attackAttribute != null) {
                    attackAttribute.method_27304(DAMAGE_MODIFIER_UUID);
                }
                if ((healthAttribute = livingEntity.method_5996(class_5134.field_23716)) == null) continue;
                healthAttribute.method_27304(HEALTH_MODIFIER_UUID);
            }
        }
    }

    @Override
    public EventResult canSleep(class_1657 player, class_2338 sleepingLocation) {
        return EventResult.DEFAULT;
    }
}

