/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.config;

import com.aizistral.nochatreports.common.config.NCRConfig;
import com.aizistral.nochatreports.common.core.ServerSafetyState;
import com.aizistral.nochatreports.common.core.SigningMode;
import com.aizistral.nochatreports.common.gui.FontHelper;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.class_124;
import net.minecraft.class_2477;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_437;

public final class ClothConfigIntegration {
    public static final boolean ACTIVE;

    private ClothConfigIntegration() {
        throw new IllegalStateException("Can't touch this");
    }

    private static String translateKey(String key) {
        return class_2477.method_10517().method_48307(key);
    }

    private static class_2561[] wrapTooltip(String text) {
        List<String> list = FontHelper.wrap(class_310.method_1551().field_1772, text, 250);
        class_2561[] tooltip = new class_2561[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            tooltip[i] = class_2561.method_43470((String)list.get(i));
        }
        return tooltip;
    }

    private static class_2561[] makeTooltip(String key) {
        return ClothConfigIntegration.wrapTooltip(ClothConfigIntegration.translateKey(key));
    }

    public static class_437 getConfigScreen(class_437 parent) {
        return Internal.getConfigScreen(parent);
    }

    static {
        boolean ccp;
        try {
            Class.forName("me.shedaniel.clothconfig2.api.AbstractConfigListEntry");
            ccp = true;
        }
        catch (Throwable ex) {
            ccp = false;
        }
        ACTIVE = ccp;
    }

    private static class Internal {
        private Internal() {
        }

        protected static class_437 getConfigScreen(class_437 parent) {
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen(class_310.method_1551().field_1755).setTitle((class_2561)class_2561.method_43471((String)"configuration.NoChatReports.config"));
            ConfigCategory client = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"configuration.NoChatReports.category.client"));
            ConfigCategory lan = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"configuration.NoChatReports.category.lan"));
            ConfigEntryBuilder entryBuilder = builder.entryBuilder();
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.NoChatReports.enableMod"), NCRConfig.getClient().enableMod).setDefaultValue(true).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.enableMod.tooltip")).setSaveConsumer(newValue -> ServerSafetyState.scheduleResetAction(() -> {
                NCRConfig.getClient().enableMod = newValue;
                NCRConfig.getClient().saveFile();
            })).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.NoChatReports.showNCRButton"), NCRConfig.getClient().showNCRButton).setDefaultValue(true).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.showNCRButton.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().showNCRButton = newValue;
            }).build());
            String signingTooltip = ClothConfigIntegration.translateKey("option.NoChatReports.defaultSigningMode.tooltip") + "\n ";
            for (SigningMode mode2 : SigningMode.values()) {
                if (!mode2.isSelectableGlobally()) continue;
                signingTooltip = signingTooltip + "\n\n";
                signingTooltip = signingTooltip + class_124.field_1075;
                signingTooltip = signingTooltip + class_124.field_1067;
                signingTooltip = signingTooltip + class_124.field_1073;
                signingTooltip = signingTooltip + ClothConfigIntegration.translateKey(mode2.getNameKey());
                signingTooltip = signingTooltip + class_124.field_1070;
                signingTooltip = signingTooltip + "\n";
                signingTooltip = signingTooltip + ClothConfigIntegration.translateKey(mode2.getTooltipKey());
            }
            client.addEntry((AbstractConfigListEntry)entryBuilder.startStringDropdownMenu((class_2561)class_2561.method_43471((String)"option.NoChatReports.defaultSigningMode"), NCRConfig.getClient().defaultSigningMode.getName().getString()).setTooltip(ClothConfigIntegration.wrapTooltip(signingTooltip)).setDefaultValue((Object)SigningMode.PROMPT.getName().getString()).setSelections(Stream.of(SigningMode.values()).filter(SigningMode::isSelectableGlobally).map(mode -> mode.getName().getString()).toList()).setSaveConsumer(newValue -> {
                NCRConfig.getClient().defaultSigningMode = Arrays.stream(SigningMode.values()).filter(mode -> mode.getName().getString().equals(newValue)).findFirst().get();
            }).setSuggestionMode(false).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.NoChatReports.showReloadButton"), NCRConfig.getClient().showReloadButton).setDefaultValue(true).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.showReloadButton.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().showReloadButton = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.NoChatReports.verifiedIconEnabled"), NCRConfig.getClient().verifiedIconEnabled).setDefaultValue(true).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.verifiedIconEnabled.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().verifiedIconEnabled = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)class_2561.method_43471((String)"option.NoChatReports.verifiedIconOffsetX"), NCRConfig.getClient().verifiedIconOffsetX).setDefaultValue(0).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.verifiedIconOffsetX.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().verifiedIconOffsetX = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)class_2561.method_43471((String)"option.NoChatReports.verifiedIconOffsetY"), NCRConfig.getClient().verifiedIconOffsetY).setDefaultValue(0).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.verifiedIconOffsetY.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().verifiedIconOffsetY = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43471((String)"gui.NoChatReports.showEncryptionButtonWarning")).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.NoChatReports.showEncryptionButton"), NCRConfig.getEncryption().showEncryptionButton).setDefaultValue(true).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.showEncryptionButton.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getEncryption().showEncryptionButton = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.NoChatReports.showEncryptionIndicators"), NCRConfig.getEncryption().showEncryptionIndicators).setDefaultValue(true).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.showEncryptionIndicators.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getEncryption().showEncryptionIndicators = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.NoChatReports.showServerSafety"), NCRConfig.getClient().showServerSafety).setDefaultValue(true).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.showServerSafety.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().showServerSafety = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43471((String)"option.NoChatReports.showServerSafety.moreInfo").method_27694(s -> s.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"https://github.com/Aizistral-Studios/No-Chat-Reports/wiki/Configuration-Files/#option-showserversafety"))).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://github.com/Aizistral-Studios/No-Chat-Reports/wiki/Configuration-Files/#option-showserversafety")))).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.NoChatReports.hideInsecureMessageIndicators"), NCRConfig.getClient().hideInsecureMessageIndicators).setDefaultValue(true).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.hideInsecureMessageIndicators.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().hideInsecureMessageIndicators = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.NoChatReports.hideModifiedMessageIndicators"), NCRConfig.getClient().hideModifiedMessageIndicators).setDefaultValue(true).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.hideModifiedMessageIndicators.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().hideModifiedMessageIndicators = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.NoChatReports.hideSystemMessageIndicators"), NCRConfig.getClient().hideSystemMessageIndicators).setDefaultValue(true).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.hideSystemMessageIndicators.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().hideSystemMessageIndicators = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.NoChatReports.hideWarningToast"), NCRConfig.getClient().hideWarningToast).setDefaultValue(true).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.hideWarningToast.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().hideWarningToast = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.NoChatReports.hideSigningRequestMessage"), NCRConfig.getClient().hideSigningRequestMessage).setDefaultValue(false).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.hideSigningRequestMessage.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().hideSigningRequestMessage = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.NoChatReports.alwaysHideReportButton"), NCRConfig.getClient().alwaysHideReportButton).setDefaultValue(false).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.alwaysHideReportButton.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().alwaysHideReportButton = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.NoChatReports.demandOnServer"), NCRConfig.getClient().demandOnServer).setDefaultValue(false).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.demandOnServer.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().demandOnServer = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.NoChatReports.enableDebugLog"), NCRConfig.getCommon().enableDebugLog).setDefaultValue(false).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.enableDebugLog.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getCommon().enableDebugLog = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.NoChatReports.disableTelemetry"), NCRConfig.getClient().disableTelemetry).setDefaultValue(true).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.disableTelemetry.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().disableTelemetry = newValue;
            }).build());
            lan.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.NoChatReports.demandOnClient"), NCRConfig.getCommon().demandOnClient).setDefaultValue(false).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.demandOnClient.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getCommon().demandOnClient = newValue;
            }).build());
            lan.addEntry((AbstractConfigListEntry)entryBuilder.startStrField((class_2561)class_2561.method_43471((String)"option.NoChatReports.demandOnClientMessage"), NCRConfig.getCommon().demandOnClientMessage).setDefaultValue(NCRConfig.getCommon().demandOnClientMessage).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.demandOnClientMessage.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getCommon().demandOnClientMessage = newValue;
            }).build());
            lan.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.NoChatReports.convertToGameMessage"), NCRConfig.getCommon().convertToGameMessage).setDefaultValue(true).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.convertToGameMessage.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getCommon().convertToGameMessage = newValue;
            }).build());
            lan.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"option.NoChatReports.addQueryData"), NCRConfig.getCommon().addQueryData).setDefaultValue(true).setTooltip(ClothConfigIntegration.makeTooltip("option.NoChatReports.addQueryData.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getCommon().addQueryData = newValue;
            }).build());
            builder.setSavingRunnable(NCRConfig::save);
            return builder.build();
        }
    }
}

